/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.javadoc;

import com.liferay.portal.javadoc.JavadocUtil;
import com.liferay.portal.kernel.javadoc.BaseJavadoc;
import com.liferay.portal.kernel.javadoc.EmptyJavadocMethod;
import com.liferay.portal.kernel.javadoc.JavadocClass;
import com.liferay.portal.kernel.javadoc.JavadocManager;
import com.liferay.portal.kernel.javadoc.JavadocMethod;
import com.liferay.portal.kernel.javadoc.JavadocMethodImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@DoPrivileged
public class JavadocManagerImpl
implements JavadocManager {
    private static final Log _log = LogFactoryUtil.getLog(JavadocManagerImpl.class);
    private final Map<Class<?>, JavadocClass> _javadocClasses = new HashMap();
    private final Map<Method, JavadocMethod> _javadocMethods = new HashMap<Method, JavadocMethod>();

    public void load(String servletContextName, ClassLoader classLoader) {
        Document document;
        if (!PropsValues.JAVADOC_MANAGER_ENABLED) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loading Javadocs for \"" + servletContextName + '\"'));
        }
        if ((document = this.getDocument(classLoader)) == null) {
            return;
        }
        this.parseDocument(servletContextName, classLoader, document);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loaded Javadocs for \"" + servletContextName + '\"'));
        }
    }

    public JavadocClass lookupJavadocClass(Class<?> clazz) {
        return this._javadocClasses.get(clazz);
    }

    public JavadocMethod lookupJavadocMethod(Method method) {
        block7: {
            JavadocMethod javadocMethod = this._javadocMethods.get(method);
            if (javadocMethod != null) {
                return javadocMethod;
            }
            Class<?> clazz = method.getDeclaringClass();
            String className = clazz.getName();
            if (!className.contains(".service.") || !className.endsWith("ServiceUtil")) {
                return null;
            }
            String implClassName = StringUtil.replace((String)className, (String[])new String[]{".service.", "ServiceUtil"}, (String[])new String[]{".service.impl.", "ServiceImpl"});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Attempting to load method from class ", implClassName, " instead of ", className}));
            }
            try {
                Class<?> implClass = JavadocUtil.loadClass(clazz.getClassLoader(), implClassName);
                Method implMethod = implClass.getMethod(method.getName(), method.getParameterTypes());
                return this._javadocMethods.get(implMethod);
            }
            catch (NoSuchMethodException nsme) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to load method ", method.getName(), " from class ", implClassName}));
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to load implementation class " + implClassName));
            }
        }
        return null;
    }

    public void unload(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unloading Javadocs for \"" + servletContextName + '\"'));
        }
        this.unload(servletContextName, this._javadocClasses.values());
        this.unload(servletContextName, this._javadocMethods.values());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unloaded Javadocs for \"" + servletContextName + '\"'));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document getDocument(ClassLoader classLoader) {
        try {
            URL url = classLoader.getResource("META-INF/javadocs-rt.xml");
            if (url == null) {
                return null;
            }
            try (InputStream inputStream = url.openStream();){
                Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true);
                return document;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected void parseDocument(String servletContextName, ClassLoader classLoader, Document document) {
        Element rootElement = document.getRootElement();
        List javadocElements = rootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            Class<?> clazz = null;
            try {
                clazz = JavadocUtil.loadClass(classLoader, type);
            }
            catch (ClassNotFoundException cnfe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to load class " + type));
                continue;
            }
            String className = clazz.getName();
            if (className.endsWith("LocalServiceImpl")) continue;
            JavadocClass javadocClass = this.parseJavadocClass(servletContextName, javadocElement, clazz);
            this._javadocClasses.put(clazz, javadocClass);
            List methodElements = javadocElement.elements("method");
            for (Element methodElement : methodElements) {
                try {
                    JavadocMethod javadocMethod = this.parseJavadocMethod(servletContextName, clazz, methodElement);
                    if (javadocMethod == null) continue;
                    this._javadocMethods.put(javadocMethod.getMethod(), javadocMethod);
                }
                catch (Exception e) {
                    String methodName = methodElement.elementText("name");
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to load method ", methodName, " from class ", type}));
                }
            }
        }
    }

    protected JavadocClass parseJavadocClass(String servletContextName, Element javadocElement, Class<?> clazz) {
        List authorElements = javadocElement.elements("author");
        String[] authors = new String[authorElements.size()];
        for (int i = 0; i < authorElements.size(); ++i) {
            Element authorElement = (Element)authorElements.get(i);
            authors[i] = authorElement.getText();
        }
        return new JavadocClass(servletContextName, javadocElement.elementText("comment"), clazz, authors);
    }

    protected JavadocMethod parseJavadocMethod(String servletContextName, Class<?> clazz, Element methodElement) throws Exception {
        String name = methodElement.elementText("name");
        if (name.equals(clazz.getSimpleName()) || name.startsWith("_")) {
            return null;
        }
        List paramElements = methodElement.elements("param");
        Class[] parameterTypeClasses = new Class[paramElements.size()];
        String[] parameterComments = new String[paramElements.size()];
        for (int i = 0; i < paramElements.size(); ++i) {
            String parameterComment;
            Class<?> parametarTypeClass;
            Element paramElement = (Element)paramElements.get(i);
            String parameterType = paramElement.elementText("type");
            parameterTypeClasses[i] = parametarTypeClass = JavadocUtil.loadClass(clazz.getClassLoader(), parameterType);
            parameterComments[i] = parameterComment = paramElement.elementText("comment");
        }
        Method method = clazz.getDeclaredMethod(name, parameterTypeClasses);
        String comment = methodElement.elementText("comment");
        if (Validator.isNull((String)comment)) {
            return new EmptyJavadocMethod(servletContextName, method);
        }
        String returnComment = null;
        Element returnElement = methodElement.element("return");
        if (returnElement != null) {
            returnComment = returnElement.elementText("comment");
        }
        List throwsElements = methodElement.elements("throws");
        String[] throwsComments = new String[throwsElements.size()];
        for (int i = 0; i < throwsElements.size(); ++i) {
            Element throwElement = (Element)throwsElements.get(i);
            throwsComments[i] = throwElement.elementText("comment");
        }
        return new JavadocMethodImpl(servletContextName, comment, method, parameterComments, returnComment, throwsComments);
    }

    protected void unload(String servletContextName, Collection<? extends BaseJavadoc> collection) {
        Iterator<? extends BaseJavadoc> iterator = collection.iterator();
        while (iterator.hasNext()) {
            BaseJavadoc javadoc = iterator.next();
            if (!servletContextName.equals(javadoc.getServletContextName())) continue;
            iterator.remove();
        }
    }
}

