/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.xml.XMLMerger;
import com.liferay.util.xml.XMLTypeDetector;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLMergerRunner {
    private static final String _AUTO_DESCRIPTOR = "auto";
    private final String _descriptorClassName;

    public XMLMergerRunner(String descriptorClassName) {
        this._descriptorClassName = Validator.isNotNull((String)descriptorClassName) ? descriptorClassName : _AUTO_DESCRIPTOR;
    }

    public void mergeAndSave(File masterFile, File slaveFile, File mergedFile) throws ClassNotFoundException, DocumentException, IllegalAccessException, InstantiationException, IOException {
        String xml1 = FileUtil.read((File)masterFile);
        String xml2 = FileUtil.read((File)slaveFile);
        String mergedXml = this._merge(xml1, xml2);
        FileUtil.write((File)mergedFile, (String)mergedXml);
    }

    public void mergeAndSave(String masterFile, String slaveFile, String mergedFile) throws ClassNotFoundException, DocumentException, IllegalAccessException, InstantiationException, IOException {
        this.mergeAndSave(new File(masterFile), new File(slaveFile), new File(mergedFile));
    }

    private String _documentToString(Document doc, String docType) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndent("\t");
        format.setLineSeparator("\n");
        XMLWriter writer = new XMLWriter((OutputStream)unsyncByteArrayOutputStream, format);
        writer.write(doc);
        String xml = unsyncByteArrayOutputStream.toString();
        int pos = xml.indexOf("<?");
        String header = xml.substring(pos, xml.indexOf("?>", pos) + 2);
        xml = StringUtil.replace((String)xml, (String)header, (String)"");
        xml = StringBundler.concat((String[])new String[]{header, "\n", docType, "\n", xml});
        return xml;
    }

    private String _merge(String masterXml, String slaveXml) throws ClassNotFoundException, DocumentException, IllegalAccessException, InstantiationException, IOException {
        int pos = masterXml.indexOf("<!DOCTYPE");
        String masterDoctype = "";
        if (pos >= 0) {
            masterDoctype = masterXml.substring(pos, masterXml.indexOf(">", pos) + 1);
            masterXml = StringUtil.replace((String)masterXml, (String)masterDoctype, (String)"");
        }
        pos = slaveXml.indexOf("<!DOCTYPE");
        String slaveDoctype = "";
        if (pos >= 0) {
            slaveDoctype = slaveXml.substring(pos, slaveXml.indexOf(">", pos) + 1);
            slaveXml = StringUtil.replace((String)slaveXml, (String)slaveDoctype, (String)"");
        }
        String doctype = null;
        doctype = Validator.isNotNull((String)masterDoctype) ? masterDoctype : slaveDoctype;
        SAXReader reader = new SAXReader();
        Document masterDoc = reader.read((Reader)new UnsyncStringReader(masterXml));
        Document slaveDoc = reader.read((Reader)new UnsyncStringReader(slaveXml));
        XMLDescriptor descriptor = null;
        if (this._descriptorClassName.equals(_AUTO_DESCRIPTOR)) {
            descriptor = XMLTypeDetector.determineType(doctype, masterDoc);
        } else {
            Class<?> clazz = Class.forName(this._descriptorClassName);
            descriptor = (XMLDescriptor)clazz.newInstance();
        }
        XMLMerger merger = new XMLMerger(descriptor);
        Document mergedDoc = merger.merge(masterDoc, slaveDoc);
        return this._documentToString(mergedDoc, doctype);
    }
}

