/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class ProxyUtil {
    private static final Class<?>[] _argumentsClazz = new Class[]{InvocationHandler.class};
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<LookupKey, Class<?>>> _classReferences = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final ConcurrentMap<Class<?>, Constructor<?>> _constructors = new ConcurrentReferenceKeyHashMap((Map)new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final Field _invocationHandlerField;

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!ProxyUtil.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("Not a proxy instance");
        }
        try {
            return (InvocationHandler)_invocationHandlerField.get(proxy);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... interfaceClasses) {
        LookupKey lookupKey;
        Class<?> clazz;
        ConcurrentMap oldClassReferences;
        ConcurrentMap classReferences = (ConcurrentMap)_classReferences.get(classLoader);
        if (classReferences == null && (oldClassReferences = _classReferences.putIfAbsent(classLoader, classReferences = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY))) != null) {
            classReferences = oldClassReferences;
        }
        if ((clazz = (Class<?>)classReferences.get(lookupKey = new LookupKey(interfaceClasses))) == null) {
            ConcurrentMap concurrentMap = classReferences;
            synchronized (concurrentMap) {
                clazz = (Class)classReferences.get(lookupKey);
                if (clazz == null) {
                    clazz = Proxy.getProxyClass(classLoader, interfaceClasses);
                    classReferences.put(lookupKey, clazz);
                }
            }
        }
        if (!_constructors.containsKey(clazz)) {
            Constructor constructor = null;
            try {
                constructor = clazz.getConstructor(_argumentsClazz);
                constructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new InternalError(e.toString());
            }
            _constructors.putIfAbsent(clazz, constructor);
        }
        return clazz;
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return _constructors.containsKey(clazz);
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        Constructor constructor = (Constructor)_constructors.get(ProxyUtil.getProxyClass(classLoader, interfaces));
        try {
            return constructor.newInstance(invocationHandler);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    static {
        try {
            _invocationHandlerField = ReflectionUtil.getDeclaredField(Proxy.class, "h");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class LookupKey {
        private final int _hashCode;
        private final Class<?>[] _interfaces;

        public boolean equals(Object obj) {
            LookupKey lookupKey = (LookupKey)obj;
            if (this._interfaces.length != lookupKey._interfaces.length) {
                return false;
            }
            for (int i = 0; i < this._interfaces.length; ++i) {
                if (this._interfaces[i] == lookupKey._interfaces[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private LookupKey(Class<?>[] interfaces) {
            this._interfaces = interfaces;
            int hashCode = 0;
            for (Class<?> clazz : interfaces) {
                hashCode = HashUtil.hash(hashCode, clazz.getName());
            }
            this._hashCode = hashCode;
        }
    }
}

