/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class CacheResourceBundleLoader
implements ResourceBundleLoader {
    private static final Log _log = LogFactoryUtil.getLog(CacheResourceBundleLoader.class);
    private static final ResourceBundle _nullResourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object handleGetObject(String key) {
            throw new UnsupportedOperationException();
        }
    };
    private final ResourceBundleLoader _resourceBundleLoader;
    private final Map<String, ResourceBundle> _resourceBundles = new ConcurrentHashMap<String, ResourceBundle>();

    public CacheResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = resourceBundleLoader;
    }

    @Override
    public ResourceBundle loadResourceBundle(String languageId) {
        ResourceBundle resourceBundle = this._resourceBundles.get(languageId);
        if (resourceBundle == _nullResourceBundle) {
            return null;
        }
        if (resourceBundle == null) {
            block6: {
                try {
                    resourceBundle = this._resourceBundleLoader.loadResourceBundle(languageId);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug(e, e);
                }
            }
            if (resourceBundle == null) {
                this._resourceBundles.put(languageId, _nullResourceBundle);
            } else {
                this._resourceBundles.put(languageId, resourceBundle);
            }
        }
        return resourceBundle;
    }
}

