/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.Function;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFunction
implements Function<String, ServiceContext> {
    private final PortletRequest _portletRequest;
    private final HttpServletRequest _request;

    public ServiceContextFunction(HttpServletRequest request) {
        this._request = request;
        this._portletRequest = null;
    }

    public ServiceContextFunction(PortletRequest portletRequest) {
        this._portletRequest = portletRequest;
        this._request = null;
    }

    @Override
    public ServiceContext apply(String className) {
        try {
            if (this._portletRequest != null) {
                return ServiceContextFactory.getInstance(className, this._portletRequest);
            }
            return ServiceContextFactory.getInstance(className, this._request);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }
}

