/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.Format;
import java.util.Calendar;

public class RecurrenceSerializer {
    public static String toCronText(Recurrence recurrence) {
        Calendar dtStart = recurrence.getDtStart();
        int frequency = recurrence.getFrequency();
        int interval = recurrence.getInterval();
        DayAndPosition[] byDay = recurrence.getByDay();
        int[] byMonthDay = recurrence.getByMonthDay();
        int[] byMonth = recurrence.getByMonth();
        String startDateSecond = String.valueOf(dtStart.get(13));
        String startDateMinute = String.valueOf(dtStart.get(12));
        int startDateHour = dtStart.get(10);
        if (dtStart.get(9) == 1) {
            startDateHour += 12;
        }
        String dayOfMonth = String.valueOf(dtStart.get(5));
        String month = String.valueOf(dtStart.get(2) + 1);
        String dayOfWeek = String.valueOf(dtStart.get(7));
        String year = String.valueOf(dtStart.get(1));
        if (frequency == 7) {
            dayOfWeek = "?";
        } else if (frequency == 3) {
            dayOfMonth = 1 + RecurrenceSerializer._getIntervalValue(interval, 3);
            month = "*";
            dayOfWeek = "?";
            year = "*";
            if (byDay != null) {
                dayOfMonth = "?";
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = dayOfWeek + ",";
                    }
                    dayOfWeek = dayOfWeek + RecurrenceSerializer.getDayOfWeek(byDay[i]);
                }
            }
        } else if (frequency == 4) {
            dayOfMonth = "?";
            month = "*";
            year = "*";
            if (byDay != null) {
                dayOfWeek = "";
                for (int i = 0; i < byDay.length; ++i) {
                    if (i > 0) {
                        dayOfWeek = dayOfWeek + ",";
                    }
                    dayOfWeek = dayOfWeek + RecurrenceSerializer.getDayOfWeek(byDay[i]);
                }
            }
            dayOfWeek = dayOfWeek + RecurrenceSerializer._getIntervalValue(interval, 4);
        } else if (frequency == 5) {
            dayOfMonth = "?";
            month = 1 + RecurrenceSerializer._getIntervalValue(interval, 5);
            dayOfWeek = "?";
            year = "*";
            if (byMonthDay != null && byMonthDay.length == 1) {
                dayOfMonth = String.valueOf(byMonthDay[0]);
            } else if (byDay != null && byDay.length == 1) {
                String pos = String.valueOf(byDay[0].getDayPosition());
                dayOfWeek = pos.equals("-1") ? RecurrenceSerializer.getDayOfWeek(byDay[0]) + "L" : RecurrenceSerializer.getDayOfWeek(byDay[0]) + "#" + pos;
            }
        } else if (frequency == 6) {
            dayOfMonth = "?";
            dayOfWeek = "?";
            year = year + RecurrenceSerializer._getIntervalValue(interval, 6);
            if (byMonth != null && byMonth.length == 1) {
                month = String.valueOf(byMonth[0] + 1);
                if (byMonthDay != null && byMonthDay.length == 1) {
                    dayOfMonth = String.valueOf(byMonthDay[0]);
                } else if (byDay != null && byDay.length == 1) {
                    String pos = String.valueOf(byDay[0].getDayPosition());
                    dayOfWeek = pos.equals("-1") ? RecurrenceSerializer.getDayOfWeek(byDay[0]) + "L" : RecurrenceSerializer.getDayOfWeek(byDay[0]) + "#" + pos;
                }
            }
        }
        StringBundler sb = new StringBundler(13);
        sb.append(startDateSecond);
        sb.append(" ");
        sb.append(startDateMinute);
        sb.append(" ");
        sb.append(startDateHour);
        sb.append(" ");
        sb.append(dayOfMonth);
        sb.append(" ");
        sb.append(month);
        sb.append(" ");
        sb.append(dayOfWeek);
        sb.append(" ");
        sb.append(year);
        return sb.toString();
    }

    protected static String getDayOfWeek(DayAndPosition dayPos) {
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.set(7, dayPos.getDayOfWeek());
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE", LocaleUtil.US);
        return StringUtil.toUpperCase(format.format(calendar));
    }

    private static String _getIntervalValue(int interval, int period) {
        if (interval <= 0 && period == 4) {
            return "";
        }
        if (interval <= 0) {
            return "/1";
        }
        return "/" + interval;
    }
}

