/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;

public class LineEndCharacterCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_END_LINE_CHARACTER = "end.line.character.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{172, 76, 23};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST;
        if (detailAST.getType() == 76 && ((parentAST = detailAST.getParent()).getType() == 159 || parentAST.getType() == 43 || parentAST.getType() == 8 || parentAST.getType() == 155 || parentAST.getType() == 181 || parentAST.getType() == 96 || parentAST.getType() == 136 || parentAST.getType() == 9 || parentAST.getType() == 42)) {
            return;
        }
        if (this._isAtLineEnd(detailAST)) {
            this.log(detailAST.getLineNo(), _MSG_INCORRECT_END_LINE_CHARACTER, new Object[]{detailAST.getText()});
        }
    }

    private boolean _isAtLineEnd(DetailAST detailAST) {
        String text;
        FileContents fileContents = this.getFileContents();
        String line = fileContents.getLine(detailAST.getLineNo() - 1);
        return line.endsWith(text = detailAST.getText()) && detailAST.getColumnNo() + text.length() == line.length();
    }
}

