/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.List;

public class ConcatCheck
extends BaseCheck {
    private static final String _MSG_COMBINE_LITERAL_STRINGS = "literal.string.combine";
    private static final String _MSG_INCORRECT_TABBING = "tabbing.incorrect";
    private static final String _MSG_INVALID_END_CHARACTER = "end.character.invalid";
    private static final String _MSG_INVALID_START_CHARACTER = "start.character.invalid";
    private static final String _MSG_MOVE_LITERAL_STRING = "literal.string.move";
    private int _maxLineLength = 80;

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15, 125};
    }

    public void setMaxLineLength(int maxLineLength) {
        this._maxLineLength = maxLineLength;
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() != 125) {
            List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "StringBundler", "concat");
            for (DetailAST methodCallAST : methodCallASTList) {
                this._checkConcatMethodCall(methodCallAST);
            }
            return;
        }
        this._checkPlusOperator(detailAST);
    }

    private void _checkConcatMethodCall(DetailAST methodCallAST) {
        DetailAST elistAST = methodCallAST.findFirstToken(34);
        DetailAST previousLiteralStringAST = null;
        for (DetailAST childAST = elistAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (childAST.getType() != 28) continue;
            DetailAST grandChildAST = childAST.getFirstChild();
            if (grandChildAST.getType() != 139) {
                previousLiteralStringAST = null;
                continue;
            }
            if (previousLiteralStringAST != null) {
                this._checkConcatMethodCallLiteralStrings(previousLiteralStringAST, grandChildAST);
            }
            previousLiteralStringAST = grandChildAST;
        }
    }

    private void _checkConcatMethodCallLiteralStrings(DetailAST literalStringAST1, DetailAST literalStringAST2) {
        String literalStringValue1 = literalStringAST1.getText();
        literalStringValue1 = literalStringValue1.substring(1, literalStringValue1.length() - 1);
        String literalStringValue2 = literalStringAST2.getText();
        literalStringValue2 = literalStringValue2.substring(1, literalStringValue2.length() - 1);
        if (literalStringAST1.getLineNo() == literalStringAST2.getLineNo()) {
            this.log(literalStringAST1.getLineNo(), _MSG_COMBINE_LITERAL_STRINGS, new Object[]{literalStringValue1, literalStringValue2});
            return;
        }
        this._checkLiteralStringStartAndEndCharacter(literalStringValue1, literalStringValue2, literalStringAST1.getLineNo());
        String line = this.getLine(literalStringAST1.getLineNo() - 1);
        int lineLength = CommonUtils.lengthExpandedTabs((String)line, (int)line.length(), (int)this.getTabWidth());
        int pos = this._getStringBreakPos(literalStringValue1, literalStringValue2, this._maxLineLength - lineLength);
        if (pos != -1) {
            this.log(literalStringAST2.getLineNo(), _MSG_MOVE_LITERAL_STRING, new Object[]{literalStringValue2.substring(0, pos + 1)});
        }
    }

    private void _checkLiteralStringStartAndEndCharacter(String literalString1, String literalString2, int lineCount) {
        if (literalString1.endsWith("/")) {
            this.log(lineCount, _MSG_INVALID_END_CHARACTER, new Object[]{Character.valueOf(literalString1.charAt(literalString1.length() - 1))});
        }
        if (literalString2.startsWith(" ") || !literalString1.endsWith(" ") && literalString2.matches("^[-:;.].*")) {
            this.log(lineCount + 1, _MSG_INVALID_START_CHARACTER, new Object[]{Character.valueOf(literalString2.charAt(0))});
        }
    }

    private void _checkPlusOperator(DetailAST detailAST) {
        String trimmedLine2;
        this._checkTabbing(detailAST);
        if (detailAST.getChildCount() != 2) {
            return;
        }
        DetailAST firstChild = detailAST.getFirstChild();
        String literalString1 = this._getLiteralString(firstChild);
        if (literalString1 == null) {
            return;
        }
        DetailAST lastChild = detailAST.getLastChild();
        String literalString2 = this._getLiteralString(lastChild);
        if (literalString2 == null) {
            return;
        }
        if (firstChild.getLineNo() == lastChild.getLineNo()) {
            this.log(firstChild.getLineNo(), _MSG_COMBINE_LITERAL_STRINGS, new Object[]{literalString1, literalString2});
            return;
        }
        if (this._isRegexPattern(detailAST)) {
            return;
        }
        this._checkLiteralStringStartAndEndCharacter(literalString1, literalString2, detailAST.getLineNo());
        String line1 = this.getLine(lastChild.getLineNo() - 2);
        String line2 = this.getLine(lastChild.getLineNo() - 1);
        if (this._getLeadingTabCount(line1) == this._getLeadingTabCount(line2)) {
            return;
        }
        int lineLength1 = CommonUtils.lengthExpandedTabs((String)line1, (int)line1.length(), (int)this.getTabWidth());
        if (lineLength1 + (trimmedLine2 = StringUtil.trim(line2)).length() - 4 <= this._maxLineLength) {
            this.log(lastChild.getLineNo(), _MSG_COMBINE_LITERAL_STRINGS, new Object[]{literalString1, literalString2});
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() == 125 && lineLength1 + literalString2.length() <= this._maxLineLength) {
            this.log(detailAST.getLineNo(), _MSG_COMBINE_LITERAL_STRINGS, new Object[]{literalString1, literalString2});
            return;
        }
        int pos = this._getStringBreakPos(literalString1, literalString2, this._maxLineLength - lineLength1);
        if (pos != -1) {
            this.log(lastChild.getLineNo(), _MSG_MOVE_LITERAL_STRING, new Object[]{literalString2.substring(0, pos + 1)});
        }
    }

    private void _checkTabbing(DetailAST detailAST) {
        int afterPlusLineNo;
        DetailAST afterPlusAST = detailAST.getLastChild();
        if (afterPlusAST.getType() == 77) {
            while (afterPlusAST.getType() != 76) {
                afterPlusAST = afterPlusAST.getPreviousSibling();
            }
        }
        if ((afterPlusLineNo = DetailASTUtil.getStartLine(afterPlusAST)) == detailAST.getLineNo()) {
            return;
        }
        String line1 = this.getLine(detailAST.getLineNo() - 1);
        String line2 = this.getLine(afterPlusLineNo - 1);
        int tabCount = this._getLeadingTabCount(line1);
        if (tabCount + 1 != this._getLeadingTabCount(line2)) {
            this.log(afterPlusLineNo, _MSG_INCORRECT_TABBING, new Object[]{tabCount + 1});
        }
    }

    private int _getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private String _getLiteralString(DetailAST detailAST) {
        DetailAST lastChild;
        String literalString = null;
        if (detailAST.getType() == 139) {
            literalString = detailAST.getText();
        } else if (detailAST.getType() == 125 && detailAST.getChildCount() == 2 && (lastChild = detailAST.getLastChild()).getType() == 139) {
            literalString = lastChild.getText();
        }
        if (literalString != null) {
            return literalString.substring(1, literalString.length() - 1);
        }
        return null;
    }

    private int _getStringBreakPos(String s1, String s2, int i) {
        if (s2.startsWith("/")) {
            int pos = s2.lastIndexOf("/", i);
            if (pos > 0) {
                return pos - 1;
            }
            return -1;
        }
        if (s1.endsWith("-")) {
            return Math.max(s2.lastIndexOf("-", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(".")) {
            return Math.max(s2.lastIndexOf(".", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(" ")) {
            return s2.lastIndexOf(" ", i - 1);
        }
        return -1;
    }

    private boolean _isRegexPattern(DetailAST detailAST) {
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() != 27) {
                continue;
            }
            DetailAST firstChild = parentAST.getFirstChild();
            if (firstChild.getType() != 59) {
                return false;
            }
            List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(firstChild, false, 58);
            if (nameASTList.size() != 2) {
                return false;
            }
            DetailAST classNameAST = nameASTList.get(0);
            DetailAST methodNameAST = nameASTList.get(1);
            String methodCallClassName = classNameAST.getText();
            String methodCallMethodName = methodNameAST.getText();
            return methodCallClassName.equals("Pattern") && methodCallMethodName.equals("compile");
        }
        return false;
    }
}

