/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class ConfigurationLoader {
    public static SourceFormatterConfiguration loadConfiguration(String fileName) throws Exception {
        SourceFormatterConfiguration sourceFormatterConfiguration = new SourceFormatterConfiguration();
        ClassLoader classLoader = ConfigurationLoader.class.getClassLoader();
        String content = StringUtil.read(classLoader.getResourceAsStream(fileName));
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        for (Element sourceProcessorElement : rootElement.elements("source-processor")) {
            String sourceProcessorName = sourceProcessorElement.attributeValue("name");
            for (Element checkElement : sourceProcessorElement.elements("check")) {
                SourceCheckConfiguration sourceCheckConfiguration = new SourceCheckConfiguration(checkElement.attributeValue("name"));
                boolean enabled = GetterUtil.getBoolean(checkElement.attributeValue("enabled"), true);
                sourceCheckConfiguration.setEnabled(enabled);
                for (Element propertyElement : checkElement.elements("property")) {
                    sourceCheckConfiguration.addAttribute(propertyElement.attributeValue("name"), propertyElement.attributeValue("value"));
                }
                sourceFormatterConfiguration.addSourceCheckConfiguration(sourceProcessorName, sourceCheckConfiguration);
            }
        }
        return sourceFormatterConfiguration;
    }
}

