/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLServiceFileCheck
extends BaseFileCheck {
    private static final String _SERVICE_FINDER_COLUMN_SORT_EXCLUDES = "service.finder.column.sort.excludes";
    private List<String> _pluginsInsideModulesDirectoryNames;
    private String _portalTablesContent;

    @Override
    public void init() throws Exception {
        this._pluginsInsideModulesDirectoryNames = this.getPluginsInsideModulesDirectoryNames();
        this._portalTablesContent = this.getContent("sql/portal-tables.sql", 7);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/service.xml")) {
            this._checkServiceXML(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkServiceXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        ServiceReferenceElementComparator serviceReferenceElementComparator = new ServiceReferenceElementComparator("entity");
        for (Element entityElement : rootElement.elements("entity")) {
            String entityName = entityElement.attributeValue("name");
            List<String> columnNames = this._getColumnNames(fileName, absolutePath, entityName);
            ServiceFinderColumnElementComparator serviceFinderColumnElementComparator = new ServiceFinderColumnElementComparator(columnNames);
            if (!this.isExcludedPath(_SERVICE_FINDER_COLUMN_SORT_EXCLUDES, absolutePath, entityName)) {
                for (Element finderElement : entityElement.elements("finder")) {
                    String finderName = finderElement.attributeValue("name");
                    this.checkElementOrder(fileName, finderElement, "finder-column", entityName + "#" + finderName, serviceFinderColumnElementComparator);
                }
            }
            this.checkElementOrder(fileName, entityElement, "finder", entityName, new ServiceFinderElementComparator(columnNames));
            this.checkElementOrder(fileName, entityElement, "reference", entityName, serviceReferenceElementComparator);
        }
        this.checkElementOrder(fileName, rootElement, "entity", null, new ElementComparator());
        this.checkElementOrder(fileName, rootElement.element("exceptions"), "exception", null, new ServiceExceptionElementComparator());
    }

    private List<String> _getColumnNames(String fileName, String absolutePath, String entityName) throws Exception {
        ArrayList<String> columnNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("create table " + entityName + "_? \\(\n([\\s\\S]*?)\n\\);");
        String tablesContent = this._getTablesContent(fileName, absolutePath);
        if (tablesContent == null) {
            return columnNames;
        }
        Matcher matcher = pattern.matcher(tablesContent);
        if (!matcher.find()) {
            return columnNames;
        }
        String tableContent = matcher.group(1);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(tableContent));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            line = StringUtil.trim(line);
            String columnName = line.substring(0, line.indexOf(32));
            columnName = StringUtil.replace(columnName, '_', "");
            columnNames.add(columnName);
        }
        return columnNames;
    }

    private String _getTablesContent(String fileName, String absolutePath) throws Exception {
        if (this.isPortalSource() && !this.isModulesFile(absolutePath, this._pluginsInsideModulesDirectoryNames)) {
            return this._portalTablesContent;
        }
        int pos = fileName.lastIndexOf(47);
        String moduleOrPluginFolder = fileName.substring(0, pos);
        String tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/src/main/resources/META-INF/sql/tables.sql"));
        if (tablesContent == null) {
            tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/src/META-INF/sql/tables.sql"));
        }
        if (tablesContent == null) {
            tablesContent = FileUtil.read(new File(moduleOrPluginFolder + "/sql/tables.sql"));
        }
        return tablesContent;
    }

    private class ServiceReferenceElementComparator
    extends ElementComparator {
        public ServiceReferenceElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element referenceElement1, Element referenceElement2) {
            String packageName2;
            String packageName1 = referenceElement1.attributeValue("package-path");
            if (!packageName1.equals(packageName2 = referenceElement2.attributeValue("package-path"))) {
                return packageName1.compareToIgnoreCase(packageName2);
            }
            String entityName1 = referenceElement1.attributeValue("entity");
            String entityName2 = referenceElement2.attributeValue("entity");
            return entityName1.compareToIgnoreCase(entityName2);
        }
    }

    private class ServiceFinderElementComparator
    extends ElementComparator {
        private final List<String> _columnNames;

        public ServiceFinderElementComparator(List<String> columnNames) {
            this._columnNames = columnNames;
        }

        @Override
        public int compare(Element finderElement1, Element finderElement2) {
            int finderColumnCount2;
            List finderColumnElements1 = finderElement1.elements("finder-column");
            List finderColumnElements2 = finderElement2.elements("finder-column");
            int finderColumnCount1 = finderColumnElements1.size();
            if (finderColumnCount1 != (finderColumnCount2 = finderColumnElements2.size())) {
                return finderColumnCount1 - finderColumnCount2;
            }
            for (int i = 0; i < finderColumnCount1; ++i) {
                int index2;
                Element finderColumnElement1 = (Element)finderColumnElements1.get(i);
                Element finderColumnElement2 = (Element)finderColumnElements2.get(i);
                String finderColumnName1 = finderColumnElement1.attributeValue("name");
                String finderColumnName2 = finderColumnElement2.attributeValue("name");
                int index1 = this._columnNames.indexOf(finderColumnName1);
                if (index1 == (index2 = this._columnNames.indexOf(finderColumnName2))) continue;
                return index1 - index2;
            }
            String finderName1 = finderElement1.attributeValue("name");
            String finderName2 = finderElement2.attributeValue("name");
            int startsWithWeight = StringUtil.startsWithWeight(finderName1, finderName2);
            String strippedFinderName1 = finderName1.substring(startsWithWeight);
            String strippedFinderName2 = finderName2.substring(startsWithWeight);
            if (strippedFinderName1.startsWith("Gt") || strippedFinderName1.startsWith("Like") || strippedFinderName1.startsWith("Lt") || strippedFinderName1.startsWith("Not")) {
                if (!(strippedFinderName2.startsWith("Gt") || strippedFinderName2.startsWith("Like") || strippedFinderName2.startsWith("Lt") || strippedFinderName2.startsWith("Not"))) {
                    return 1;
                }
                return strippedFinderName1.compareTo(strippedFinderName2);
            }
            return 0;
        }
    }

    private class ServiceFinderColumnElementComparator
    extends ElementComparator {
        private final List<String> _columnNames;

        public ServiceFinderColumnElementComparator(List<String> columnNames) {
            this._columnNames = columnNames;
        }

        @Override
        public int compare(Element finderColumnElement1, Element finderColumnElement2) {
            String finderColumnName1 = finderColumnElement1.attributeValue("name");
            String finderColumnName2 = finderColumnElement2.attributeValue("name");
            int index1 = this._columnNames.indexOf(finderColumnName1);
            int index2 = this._columnNames.indexOf(finderColumnName2);
            return index1 - index2;
        }
    }

    private class ServiceExceptionElementComparator
    extends ElementComparator {
        private ServiceExceptionElementComparator() {
        }

        @Override
        public String getElementName(Element exceptionElement) {
            return exceptionElement.getStringValue();
        }
    }
}

