/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSwitchCheck
extends BaseFileCheck {
    private final Pattern _switchStatementPattern = Pattern.compile("\tswitch \\(.*\\) \\{");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this.isSubrepository() || this.isReadOnly(absolutePath)) {
            return content;
        }
        Matcher matcher = this._switchStatementPattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Use 'if/else' statement instead of 'switch'", this.getLineCount(content, matcher.start()));
        }
        return content;
    }
}

