/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStringBundlerInitialCapacityCheck
extends BaseJavaTermCheck {
    private final Pattern _loopPattern = Pattern.compile("\t(do \\{|(for|while) \\()");
    private final Pattern _stringBundlerPattern = Pattern.compile("\n(\t+)(StringBundler )?(\\w+) = new StringBundler(\\(([0-9]+)?)\\);\n");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        return this._fixInitialCapacity(javaTerm.getContent());
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private int _adjustCount(int count, String varName, List<String> parts) {
        int max = 0;
        int total = 0;
        for (String part : parts) {
            if (part.contains(varName + ".append(") && part.contains("return")) {
                return -1;
            }
            int i = StringUtil.count(part, varName + ".append(");
            total += i;
            if (i <= max) continue;
            max = i;
        }
        return count - (total - max);
    }

    private String _fixInitialCapacity(String content) {
        Matcher matcher = this._stringBundlerPattern.matcher(content);
        while (matcher.find()) {
            int sbInitialCapacity;
            int count;
            int x;
            String line;
            String tabs = matcher.group(1);
            String varName = matcher.group(3);
            if (matcher.group(2) == null && !(line = this.getLine(content, this.getLineCount(content, x = content.lastIndexOf("StringBundler " + varName, matcher.start())))).startsWith(tabs) || (x = content.indexOf("\n" + tabs.substring(1) + "}", matcher.end())) == -1) continue;
            String s = content.substring(matcher.end(), x);
            x = s.indexOf("\t" + varName + " = new StringBundler");
            if (x != -1) {
                s = s.substring(0, x);
            }
            if (this._hasAppendCallInsideLoop(s, varName) || s.matches("(?s).*\\W" + varName + "([,)]|\\.index\\().*") || (count = this._getCount(s, varName)) == -1 || (sbInitialCapacity = GetterUtil.getInteger(matcher.group(5))) <= count && (sbInitialCapacity == count || s.contains(varName + ".setIndex"))) continue;
            return StringUtil.replaceFirst(content, matcher.group(4), "(" + String.valueOf(count), matcher.start());
        }
        return content;
    }

    private int _getCount(String s, String varName) {
        int count = StringUtil.count(s, varName + ".append(");
        int x = -1;
        do {
            int y = s.indexOf("\tif (", x + 1);
            int z = s.indexOf("\ttry {", x + 1);
            if (y != -1 && (z == -1 || z > y)) {
                count = this._adjustCount(count, varName, this._getIfElseStatementParts(s.substring(y)));
                x = y;
                continue;
            }
            if (z != -1) {
                count = this._adjustCount(count, varName, this._getTryCatchStatementParts(s.substring(z)));
                x = z;
                continue;
            }
            return count;
        } while (count != -1);
        return count;
    }

    private List<String> _getIfElseStatementParts(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        int x = -1;
        while ((x = s.indexOf("}", x + 1)) != -1) {
            String part;
            if (ToolsUtil.isInsideQuotes(s, x) || this.getLevel(part = s.substring(0, x + 1), "{", "}") != 0) continue;
            parts.add(part);
            s = StringUtil.trim(s.substring(x + 1));
            if (!s.startsWith("else ")) {
                return parts;
            }
            x = -1;
        }
        return parts;
    }

    private List<String> _getTryCatchStatementParts(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        int x = -1;
        while ((x = s.indexOf("}", x + 1)) != -1) {
            String part;
            if (ToolsUtil.isInsideQuotes(s, x) || this.getLevel(part = s.substring(0, x + 1), "{", "}") != 0) continue;
            parts.add(part);
            s = StringUtil.trim(s.substring(x + 1));
            if (!s.startsWith("catch ")) {
                return parts;
            }
            x = -1;
        }
        return parts;
    }

    private boolean _hasAppendCallInsideLoop(String s, String varName) {
        Matcher matcher = this._loopPattern.matcher(s);
        if (matcher.find()) {
            String insideLoop;
            int x;
            int y = x = matcher.start();
            do {
                if ((y = s.indexOf("}", y + 1)) != -1) continue;
                return true;
            } while (this.getLevel(insideLoop = s.substring(x, y + 1), "{", "}") != 0 || !insideLoop.contains(varName + ".append("));
            return true;
        }
        return false;
    }
}

