/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.util.XMLSourceUtil;
import java.util.List;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.testcase", "**/*.toggle", "**/*.xml", "**/definitions/liferay-*.xsd"};

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**", "**/javadocs-*.xml", "**/logs/**", "**/portal-impl/**/*.action", "**/portal-impl/**/*.function", "**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase", "**/src/test/**", "**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected boolean hasGeneratedTag(String content) {
        if (!content.contains("@generated")) {
            return false;
        }
        int pos = -1;
        do {
            if ((pos = content.indexOf("@generated", pos + 1)) != -1) continue;
            return false;
        } while (XMLSourceUtil.isInsideCDATAMarkup(content, pos));
        return true;
    }
}

