/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.TempAttributesServletRequest;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.LayoutTypeAccessPolicyTracker;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class SecurityPortletContainerWrapper
implements PortletContainer {
    private static final Log _log = LogFactoryUtil.getLog(SecurityPortletContainerWrapper.class);
    private final PortletContainer _portletContainer;

    public static PortletContainer createSecurityPortletContainerWrapper(PortletContainer portletContainer) {
        if (!SPIUtil.isSPI()) {
            portletContainer = new SecurityPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public SecurityPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(request, portlet);
    }

    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutRequest = this.getOwnerLayoutRequestWrapper(request, portlet);
            this.checkAction(ownerLayoutRequest, portlet);
            return this._portletContainer.processAction(request, response, portlet);
        }
        catch (PrincipalException pe) {
            return this.processActionException(request, response, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        return this._portletContainer.processEvent(request, response, portlet, layout, event);
    }

    public void processPublicRenderParameters(HttpServletRequest request, Layout layout) {
        this._portletContainer.processPublicRenderParameters(request, layout);
    }

    public void processPublicRenderParameters(HttpServletRequest request, Layout layout, Portlet portlet) {
        this._portletContainer.processPublicRenderParameters(request, layout, portlet);
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(request, portlet);
            this._portletContainer.render(request, response, portlet);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            this.processRenderException(request, response, portlet);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutRequest = this.getOwnerLayoutRequestWrapper(request, portlet);
            this.checkResource(ownerLayoutRequest, portlet);
            this._portletContainer.serveResource(request, response, portlet);
        }
        catch (PrincipalException pe) {
            this.processServeResourceException(request, response, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    protected void check(HttpServletRequest request, Portlet portlet) throws Exception {
        if (portlet == null) {
            return;
        }
        if (portlet.isUndeployedPortlet()) {
            return;
        }
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        LayoutTypeAccessPolicy layoutTypeAccessPolicy = LayoutTypeAccessPolicyTracker.getLayoutTypeAccessPolicy(layout);
        layoutTypeAccessPolicy.checkAccessAllowedToPortlet(request, layout, portlet);
    }

    protected void checkAction(HttpServletRequest request, Portlet portlet) throws Exception {
        this.checkCSRFProtection(request, portlet);
        this.check(request, portlet);
    }

    protected void checkCSRFProtection(HttpServletRequest request, Portlet portlet) throws PortalException {
        Map initParams = portlet.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        if (AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((HttpServletRequest)request, (Portlet)portlet)) {
            checkAuthToken = false;
        }
        if (checkAuthToken) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)SecurityPortletContainerWrapper.class.getName());
        }
    }

    protected void checkRender(HttpServletRequest request, Portlet portlet) throws Exception {
        this.check(request, portlet);
    }

    protected void checkResource(HttpServletRequest request, Portlet portlet) throws Exception {
        this.check(request, portlet);
    }

    protected String getOriginalURL(HttpServletRequest request) {
        LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return String.valueOf(request.getRequestURI());
        }
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        return portalURL.concat(lastPath.getContextPath()).concat(lastPath.getPath());
    }

    protected HttpServletRequest getOwnerLayoutRequestWrapper(HttpServletRequest request, Portlet portlet) throws Exception {
        if (!PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET || PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render")) {
            return request;
        }
        Layout ownerLayout = null;
        LayoutTypePortlet ownerLayoutTypePortlet = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
        List layoutTypePortlets = PortletContainerUtil.getLayoutTypePortlets((Layout)requestLayout);
        for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
            if (!layoutTypePortlet.hasPortletId(portlet.getPortletId())) continue;
            ownerLayoutTypePortlet = layoutTypePortlet;
            ownerLayout = layoutTypePortlet.getLayout();
            break;
        }
        if (ownerLayout == null) {
            return request;
        }
        Layout currentLayout = themeDisplay.getLayout();
        if (currentLayout.equals(ownerLayout)) {
            return request;
        }
        ThemeDisplay themeDisplayClone = (ThemeDisplay)themeDisplay.clone();
        themeDisplayClone.setLayout(ownerLayout);
        themeDisplayClone.setLayoutTypePortlet(ownerLayoutTypePortlet);
        TempAttributesServletRequest tempAttributesServletRequest = new TempAttributesServletRequest(request);
        tempAttributesServletRequest.setTempAttribute("LAYOUT", (Object)ownerLayout);
        tempAttributesServletRequest.setTempAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplayClone);
        return tempAttributesServletRequest;
    }

    @Deprecated
    protected boolean isValidPortletId(String portletId) {
        for (int i = 0; i < portletId.length(); ++i) {
            char c = portletId.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '#' || c == '_') continue;
            return false;
        }
        return true;
    }

    protected ActionResult processActionException(HttpServletRequest request, HttpServletResponse response, Portlet portlet, PrincipalException pe) {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)pe);
        }
        String url = this.getOriginalURL(request);
        if (_log.isWarnEnabled()) {
            _log.warn((Object)String.format("User %s is not allowed to access URL %s and portlet %s", PortalUtil.getUserId((HttpServletRequest)request), url, portlet.getPortletId()));
        }
        return ActionResult.EMPTY_ACTION_RESULT;
    }

    protected void processRenderException(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        String portletContent = null;
        if (portlet.isShowPortletAccessDenied()) {
            portletContent = "/html/portal/portlet_access_denied.jsp";
        }
        try {
            if (portletContent != null) {
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(portletContent);
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            throw new PortletContainerException((Throwable)e);
        }
    }

    protected void processServeResourceException(HttpServletRequest request, HttpServletResponse response, Portlet portlet, PrincipalException pe) {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)pe);
        }
        String url = this.getOriginalURL(request);
        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        response.setStatus(400);
        if (_log.isWarnEnabled()) {
            _log.warn((Object)String.format("User %s is not allowed to serve resource for % on %", PortalUtil.getUserId((HttpServletRequest)request), url, portlet.getPortletId()));
        }
    }
}

