/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;

public class VerifyRatings
extends VerifyProcess {
    private static final String _SQL_FROM_WHERE_CLAUSE = "from RatingsEntry where RatingsStats.classPK = RatingsEntry.classPK and RatingsStats.classNameId = RatingsEntry.classNameId group by classNameId, classPK";
    private static final String _SQL_UPDATE_AVERAGE_SCORE = "averageScore = coalesce((select sum(RatingsEntry.score) / count(1) from RatingsEntry where RatingsStats.classPK = RatingsEntry.classPK and RatingsStats.classNameId = RatingsEntry.classNameId group by classNameId, classPK), 0)";
    private static final String _SQL_UPDATE_TOTAL_ENTRIES = "totalEntries = coalesce((select count(1) from RatingsEntry where RatingsStats.classPK = RatingsEntry.classPK and RatingsStats.classNameId = RatingsEntry.classNameId group by classNameId, classPK), 0)";
    private static final String _SQL_UPDATE_TOTAL_SCORE = "totalScore = coalesce((select sum(RatingsEntry.score) from RatingsEntry where RatingsStats.classPK = RatingsEntry.classPK and RatingsStats.classNameId = RatingsEntry.classNameId group by classNameId, classPK), 0)";

    @Override
    protected void doVerify() throws Exception {
        this.normalizeRatingStats();
    }

    protected void normalizeRatingStats() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(6);
            sb.append("update RatingsStats set ");
            sb.append(_SQL_UPDATE_AVERAGE_SCORE);
            sb.append(", ");
            sb.append(_SQL_UPDATE_TOTAL_ENTRIES);
            sb.append(", ");
            sb.append(_SQL_UPDATE_TOTAL_SCORE);
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                ps.executeUpdate();
            }
        }
    }
}

