/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateLayouts();
    }

    protected void updateJavaScript(UnicodeProperties typeSettingsProperties, String javaScript1, String javaScript2, String javaScript3) {
        String javascript;
        StringBundler sb = new StringBundler(6);
        if (Validator.isNotNull((String)javaScript1)) {
            sb.append("// Custom JavaScript 1\n\n");
            sb.append(javaScript1);
            typeSettingsProperties.remove((Object)"javascript-1");
        }
        if (Validator.isNotNull((String)javaScript2)) {
            sb.append("\n\n\n // Custom JavaScript 2\n\n");
            sb.append(javaScript2);
            typeSettingsProperties.remove((Object)"javascript-2");
        }
        if (Validator.isNotNull((String)javaScript3)) {
            sb.append("\n\n\n // Custom JavaScript 3\n\n");
            sb.append(javaScript3);
            typeSettingsProperties.remove((Object)"javascript-3");
        }
        if (Validator.isNotNull((String)(javascript = sb.toString()))) {
            typeSettingsProperties.put("javascript", javascript);
        }
    }

    protected void updateLayout(long plid, long companyId, String name, String title, String typeSettings) throws Exception {
        String defaultRobots;
        String defaultKeywords;
        if (Validator.isNotNull((String)name)) {
            name = StringUtil.replace((String)name, (String[])new String[]{"<name", "</name>"}, (String[])new String[]{"<Name", "</Name>"});
            this.updateName(plid, name);
        }
        if (Validator.isNotNull((String)title)) {
            title = StringUtil.replace((String)title, (String[])new String[]{"<title", "</title>"}, (String[])new String[]{"<Title", "</Title>"});
            this.updateTitle(plid, title);
        }
        if (Validator.isNull((String)typeSettings)) {
            return;
        }
        String defaultLanguageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.load(typeSettings);
        String defaultDescription = typeSettingsProperties.getProperty("meta-description_" + defaultLanguageId);
        if (Validator.isNotNull((String)defaultDescription)) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-description_", "Description", "description");
        }
        if (Validator.isNotNull((String)(defaultKeywords = typeSettingsProperties.getProperty("meta-keywords_" + defaultLanguageId)))) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-keywords_", "Keywords", "keywords");
        }
        if (Validator.isNotNull((String)(defaultRobots = typeSettingsProperties.getProperty("meta-robots_" + defaultLanguageId)))) {
            typeSettingsProperties = this.updateMetaField(plid, typeSettingsProperties, "meta-robots_", "Robots", "robots");
        }
        String javaScript1 = typeSettingsProperties.getProperty("javascript-1");
        String javaScript2 = typeSettingsProperties.getProperty("javascript-2");
        String javaScript3 = typeSettingsProperties.getProperty("javascript-3");
        if (javaScript1 != null || javaScript2 != null || javaScript3 != null) {
            this.updateJavaScript(typeSettingsProperties, javaScript1, javaScript2, javaScript3);
        }
        this.updateTypeSettings(plid, typeSettingsProperties.toString());
    }

    protected void updateLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select plid, companyId, name, title, typeSettings from Layout");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long plid = rs.getLong("plid");
                long companyId = rs.getLong("companyId");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String typeSettings = rs.getString("typeSettings");
                this.updateLayout(plid, companyId, name, title, typeSettings);
            }
        }
    }

    protected UnicodeProperties updateMetaField(long plid, UnicodeProperties typeSettingsProperties, String propertyName, String xmlName, String columName) throws Exception {
        String xml = null;
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = typeSettingsProperties.getProperty(propertyName + languageId);
            if (!Validator.isNotNull((String)value)) continue;
            xml = LocalizationUtil.updateLocalization(xml, (String)xmlName, (String)value, (String)languageId);
            typeSettingsProperties.remove((Object)(propertyName + languageId));
        }
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update Layout set ", columName, " = ? where plid = ", String.valueOf(plid)}));){
            ps.setString(1, xml);
            ps.executeUpdate();
        }
        return typeSettingsProperties;
    }

    protected void updateName(long plid, String name) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set name = ? where plid = " + plid);){
            ps.setString(1, name);
            ps.executeUpdate();
        }
    }

    protected void updateTitle(long plid, String title) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set title = ? where plid = " + plid);){
            ps.setString(1, title);
            ps.executeUpdate();
        }
    }

    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
    }
}

