/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ThreadLocalFacadeHttpServletRequestWrapper
extends PersistentHttpServletRequestWrapper
implements Closeable {
    private static final ThreadLocal<HttpServletRequest> _nextHttpServletRequestThreadLocal = new CentralizedThreadLocal(ThreadLocalFacadeHttpServletRequestWrapper.class + "._nextHttpServletRequestThreadLocal", null, Function.identity(), true);
    private final List<Locale> _locales;
    private final ServletRequestWrapper _servletRequestWrapper;

    public ThreadLocalFacadeHttpServletRequestWrapper(ServletRequestWrapper servletRequestWrapper, HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this._servletRequestWrapper = servletRequestWrapper;
        _nextHttpServletRequestThreadLocal.set(httpServletRequest);
        this._locales = new ArrayList<Locale>();
        Enumeration enumeration = httpServletRequest.getLocales();
        while (enumeration.hasMoreElements()) {
            this._locales.add((Locale)enumeration.nextElement());
        }
    }

    @Override
    public void close() {
        if (this._servletRequestWrapper != null) {
            HttpServletRequest nextHttpServletRequest = _nextHttpServletRequestThreadLocal.get();
            this._servletRequestWrapper.setRequest((ServletRequest)nextHttpServletRequest);
        }
    }

    public Object getAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        ServletRequest servletRequest = this.getRequest();
        Lock lock = (Lock)servletRequest.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
        if (lock != null) {
            lock.lock();
        }
        try {
            Enumeration enumeration = servletRequest.getAttributeNames();
            return enumeration;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this._locales);
    }

    public ServletRequest getRequest() {
        return (ServletRequest)_nextHttpServletRequestThreadLocal.get();
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getRequestDispatcher(uri);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (!create || httpSession != null) {
            return httpSession;
        }
        ServletContext servletContext = httpServletRequest.getServletContext();
        synchronized (servletContext) {
            return httpServletRequest.getSession(true);
        }
    }

    public void removeAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.setAttribute(name, o);
    }

    public void setRequest(ServletRequest servletRequest) {
        _nextHttpServletRequestThreadLocal.set((HttpServletRequest)servletRequest);
    }
}

