/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.oauth;

import com.liferay.portal.kernel.oauth.OAuthException;
import com.liferay.portal.kernel.oauth.OAuthManager;
import com.liferay.portal.kernel.oauth.OAuthRequest;
import com.liferay.portal.kernel.oauth.Token;
import com.liferay.portal.oauth.TokenImpl;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuthManagerImpl
implements OAuthManager {
    private final OAuthService _oAuthService;

    public OAuthManagerImpl(String key, String secret, final String accessURL, final String requestURL, String callbackURL, String scope) {
        DefaultApi10a api = new DefaultApi10a(){

            public String getAccessTokenEndpoint() {
                return accessURL;
            }

            public String getRequestTokenEndpoint() {
                return requestURL;
            }
        };
        if (callbackURL == null) {
            callbackURL = "oob";
        }
        this._oAuthService = api.createService(key, secret, callbackURL, scope);
    }

    public Token getAccessToken(Token requestToken, com.liferay.portal.kernel.oauth.Verifier verifier) throws OAuthException {
        try {
            return new TokenImpl(this._oAuthService.getAccessToken((org.scribe.model.Token)requestToken.getWrappedToken(), (Verifier)verifier.getWrappedVerifier()));
        }
        catch (Exception e) {
            throw new OAuthException((Throwable)e);
        }
    }

    public Token getRequestToken() throws OAuthException {
        try {
            return new TokenImpl(this._oAuthService.getRequestToken());
        }
        catch (Exception e) {
            throw new OAuthException((Throwable)e);
        }
    }

    public String getVersion() throws OAuthException {
        try {
            return this._oAuthService.getVersion();
        }
        catch (Exception e) {
            throw new OAuthException((Throwable)e);
        }
    }

    public void signRequest(Token accessToken, OAuthRequest oAuthRequest) throws OAuthException {
        try {
            this._oAuthService.signRequest((org.scribe.model.Token)accessToken.getWrappedToken(), (org.scribe.model.OAuthRequest)oAuthRequest.getWrappedOAuthRequest());
        }
        catch (Exception e) {
            throw new OAuthException((Throwable)e);
        }
    }
}

