/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CompressionLevel {
    BEST_COMPRESSION(9),
    BEST_SPEED(1),
    DEFAULT_COMPRESSION(-1),
    LEVEL_2(2),
    LEVEL_3(3),
    LEVEL_4(4),
    LEVEL_5(5),
    LEVEL_6(6),
    LEVEL_7(7),
    LEVEL_8(8),
    NO_COMPRESSION(0);

    private static final Map<Integer, CompressionLevel> _compressionLevels;
    private final int _level;

    public static CompressionLevel getCompressionLevel(int level) {
        CompressionLevel compressionLevel = _compressionLevels.get(level);
        if (compressionLevel == null) {
            throw new IllegalArgumentException("Compression level " + level + " is not within the range of -1 and 9");
        }
        return compressionLevel;
    }

    public int getLevel() {
        return this._level;
    }

    private CompressionLevel(int level) {
        this._level = level;
    }

    static {
        _compressionLevels = new HashMap<Integer, CompressionLevel>();
        for (CompressionLevel compressionLevel : EnumSet.allOf(CompressionLevel.class)) {
            _compressionLevels.put(compressionLevel._level, compressionLevel);
        }
    }
}

