/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SerializableObjectWrapper
implements Externalizable {
    private static final Log _log = LogFactoryUtil.getLog(SerializableObjectWrapper.class);
    private volatile Serializable _serializable;

    public static <T> T unwrap(Object object) {
        if (!(object instanceof SerializableObjectWrapper)) {
            return (T)object;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        if (serializableWrapper._serializable instanceof LazySerializable) {
            LazySerializable lazySerializable = (LazySerializable)serializableWrapper._serializable;
            serializableWrapper._serializable = lazySerializable.getSerializable();
        }
        return (T)serializableWrapper._serializable;
    }

    public SerializableObjectWrapper() {
    }

    public SerializableObjectWrapper(Serializable serializable) {
        this._serializable = serializable;
    }

    public boolean equals(Object object) {
        LazySerializable lazySerializable;
        if (this == object) {
            return true;
        }
        if (!(object instanceof SerializableObjectWrapper)) {
            return false;
        }
        SerializableObjectWrapper serializableWrapper = (SerializableObjectWrapper)object;
        if (this._serializable instanceof LazySerializable && serializableWrapper._serializable instanceof LazySerializable) {
            LazySerializable lazySerializable1 = (LazySerializable)this._serializable;
            LazySerializable lazySerializable2 = (LazySerializable)serializableWrapper._serializable;
            return Arrays.equals(lazySerializable1.getData(), lazySerializable2.getData());
        }
        if (this._serializable instanceof LazySerializable) {
            lazySerializable = (LazySerializable)this._serializable;
            this._serializable = lazySerializable.getSerializable();
        }
        if (serializableWrapper._serializable instanceof LazySerializable) {
            lazySerializable = (LazySerializable)serializableWrapper._serializable;
            serializableWrapper._serializable = lazySerializable.getSerializable();
        }
        return this._serializable.equals(serializableWrapper._serializable);
    }

    public int hashCode() {
        if (this._serializable instanceof LazySerializable) {
            LazySerializable lazySerializable = (LazySerializable)this._serializable;
            this._serializable = lazySerializable.getSerializable();
        }
        return this._serializable.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        byte[] data = new byte[objectInput.readInt()];
        objectInput.readFully(data);
        this._serializable = new LazySerializable(data);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._serializable instanceof LazySerializable) {
            LazySerializable lazySerializable = (LazySerializable)this._serializable;
            byte[] data = lazySerializable.getData();
            objectOutput.writeInt(data.length);
            objectOutput.write(data, 0, data.length);
            return;
        }
        Serializer serializer = new Serializer();
        serializer.writeObject(this._serializable);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        objectOutput.writeInt(byteBuffer.remaining());
        objectOutput.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
    }

    private static class LazySerializable
    implements Serializable {
        private final byte[] _data;

        public byte[] getData() {
            return this._data;
        }

        public Serializable getSerializable() {
            Deserializer deserializer = new Deserializer(ByteBuffer.wrap(this._data));
            try {
                return deserializer.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                _log.error("Unable to deserialize object", cnfe);
                return null;
            }
        }

        private LazySerializable(byte[] data) {
            this._data = data;
        }
    }
}

