/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class DisplayTerms {
    public static final String ADVANCED_SEARCH = "advancedSearch";
    public static final String AND_OPERATOR = "andOperator";
    public static final String KEYWORDS = "keywords";
    protected boolean advancedSearch;
    protected boolean andOperator;
    protected String keywords;

    public DisplayTerms(HttpServletRequest request) {
        this.advancedSearch = ParamUtil.getBoolean(request, ADVANCED_SEARCH);
        this.andOperator = ParamUtil.getBoolean(request, AND_OPERATOR, true);
        this.keywords = ParamUtil.getString(request, KEYWORDS);
    }

    public DisplayTerms(PortletRequest portletRequest) {
        this.advancedSearch = ParamUtil.getBoolean(portletRequest, ADVANCED_SEARCH);
        this.andOperator = ParamUtil.getBoolean(portletRequest, AND_OPERATOR, true);
        this.keywords = ParamUtil.getString(portletRequest, KEYWORDS);
    }

    public String getKeywords() {
        return this.keywords;
    }

    public boolean isAdvancedSearch() {
        return this.advancedSearch;
    }

    public boolean isAndOperator() {
        return this.andOperator;
    }

    public boolean isSearch() {
        return this.advancedSearch || Validator.isNotNull(this.keywords);
    }

    public void setAdvancedSearch(boolean advancedSearch) {
        this.advancedSearch = advancedSearch;
    }
}

