/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.log4j;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Log4JUtil {
    private static final org.apache.log4j.Logger _logger = org.apache.log4j.Logger.getRootLogger();
    private static final Map<String, String> _customLogSettings = new ConcurrentHashMap<String, String>();
    private static String _liferayHome;

    public static void configureLog4J(ClassLoader classLoader) {
        Log4JUtil.configureLog4J(classLoader.getResource("META-INF/portal-log4j.xml"));
        try {
            Enumeration<URL> enu = classLoader.getResources("META-INF/portal-log4j-ext.xml");
            while (enu.hasMoreElements()) {
                Log4JUtil.configureLog4J(enu.nextElement());
            }
        }
        catch (IOException ioe) {
            Logger logger = Logger.getLogger(Log4JUtil.class.getName());
            logger.log(Level.WARNING, "Unable to load portal-log4j-ext.xml", ioe);
        }
    }

    public static void configureLog4J(URL url) {
        if (url == null) {
            return;
        }
        String urlContent = Log4JUtil._getURLContent(url);
        if (urlContent == null) {
            return;
        }
        DOMConfigurator domConfigurator = new DOMConfigurator();
        domConfigurator.doConfigure((Reader)new UnsyncStringReader(urlContent), LogManager.getLoggerRepository());
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (systemId.endsWith("log4j.dtd")) {
                        return new InputSource(DOMConfigurator.class.getResourceAsStream("log4j.dtd"));
                    }
                    return null;
                }
            });
            Document document = saxReader.read((Reader)new UnsyncStringReader(urlContent), url.toExternalForm());
            Element rootElement = document.getRootElement();
            List categoryElements = rootElement.elements("category");
            for (Element categoryElement : categoryElements) {
                String name = categoryElement.attributeValue("name");
                Element priorityElement = categoryElement.element("priority");
                String priority = priorityElement.attributeValue("value");
                Logger jdkLogger = Logger.getLogger(name);
                jdkLogger.setLevel(Log4JUtil._getJdkLevel(priority));
            }
        }
        catch (Exception e) {
            _logger.error((Object)e, (Throwable)e);
        }
    }

    public static Map<String, String> getCustomLogSettings() {
        return new HashMap<String, String>(Log4JUtil._getCustomLogSettings());
    }

    public static String getOriginalLevel(String className) {
        org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
        Enumeration enu = LogManager.getCurrentLoggers();
        while (enu.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enu.nextElement();
            if (!className.equals(logger.getName())) continue;
            level = logger.getLevel();
            break;
        }
        return level.toString();
    }

    public static void initLog4J(String serverId, String liferayHome, ClassLoader classLoader, LogFactory logFactory, Map<String, String> customLogSettings) {
        ServerDetector.init((String)serverId);
        _liferayHome = liferayHome;
        Log4JUtil.configureLog4J(classLoader);
        try {
            LogFactoryUtil.setLogFactory((LogFactory)logFactory);
        }
        catch (Exception e) {
            _logger.error((Object)e, (Throwable)e);
        }
        for (String name : customLogSettings.keySet()) {
            String priority = customLogSettings.get(name);
            Log4JUtil.setLevel(name, priority, false);
        }
    }

    public static void setLevel(String name, String priority, boolean custom) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name);
        logger.setLevel(org.apache.log4j.Level.toLevel((String)priority));
        Logger jdkLogger = Logger.getLogger(name);
        jdkLogger.setLevel(Log4JUtil._getJdkLevel(priority));
        if (custom) {
            Map<String, String> customLogSettings = Log4JUtil._getCustomLogSettings();
            customLogSettings.put(name, priority);
        }
    }

    private static byte[] _getBytes(InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)-1, (boolean)true);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private static Map<String, String> _getCustomLogSettings() {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (Log4JUtil.class.getClassLoader() == classLoader) {
            return _customLogSettings;
        }
        try {
            Class<?> clazz = classLoader.loadClass(Log4JUtil.class.getName());
            Field field = ReflectionUtil.getDeclaredField(clazz, (String)"_customLogSettings");
            return (Map)field.get(null);
        }
        catch (Exception e) {
            return (Map)ReflectionUtil.throwException((Throwable)e);
        }
    }

    private static Level _getJdkLevel(String priority) {
        if (StringUtil.equalsIgnoreCase((String)priority, (String)org.apache.log4j.Level.DEBUG.toString())) {
            return Level.FINE;
        }
        if (StringUtil.equalsIgnoreCase((String)priority, (String)org.apache.log4j.Level.ERROR.toString())) {
            return Level.SEVERE;
        }
        if (StringUtil.equalsIgnoreCase((String)priority, (String)org.apache.log4j.Level.WARN.toString())) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    private static String _getLiferayHome() {
        if (_liferayHome == null) {
            _liferayHome = PropsUtil.get((String)"liferay.home");
        }
        return _liferayHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getURLContent(URL url) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("@liferay.home@", Log4JUtil._getLiferayHome());
        String spiId = System.getProperty("spi.id");
        if (spiId == null) {
            spiId = "";
        }
        variables.put("@spi.id@", spiId);
        String urlContent = null;
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            byte[] bytes = Log4JUtil._getBytes(inputStream);
            urlContent = new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            String string;
            try {
                _logger.error((Object)e, (Throwable)e);
                string = null;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return string;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        for (Map.Entry variable : variables.entrySet()) {
            urlContent = StringUtil.replace((String)urlContent, (String)((String)variable.getKey()), (String)((String)variable.getValue()));
        }
        if (ServerDetector.getServerId() != null) {
            return urlContent;
        }
        urlContent = Log4JUtil._removeAppender(urlContent, "TEXT_FILE");
        return Log4JUtil._removeAppender(urlContent, "XML_FILE");
    }

    private static String _removeAppender(String content, String appenderName) {
        int x = content.indexOf("<appender name=\"" + appenderName + "\"");
        int y = content.indexOf("</appender>", x);
        if (y != -1) {
            y = content.indexOf("<", y + 1);
        }
        if (x != -1 && y != -1) {
            content = content.substring(0, x) + content.substring(y);
        }
        return StringUtil.replace((String)content, (String)("<appender-ref ref=\"" + appenderName + "\" />"), (String)"");
    }
}

