/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class SelfReferenceCheck
extends BaseCheck {
    private static final String _MSG_UNNEEDED_SELF_REFERENCE = "self.reference.unneeded";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        String className = nameAST.getText();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST secondChild;
            DetailAST firstChild;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST == null || (firstChild = dotAST.getFirstChild()).getType() != 58 && firstChild.getType() != 78) continue;
            String methodClassName = firstChild.getText();
            if (firstChild.getType() != 78 && (!methodClassName.equals(className) || this._isInsideAnonymousClass(methodCallAST) || this._isInsideInnerClass(methodCallAST, className)) || (secondChild = firstChild.getNextSibling()).getType() != 58) continue;
            this.log(methodCallAST.getLineNo(), _MSG_UNNEEDED_SELF_REFERENCE, new Object[]{secondChild.getText(), firstChild.getText() + "."});
        }
    }

    private boolean _isInsideAnonymousClass(DetailAST methodCallAST) {
        DetailAST parentAST = methodCallAST.getParent();
        while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() == 9) break;
            parentAST = parentAST.getParent();
        }
        if ((parentAST = parentAST.getParent()).getType() != 6) {
            return false;
        }
        return (parentAST = parentAST.getParent()).getType() != 14;
    }

    private boolean _isInsideInnerClass(DetailAST methodCallAST, String className) {
        DetailAST parentAST = methodCallAST.getParent();
        while (true) {
            if (parentAST.getType() == 14) {
                DetailAST nameAST = parentAST.findFirstToken(58);
                return !className.equals(nameAST.getText());
            }
            parentAST = parentAST.getParent();
        }
    }
}

