/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class AssertEqualsCheck
extends BaseCheck {
    private static final String _MSG_ASSERT_ADD_INFORMATION = "assert.add.information";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "Assert", "assertEquals");
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST typeAST;
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
            if (exprASTList.size() != 2) continue;
            DetailAST secondExprAST = exprASTList.get(1);
            DetailAST firstChildAST = secondExprAST.getFirstChild();
            String variableName = this._getVariableNameForMethodCall(firstChildAST, "getLength");
            if (variableName != null) {
                typeAST = DetailASTUtil.findTypeAST(detailAST, variableName);
                if (typeAST == null || !this._isHits(typeAST)) continue;
                this.log(methodCallAST.getLineNo(), _MSG_ASSERT_ADD_INFORMATION, new Object[]{variableName + ".toString()"});
                continue;
            }
            variableName = this._getVariableNameForCall(firstChildAST, "length");
            if (variableName != null) {
                typeAST = DetailASTUtil.findTypeAST(detailAST, variableName);
                if (typeAST == null || !DetailASTUtil.isArray(typeAST)) continue;
                this.log(methodCallAST.getLineNo(), _MSG_ASSERT_ADD_INFORMATION, new Object[]{"Arrays.toString(" + variableName + ")"});
                continue;
            }
            variableName = this._getVariableNameForMethodCall(firstChildAST, "size");
            if (variableName == null || (typeAST = DetailASTUtil.findTypeAST(detailAST, variableName)) == null || !DetailASTUtil.isCollection(typeAST)) continue;
            this.log(methodCallAST.getLineNo(), _MSG_ASSERT_ADD_INFORMATION, new Object[]{variableName + ".toString()"});
        }
    }

    private String _getVariableNameForCall(DetailAST detailAST, String methodName) {
        if (detailAST.getType() != 59) {
            return null;
        }
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(detailAST, false, 58);
        if (nameASTList.size() != 2) {
            return null;
        }
        DetailAST methodNameAST = nameASTList.get(1);
        if (!methodName.equals(methodNameAST.getText())) {
            return null;
        }
        DetailAST variableNameAST = nameASTList.get(0);
        return variableNameAST.getText();
    }

    private String _getVariableNameForMethodCall(DetailAST detailAST, String methodName) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST firstChild = detailAST.getFirstChild();
        return this._getVariableNameForCall(firstChild, methodName);
    }

    private boolean _isHits(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        return name.equals("Hits");
    }
}

