/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import aQute.bnd.annotation.ProviderType;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncFilterInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

@DoPrivileged
@ProviderType
public class HttpImpl
implements Http {
    private static final String _DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv 11.0) like Gecko";
    private static final int _MAX_BYTE_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final int _MAX_CONNECTIONS_PER_HOST = GetterUtil.getInteger((String)PropsUtil.get(HttpImpl.class.getName() + ".max.connections.per.host"), (int)2);
    private static final int _MAX_TOTAL_CONNECTIONS = GetterUtil.getInteger((String)PropsUtil.get(HttpImpl.class.getName() + ".max.total.connections"), (int)20);
    private static final String _NON_PROXY_HOSTS = SystemProperties.get((String)"http.nonProxyHosts");
    private static final String _PROXY_AUTH_TYPE = GetterUtil.getString((String)PropsUtil.get(HttpImpl.class.getName() + ".proxy.auth.type"));
    private static final String _PROXY_HOST = GetterUtil.getString((String)SystemProperties.get((String)"http.proxyHost"));
    private static final String _PROXY_NTLM_DOMAIN = GetterUtil.getString((String)PropsUtil.get(HttpImpl.class.getName() + ".proxy.ntlm.domain"));
    private static final String _PROXY_NTLM_HOST = GetterUtil.getString((String)PropsUtil.get(HttpImpl.class.getName() + ".proxy.ntlm.host"));
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get(HttpImpl.class.getName() + ".proxy.password"));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)SystemProperties.get((String)"http.proxyPort"));
    private static final String _PROXY_USERNAME = GetterUtil.getString((String)PropsUtil.get(HttpImpl.class.getName() + ".proxy.username"));
    private static final String _TEMP_SLASH = "_LIFERAY_TEMP_SLASH_";
    private static final int _TIMEOUT = GetterUtil.getInteger((String)PropsUtil.get(HttpImpl.class.getName() + ".timeout"), (int)5000);
    private static final Log _log = LogFactoryUtil.getLog(HttpImpl.class);
    private static final ThreadLocal<javax.servlet.http.Cookie[]> _cookies = new ThreadLocal();
    private final CloseableHttpClient _closeableHttpClient;
    private final Pattern _nonProxyHostsPattern;
    private final PoolingHttpClientConnectionManager _poolingHttpClientConnectionManager;
    private final List<String> _proxyAuthPrefs = new ArrayList<String>();
    private final CloseableHttpClient _proxyCloseableHttpClient;
    private final Credentials _proxyCredentials;

    public HttpImpl() {
        if (Validator.isNotNull((String)_NON_PROXY_HOSTS)) {
            String nonProxyHostsRegEx = _NON_PROXY_HOSTS;
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\.", "\\\\.");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\*", ".*?");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\|", ")|(");
            nonProxyHostsRegEx = "(" + nonProxyHostsRegEx + ")";
            this._nonProxyHostsPattern = Pattern.compile(nonProxyHostsRegEx);
        } else {
            this._nonProxyHostsPattern = null;
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this._poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
        this._poolingHttpClientConnectionManager.setDefaultMaxPerRoute(_MAX_CONNECTIONS_PER_HOST);
        this._poolingHttpClientConnectionManager.setMaxTotal(_MAX_TOTAL_CONNECTIONS);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this._poolingHttpClientConnectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder = requestConfigBuilder.setConnectTimeout(_TIMEOUT);
        requestConfigBuilder = requestConfigBuilder.setConnectionRequestTimeout(_TIMEOUT);
        RequestConfig requestConfig = requestConfigBuilder.build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        SystemDefaultRoutePlanner systemDefaultRoutePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)systemDefaultRoutePlanner);
        this._closeableHttpClient = httpClientBuilder.build();
        if (!this.hasProxyConfig() || Validator.isNull((String)_PROXY_USERNAME)) {
            this._proxyCredentials = null;
            this._proxyCloseableHttpClient = this._closeableHttpClient;
            return;
        }
        this._proxyAuthPrefs.add("Basic");
        this._proxyAuthPrefs.add("Digest");
        if (_PROXY_AUTH_TYPE.equals("username-password")) {
            this._proxyCredentials = new UsernamePasswordCredentials(_PROXY_USERNAME, _PROXY_PASSWORD);
            this._proxyAuthPrefs.add("NTLM");
        } else if (_PROXY_AUTH_TYPE.equals("ntlm")) {
            this._proxyCredentials = new NTCredentials(_PROXY_USERNAME, _PROXY_PASSWORD, _PROXY_NTLM_HOST, _PROXY_NTLM_DOMAIN);
            this._proxyAuthPrefs.add(0, "NTLM");
        } else {
            this._proxyCredentials = null;
        }
        HttpClientBuilder proxyHttpClientBuilder = HttpClientBuilder.create();
        proxyHttpClientBuilder.setRoutePlanner((HttpRoutePlanner)systemDefaultRoutePlanner);
        proxyHttpClientBuilder.setConnectionManager((HttpClientConnectionManager)this._poolingHttpClientConnectionManager);
        requestConfigBuilder.setProxy(new HttpHost(_PROXY_HOST, _PROXY_PORT));
        requestConfigBuilder.setProxyPreferredAuthSchemes(this._proxyAuthPrefs);
        RequestConfig proxyRequestConfig = requestConfigBuilder.build();
        proxyHttpClientBuilder.setDefaultRequestConfig(proxyRequestConfig);
        this._proxyCloseableHttpClient = proxyHttpClientBuilder.build();
    }

    public String addParameter(String url, String name, boolean value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, double value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, int value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, long value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, short value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        String[] urlArray = PortalUtil.stripURLAnchor((String)url, (String)"#");
        url = urlArray[0];
        String anchor = urlArray[1];
        StringBundler sb = new StringBundler(6);
        sb.append(url);
        if (url.indexOf(63) == -1) {
            sb.append("?");
        } else if (!url.endsWith("?") && !url.endsWith("&")) {
            sb.append("&");
        }
        sb.append(name);
        sb.append("=");
        sb.append(URLCodec.encodeURL((String)value));
        sb.append(anchor);
        return this.shortenURL(sb.toString());
    }

    public String decodePath(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        path = StringUtil.replace((String)path, (char)'/', (String)_TEMP_SLASH);
        path = this.decodeURL(path, true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    public String decodeURL(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        try {
            return URLCodec.decodeURL((String)url, (String)"UTF-8");
        }
        catch (IllegalArgumentException iae) {
            _log.error((Object)iae.getMessage());
            return "";
        }
    }

    @Deprecated
    public String decodeURL(String url, boolean unescapeSpaces) {
        return this.decodeURL(url);
    }

    public void destroy() {
        PoolStats poolStats;
        int availableConnections;
        for (int retry = 0; retry < 10 && (availableConnections = (poolStats = this._poolingHttpClientConnectionManager.getTotalStats()).getAvailable()) > 0; ++retry) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{this.toString(), " is waiting on ", String.valueOf(availableConnections), " connections"}));
            }
            this._poolingHttpClientConnectionManager.closeIdleConnections(200L, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._poolingHttpClientConnectionManager.shutdown();
    }

    public String encodeParameters(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        String queryString = this.getQueryString(url);
        if (Validator.isNull((String)queryString)) {
            return url;
        }
        String encodedQueryString = this.parameterMapToString(this.parameterMapFromString(queryString), false);
        return StringUtil.replace((String)url, (String)queryString, (String)encodedQueryString);
    }

    public String encodePath(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        path = StringUtil.replace((String)path, (char)'/', (String)_TEMP_SLASH);
        path = URLCodec.encodeURL((String)path, (boolean)true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    @Deprecated
    public String encodeURL(String url) {
        return this.encodeURL(url, false);
    }

    @Deprecated
    public String encodeURL(String url, boolean escapeSpaces) {
        return URLCodec.encodeURL((String)url, (String)"UTF-8", (boolean)escapeSpaces);
    }

    public String fixPath(String path) {
        return this.fixPath(path, true, true);
    }

    public String fixPath(String path, boolean leading, boolean trailing) {
        int slashCount;
        int i;
        if (path == null) {
            return "";
        }
        int leadingSlashCount = 0;
        int trailingSlashCount = 0;
        if (leading) {
            for (i = 0; i < path.length() && path.charAt(i) == '/'; ++i) {
                ++leadingSlashCount;
            }
        }
        if (trailing) {
            for (i = path.length() - 1; i >= 0 && path.charAt(i) == '/'; --i) {
                ++trailingSlashCount;
            }
        }
        if ((slashCount = leadingSlashCount + trailingSlashCount) > path.length()) {
            return "";
        }
        if (slashCount > 0) {
            path = path.substring(leadingSlashCount, path.length() - trailingSlashCount);
        }
        return path;
    }

    @Deprecated
    public HttpClient getClient(HostConfiguration hostConfiguration) {
        throw new UnsupportedOperationException();
    }

    public String getCompleteURL(HttpServletRequest request) {
        String proxyPath;
        StringBuffer sb = request.getRequestURL();
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (request.getQueryString() != null) {
            sb.append("?");
            sb.append(request.getQueryString());
        }
        if (Validator.isNotNull((String)(proxyPath = PortalUtil.getPathProxy()))) {
            int x = sb.indexOf("://") + "://".length();
            int y = sb.indexOf("/", x);
            sb.insert(y, proxyPath);
        }
        String completeURL = sb.toString();
        if (request.isRequestedSessionIdFromURL()) {
            HttpSession session = request.getSession();
            String sessionId = session.getId();
            completeURL = PortalUtil.getURLWithSessionId((String)completeURL, (String)sessionId);
        }
        if (_log.isWarnEnabled() && completeURL.contains("?&")) {
            _log.warn((Object)("Invalid url " + completeURL));
        }
        return completeURL;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return _cookies.get();
    }

    public String getDomain(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return url;
    }

    @Deprecated
    public HostConfiguration getHostConfiguration(String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getIpAddress(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            InetAddress address = InetAddress.getByName(urlObj.getHost());
            return address.getHostAddress();
        }
        catch (Exception e) {
            return url;
        }
    }

    public String getParameter(String url, String name) {
        return this.getParameter(url, name, true);
    }

    public String getParameter(String url, String name, boolean escaped) {
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return "";
        }
        String[] parts = StringUtil.split((String)url, (char)'?');
        if (parts.length == 2) {
            String[] params = null;
            params = escaped ? StringUtil.split((String)parts[1], (String)"&amp;") : StringUtil.split((String)parts[1], (char)'&');
            for (String param : params) {
                String[] kvp = StringUtil.split((String)param, (char)'=');
                if (kvp.length != 2 || !kvp[0].equals(name)) continue;
                return kvp[1];
            }
        }
        return "";
    }

    public Map<String, String[]> getParameterMap(String queryString) {
        return this.parameterMapFromString(queryString);
    }

    public String getPath(String url) {
        int pos;
        if (Validator.isNull((String)url)) {
            return url;
        }
        if (url.startsWith("http")) {
            pos = url.indexOf(47, "https://".length());
            url = url.substring(pos);
        }
        if ((pos = url.indexOf(63)) == -1) {
            return url;
        }
        return url.substring(0, pos);
    }

    public String getProtocol(ActionRequest actionRequest) {
        return this.getProtocol(actionRequest.isSecure());
    }

    public String getProtocol(boolean secure) {
        if (!secure) {
            return "http";
        }
        return "https";
    }

    public String getProtocol(HttpServletRequest request) {
        return this.getProtocol(request.isSecure());
    }

    public String getProtocol(RenderRequest renderRequest) {
        return this.getProtocol(renderRequest.isSecure());
    }

    public String getProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = url.indexOf("://");
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return "http";
    }

    public String getQueryString(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return "";
        }
        return url.substring(pos + 1);
    }

    public String getRequestURL(HttpServletRequest request) {
        return String.valueOf(request.getRequestURL());
    }

    public boolean hasDomain(String url) {
        if (Validator.isNull((String)url)) {
            return false;
        }
        return Validator.isNotNull((String)this.getDomain(url));
    }

    public boolean hasProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return false;
        }
        int pos = url.indexOf("://");
        return pos != -1;
    }

    public boolean hasProxyConfig() {
        return Validator.isNotNull((String)_PROXY_HOST) && _PROXY_PORT > 0;
    }

    public boolean isNonProxyHost(String host) {
        Matcher matcher;
        if (Validator.isNull((String)host)) {
            return false;
        }
        return this._nonProxyHostsPattern != null && (matcher = this._nonProxyHostsPattern.matcher(host)).matches();
    }

    public boolean isProxyHost(String host) {
        if (Validator.isNull((String)host)) {
            return false;
        }
        return this.hasProxyConfig() && !this.isNonProxyHost(host);
    }

    public boolean isSecure(String url) {
        String protocol = this.getProtocol(url);
        return StringUtil.equalsIgnoreCase((String)protocol, (String)"https");
    }

    public String normalizePath(String uri) {
        char c;
        if (Validator.isNull((String)uri)) {
            return uri;
        }
        uri = this.removePathParameters(uri);
        for (int i = 0; i < uri.length() && (c = uri.charAt(i)) != '%' && c != '.' && (c != '/' || i + 1 >= uri.length() || uri.charAt(i + 1) != '/'); ++i) {
            if (i != uri.length() - 1) continue;
            if (c == '?') {
                return uri.substring(0, uri.length() - 1);
            }
            return uri;
        }
        String path = null;
        String queryString = null;
        int pos = uri.indexOf(63);
        if (pos != -1) {
            path = uri.substring(0, pos);
            queryString = uri.substring(pos + 1);
        } else {
            path = uri;
        }
        String[] uriParts = StringUtil.split((String)path.substring(1), (char)'/');
        ArrayList<String> parts = new ArrayList<String>(uriParts.length);
        String prevUriPart = null;
        for (String uriPart : uriParts) {
            String curUriPart = URLCodec.decodeURL((String)uriPart);
            if (curUriPart.equals("..")) {
                if (prevUriPart != null && !prevUriPart.equals(".")) {
                    parts.remove(parts.size() - 1);
                }
            } else if (curUriPart.length() > 0 && !curUriPart.equals(".")) {
                parts.add(URLCodec.encodeURL((String)curUriPart));
            }
            prevUriPart = curUriPart;
        }
        if (parts.isEmpty()) {
            return "/";
        }
        StringBundler sb = new StringBundler(parts.size() * 2 + 2);
        for (String part : parts) {
            sb.append("/");
            sb.append(part);
        }
        if (Validator.isNotNull((String)queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public Map<String, String[]> parameterMapFromString(String queryString) {
        String[] parameters;
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (Validator.isNull((String)queryString)) {
            return parameterMap;
        }
        for (String parameter : parameters = StringUtil.split((String)queryString, (char)'&')) {
            Object[] values;
            String[] kvp;
            if (parameter.length() <= 0 || (kvp = StringUtil.split((String)parameter, (char)'=')).length == 0) continue;
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                try {
                    value = this.decodeURL(kvp[1]);
                }
                catch (IllegalArgumentException iae) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Skipping parameter with key ", key, " because of invalid value ", kvp[1]}), (Throwable)iae);
                    continue;
                }
            }
            if ((values = (String[])parameterMap.get(key)) == null) {
                parameterMap.put(key, new String[]{value});
                continue;
            }
            parameterMap.put(key, (String[])ArrayUtil.append((Object[])values, (Object)value));
        }
        return parameterMap;
    }

    public String parameterMapToString(Map<String, String[]> parameterMap) {
        return this.parameterMapToString(parameterMap, true);
    }

    public String parameterMapToString(Map<String, String[]> parameterMap, boolean addQuestion) {
        if (parameterMap.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        if (addQuestion) {
            sb.append("?");
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            String name = entry.getKey();
            for (String value : values = entry.getValue()) {
                sb.append(name);
                sb.append("=");
                sb.append(URLCodec.encodeURL((String)value));
                sb.append("&");
            }
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String protocolize(String url, ActionRequest actionRequest) {
        return this.protocolize(url, actionRequest.isSecure());
    }

    public String protocolize(String url, boolean secure) {
        return this.protocolize(url, -1, secure);
    }

    public String protocolize(String url, HttpServletRequest request) {
        return this.protocolize(url, request.isSecure());
    }

    public String protocolize(String url, int port, boolean secure) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            String protocol = "http";
            if (secure) {
                protocol = "https";
            }
            if (port == -1) {
                port = urlObj.getPort();
            }
            urlObj = new URL(protocol, urlObj.getHost(), port, urlObj.getFile());
            return urlObj.toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    public String protocolize(String url, RenderRequest renderRequest) {
        return this.protocolize(url, renderRequest.isSecure());
    }

    @Deprecated
    public void proxifyState(HttpState httpState, HostConfiguration hostConfiguration) {
    }

    public String removeDomain(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos > 0) {
            return url.substring(pos);
        }
        return url;
    }

    public String removeParameter(String url, String name) {
        String[] parameters;
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return url;
        }
        String[] array = PortalUtil.stripURLAnchor((String)url, (String)"#");
        url = array[0];
        String anchor = array[1];
        StringBundler sb = new StringBundler();
        sb.append(url.substring(0, pos + 1));
        for (String parameter : parameters = StringUtil.split((String)url.substring(pos + 1, url.length()), (char)'&')) {
            if (parameter.length() <= 0) continue;
            String[] kvp = StringUtil.split((String)parameter, (char)'=');
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if (key.equals(name)) continue;
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("&");
        }
        url = StringUtil.replace((String)sb.toString(), (String)"&&", (String)"&");
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return url + anchor;
    }

    public String removePathParameters(String uri) {
        if (Validator.isNull((String)uri)) {
            return uri;
        }
        int pos = uri.indexOf(59);
        if (pos == -1) {
            return uri;
        }
        if (pos == 0) {
            throw new IllegalArgumentException("Unable to handle URI: " + uri);
        }
        String[] uriParts = StringUtil.split((String)uri.substring(1), (char)'/');
        StringBundler sb = new StringBundler(uriParts.length * 2);
        for (String uriPart : uriParts) {
            pos = uriPart.indexOf(59);
            if (pos == -1) {
                sb.append("/");
                sb.append(uriPart);
                continue;
            }
            if (pos == 0) continue;
            sb.append("/");
            sb.append(uriPart.substring(0, pos));
        }
        if (sb.length() == 0) {
            return "/";
        }
        return sb.toString();
    }

    public String removeProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        if ((url = url.trim()).length() >= 2 && url.charAt(0) == '/' && this._isLetterOrNumber(url.charAt(1))) {
            return url;
        }
        int pos = 0;
        block0: while (true) {
            int index;
            if ((index = url.indexOf("://", pos)) > 0) {
                boolean hasProtocol = true;
                for (int i = pos; i < index; ++i) {
                    if (this._isLetterOrNumber(url.charAt(i))) continue;
                    hasProtocol = false;
                    break;
                }
                if (hasProtocol) {
                    pos = index + "://".length();
                    continue;
                }
            }
            for (int i = pos; i < url.length(); ++i) {
                char c = url.charAt(i);
                if (c == '/' || c == '\\') continue;
                if (i == pos) break block0;
                pos = i;
                continue block0;
            }
            break;
        }
        return url.substring(pos);
    }

    public String sanitizeHeader(String header) {
        if (header == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if ((c > '\u001f' || c == '\t') && c != '\u007f' && c <= '\u00ff') continue;
            if (sb == null) {
                sb = new StringBuilder(header);
            }
            sb.setCharAt(i, ' ');
        }
        if (sb != null) {
            header = sb.toString();
        }
        return header;
    }

    public String setParameter(String url, String name, boolean value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, double value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, int value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, long value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, short value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, String value) {
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return url;
        }
        url = this.removeParameter(url, name);
        return this.addParameter(url, name, value);
    }

    public String shortenURL(String url) {
        if (url.length() <= 2083) {
            return url;
        }
        return this._shortenURL(url, 0);
    }

    @Deprecated
    public String shortenURL(String url, int count) {
        return this.shortenURL(url);
    }

    public byte[] URLtoByteArray(Http.Options options) throws IOException {
        return this.URLtoByteArray(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookies(), options.getAuth(), options.getBody(), options.getFileParts(), options.getParts(), options.getResponse(), options.isFollowRedirects(), options.getTimeout());
    }

    public byte[] URLtoByteArray(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoByteArray(options);
    }

    public byte[] URLtoByteArray(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoByteArray(options);
    }

    public InputStream URLtoInputStream(Http.Options options) throws IOException {
        return this.URLtoInputStream(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookies(), options.getAuth(), options.getBody(), options.getFileParts(), options.getParts(), options.getResponse(), options.isFollowRedirects(), options.getTimeout());
    }

    public InputStream URLtoInputStream(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoInputStream(options);
    }

    public InputStream URLtoInputStream(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoInputStream(options);
    }

    public String URLtoString(Http.Options options) throws IOException {
        return new String(this.URLtoByteArray(options));
    }

    public String URLtoString(String location) throws IOException {
        return new String(this.URLtoByteArray(location));
    }

    public String URLtoString(String location, boolean post) throws IOException {
        return new String(this.URLtoByteArray(location, post));
    }

    public String URLtoString(URL url) throws IOException {
        String xml = null;
        if (url == null) {
            return null;
        }
        String protocol = StringUtil.toLowerCase((String)url.getProtocol());
        if (protocol.startsWith("http") || protocol.startsWith("https")) {
            return this.URLtoString(url.toString());
        }
        URLConnection urlConnection = url.openConnection();
        if (urlConnection == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to open a connection to " + url));
            }
            return null;
        }
        try (InputStream inputStream = urlConnection.getInputStream();
             UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            byte[] bytes = new byte[512];
            int i = inputStream.read(bytes, 0, 512);
            while (i != -1) {
                unsyncByteArrayOutputStream.write(bytes, 0, i);
                i = inputStream.read(bytes, 0, 512);
            }
            xml = new String(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
        }
        return xml;
    }

    protected void addProxyCredentials(URI uri, HttpClientContext httpClientContext) {
        String host = uri.getHost();
        if (!this.isProxyHost(host) || this._proxyCredentials == null) {
            return;
        }
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider == null) {
            credentialsProvider = new BasicCredentialsProvider();
            httpClientContext.setCredentialsProvider(credentialsProvider);
        }
        credentialsProvider.setCredentials(new AuthScope(_PROXY_HOST, _PROXY_PORT), this._proxyCredentials);
    }

    protected CloseableHttpClient getCloseableHttpClient(HttpHost proxyHost) {
        if (proxyHost != null) {
            return this._proxyCloseableHttpClient;
        }
        return this._closeableHttpClient;
    }

    protected RequestConfig.Builder getRequestConfigBuilder(URI uri, int timeout) {
        int maxConnectionsPerHost;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Location is " + uri.toString()));
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.isProxyHost(uri.getHost())) {
            HttpHost proxy = new HttpHost(_PROXY_HOST, _PROXY_PORT);
            requestConfigBuilder.setProxy(proxy);
            if (this._proxyCredentials != null) {
                requestConfigBuilder.setProxyPreferredAuthSchemes(this._proxyAuthPrefs);
            }
        }
        if ((maxConnectionsPerHost = GetterUtil.getInteger((String)PropsUtil.get(HttpImpl.class.getName() + ".max.connections.per.host", new Filter(uri.getHost())))) > 0 && maxConnectionsPerHost != _MAX_CONNECTIONS_PER_HOST) {
            HttpRoute httpRoute = new HttpRoute(new HttpHost(uri.getHost(), uri.getPort()));
            this._poolingHttpClientConnectionManager.setMaxPerRoute(httpRoute, maxConnectionsPerHost);
        }
        if (timeout == 0) {
            timeout = GetterUtil.getInteger((String)PropsUtil.get(HttpImpl.class.getName() + ".timeout", new Filter(uri.getHost())));
        }
        if (timeout > 0) {
            requestConfigBuilder = requestConfigBuilder.setConnectTimeout(timeout);
            requestConfigBuilder = requestConfigBuilder.setConnectionRequestTimeout(timeout);
        }
        return requestConfigBuilder;
    }

    @Deprecated
    protected boolean hasRequestHeader(HttpMethod httpMethod, String name) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasRequestHeader(RequestBuilder requestBuilder, String name) {
        Object[] headers = requestBuilder.getHeaders(name);
        return !ArrayUtil.isEmpty((Object[])headers);
    }

    @Deprecated
    protected void processPostMethod(PostMethod postMethod, List<Http.FilePart> fileParts, Map<String, String> parts) {
        throw new UnsupportedOperationException();
    }

    protected void processPostMethod(RequestBuilder requestBuilder, List<Http.FilePart> fileParts, Map<String, String> parts) {
        if (fileParts == null || fileParts.isEmpty()) {
            if (parts != null) {
                for (Map.Entry<String, String> entry : parts.entrySet()) {
                    String string = entry.getValue();
                    if (string == null) continue;
                    requestBuilder.addParameter(entry.getKey(), string);
                }
            }
        } else {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (parts != null) {
                for (Map.Entry entry : parts.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    multipartEntityBuilder.addPart((String)entry.getKey(), (ContentBody)new StringBody(value, ContentType.create((String)"text/plain", (String)"UTF-8")));
                }
            }
            for (Http.FilePart filePart : fileParts) {
                ByteArrayBody byteArrayBody = new ByteArrayBody(filePart.getValue(), ContentType.DEFAULT_BINARY, filePart.getFileName());
                multipartEntityBuilder.addPart(filePart.getName(), (ContentBody)byteArrayBody);
            }
            requestBuilder.setEntity(multipartEntityBuilder.build());
        }
    }

    @Deprecated
    protected Cookie toCommonsCookie(javax.servlet.http.Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected Cookie[] toCommonsCookies(javax.servlet.http.Cookie[] cookie) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected FilePart toCommonsFilePart(Http.FilePart filePart) {
        throw new UnsupportedOperationException();
    }

    protected org.apache.http.cookie.Cookie toHttpCookie(javax.servlet.http.Cookie cookie) {
        BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        basicClientCookie.setDomain(cookie.getDomain());
        int maxAge = cookie.getMaxAge();
        if (maxAge > 0) {
            Date expiryDate = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
            basicClientCookie.setExpiryDate(expiryDate);
            basicClientCookie.setAttribute("max-age", Integer.toString(maxAge));
        }
        basicClientCookie.setPath(cookie.getPath());
        basicClientCookie.setSecure(cookie.getSecure());
        basicClientCookie.setVersion(cookie.getVersion());
        return basicClientCookie;
    }

    protected org.apache.http.cookie.Cookie[] toHttpCookies(javax.servlet.http.Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        org.apache.http.cookie.Cookie[] httpCookies = new org.apache.http.cookie.Cookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            httpCookies[i] = this.toHttpCookie(cookies[i]);
        }
        return httpCookies;
    }

    @Deprecated
    protected javax.servlet.http.Cookie toServletCookie(Cookie commonsCookie) {
        throw new UnsupportedOperationException();
    }

    protected javax.servlet.http.Cookie toServletCookie(org.apache.http.cookie.Cookie httpCookie) {
        String path;
        Date expiryDate;
        String domain;
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(httpCookie.getName(), httpCookie.getValue());
        if (!PropsValues.SESSION_COOKIE_USE_FULL_HOSTNAME && Validator.isNotNull((String)(domain = httpCookie.getDomain()))) {
            cookie.setDomain(domain);
        }
        if ((expiryDate = httpCookie.getExpiryDate()) != null) {
            int maxAge = (int)(expiryDate.getTime() - System.currentTimeMillis());
            if ((maxAge /= 1000) > -1) {
                cookie.setMaxAge(maxAge);
            }
        }
        if (Validator.isNotNull((String)(path = httpCookie.getPath()))) {
            cookie.setPath(path);
        }
        cookie.setSecure(httpCookie.isSecure());
        cookie.setVersion(httpCookie.getVersion());
        return cookie;
    }

    protected javax.servlet.http.Cookie[] toServletCookies(List<org.apache.http.cookie.Cookie> httpCookies) {
        if (httpCookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[httpCookies.size()];
        for (int i = 0; i < httpCookies.size(); ++i) {
            cookies[i] = this.toServletCookie(httpCookies.get(i));
        }
        return cookies;
    }

    @Deprecated
    protected javax.servlet.http.Cookie[] toServletCookies(Cookie[] commonsCookies) {
        throw new UnsupportedOperationException();
    }

    protected byte[] URLtoByteArray(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, Map<String, String> parts, Http.Response response, boolean followRedirects) throws IOException {
        return this.URLtoByteArray(location, method, headers, cookies, auth, body, fileParts, parts, response, followRedirects, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] URLtoByteArray(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, Map<String, String> parts, Http.Response response, boolean followRedirects, int timeout) throws IOException {
        InputStream inputStream = this.URLtoInputStream(location, method, headers, cookies, auth, body, fileParts, parts, response, followRedirects, timeout);
        if (inputStream == null) {
            return null;
        }
        try {
            long contentLengthLong = response.getContentLengthLong();
            if (contentLengthLong > 0x7FFFFFF7L) {
                StringBundler sb = new StringBundler(5);
                sb.append("Retrieving ");
                sb.append(location);
                sb.append(" yields a file of size ");
                sb.append(contentLengthLong);
                sb.append(" bytes that is too large to convert to a byte array");
                throw new OutOfMemoryError(sb.toString());
            }
            byte[] byArray = FileUtil.getBytes((InputStream)inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected InputStream URLtoInputStream(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, Map<String, String> parts, Http.Response response, boolean followRedirects) throws IOException {
        return this.URLtoInputStream(location, method, headers, cookies, auth, body, fileParts, parts, response, followRedirects, 0);
    }

    protected InputStream URLtoInputStream(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, Map<String, String> parts, Http.Response response, boolean followRedirects, int timeout) throws IOException {
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException urise) {
            throw new IOException("Invalid URI: " + location, urise);
        }
        BasicCookieStore basicCookieStore = null;
        CloseableHttpResponse closeableHttpResponse = null;
        HttpEntity httpEntity = null;
        try {
            Header contentTypeHeader;
            String string;
            _cookies.set(null);
            if (location == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (!location.startsWith("http://") && !location.startsWith("https://")) {
                location = "http://" + location;
                uri = new URI(location);
            }
            HttpHost targetHttpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            RequestConfig.Builder requestConfigBuilder = this.getRequestConfigBuilder(uri, timeout);
            RequestConfig requestConfig = requestConfigBuilder.build();
            CloseableHttpClient httpClient = this.getCloseableHttpClient(requestConfig.getProxy());
            HttpClientContext httpClientContext = HttpClientContext.create();
            RequestBuilder requestBuilder = null;
            if (method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) {
                requestBuilder = method.equals((Object)Http.Method.POST) ? RequestBuilder.post((String)location) : RequestBuilder.put((String)location);
                if (body != null) {
                    StringEntity stringEntity = new StringEntity(body.getContent(), body.getCharset());
                    stringEntity.setContentType(body.getContentType());
                    requestBuilder.setEntity((HttpEntity)stringEntity);
                } else if (method.equals((Object)Http.Method.POST)) {
                    if (!this.hasRequestHeader(requestBuilder, "Content-Type")) {
                        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
                        connectionConfigBuilder.setCharset(Charset.forName("UTF-8"));
                        this._poolingHttpClientConnectionManager.setConnectionConfig(targetHttpHost, connectionConfigBuilder.build());
                    }
                    this.processPostMethod(requestBuilder, fileParts, parts);
                }
            } else {
                requestBuilder = method.equals((Object)Http.Method.DELETE) ? RequestBuilder.delete((String)location) : (method.equals((Object)Http.Method.HEAD) ? RequestBuilder.head((String)location) : RequestBuilder.get((String)location));
            }
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) && (body != null || fileParts != null && !fileParts.isEmpty() || parts != null && !parts.isEmpty()) && !this.hasRequestHeader(requestBuilder, "Content-Type")) {
                requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            }
            if (!this.hasRequestHeader(requestBuilder, "User-Agent")) {
                requestBuilder.addHeader("User-Agent", _DEFAULT_USER_AGENT);
            }
            if (ArrayUtil.isNotEmpty((Object[])cookies)) {
                basicCookieStore = new BasicCookieStore();
                org.apache.http.cookie.Cookie[] httpCookies = this.toHttpCookies(cookies);
                basicCookieStore.addCookies(httpCookies);
                httpClientContext.setCookieStore((CookieStore)basicCookieStore);
                requestConfigBuilder.setCookieSpec("default");
            }
            if (auth != null) {
                requestConfigBuilder.setAuthenticationEnabled(true);
                BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
                httpClientContext.setCredentialsProvider((CredentialsProvider)credentialProvider);
                credentialProvider.setCredentials(new AuthScope(auth.getHost(), auth.getPort(), auth.getRealm()), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
            }
            this.addProxyCredentials(uri, httpClientContext);
            requestBuilder.setConfig(requestConfigBuilder.build());
            closeableHttpResponse = httpClient.execute(targetHttpHost, (HttpRequest)requestBuilder.build(), (HttpContext)httpClientContext);
            httpEntity = closeableHttpResponse.getEntity();
            response.setResponseCode(closeableHttpResponse.getStatusLine().getStatusCode());
            Header locationHeader = closeableHttpResponse.getFirstHeader("location");
            if (locationHeader != null && !(string = locationHeader.getValue()).equals(location)) {
                if (followRedirects) {
                    EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                    closeableHttpResponse.close();
                    InputStream inputStream = this.URLtoInputStream(string, Http.Method.GET, headers, cookies, auth, body, fileParts, parts, response, followRedirects, timeout);
                    return inputStream;
                }
                response.setRedirect(string);
            }
            long l = 0L;
            Header contentLengthHeader = closeableHttpResponse.getFirstHeader("Content-Length");
            if (contentLengthHeader != null) {
                l = GetterUtil.getLong((String)contentLengthHeader.getValue());
                response.setContentLengthLong(l);
                if (l > 0x7FFFFFF7L) {
                    response.setContentLength(-1);
                } else {
                    int contentLength = (int)l;
                    response.setContentLength(contentLength);
                }
            }
            if ((contentTypeHeader = closeableHttpResponse.getFirstHeader("Content-Type")) != null) {
                response.setContentType(contentTypeHeader.getValue());
            }
            for (Header header : closeableHttpResponse.getAllHeaders()) {
                response.addHeader(header.getName(), header.getValue());
            }
            InputStream inputStream = httpEntity.getContent();
            final CloseableHttpResponse referenceCloseableHttpResponse = closeableHttpResponse;
            final Reference reference = FinalizeManager.register((Object)inputStream, (FinalizeAction)new FinalizeAction(){

                public void doFinalize(Reference<?> reference) {
                    block2: {
                        try {
                            referenceCloseableHttpResponse.close();
                        }
                        catch (IOException ioe) {
                            if (!_log.isDebugEnabled()) break block2;
                            _log.debug((Object)"Unable to close response", (Throwable)ioe);
                        }
                    }
                }
            }, (FinalizeManager.ReferenceFactory)FinalizeManager.WEAK_REFERENCE_FACTORY);
            UnsyncFilterInputStream unsyncFilterInputStream = new UnsyncFilterInputStream(inputStream){

                public void close() throws IOException {
                    super.close();
                    referenceCloseableHttpResponse.close();
                    reference.clear();
                }
            };
            return unsyncFilterInputStream;
        }
        catch (Exception e) {
            block43: {
                if (httpEntity != null) {
                    EntityUtils.consumeQuietly(httpEntity);
                }
                if (closeableHttpResponse != null) {
                    try {
                        closeableHttpResponse.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block43;
                        _log.warn((Object)"Unable to close response", (Throwable)e);
                    }
                }
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (basicCookieStore != null) {
                    _cookies.set(this.toServletCookies(basicCookieStore.getCookies()));
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    private boolean _isLetterOrNumber(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    private String _shortenURL(String url, int currentLength) {
        int index = url.indexOf(63);
        if (index == -1) {
            return url;
        }
        StringBundler sb = new StringBundler();
        sb.append(url.substring(0, index));
        sb.append("?");
        String queryString = url.substring(index + 1);
        String[] params = StringUtil.split((String)queryString, (char)'&');
        ArrayList<String> redirectParams = new ArrayList<String>();
        for (String param : params) {
            if (param.contains("_backURL=") || param.contains("_redirect=") || param.contains("_returnToFullPageURL=") || param.startsWith("redirect") && param.indexOf(61) != -1) {
                redirectParams.add(param);
                continue;
            }
            sb.append(param);
            sb.append("&");
        }
        if (currentLength + sb.length() > 2083) {
            sb.setIndex(sb.index() - 1);
            return sb.toString();
        }
        for (String redirectParam : redirectParams) {
            int pos = redirectParam.indexOf(61);
            String key = redirectParam.substring(0, pos);
            String redirect = redirectParam.substring(pos + 1);
            try {
                redirect = URLCodec.decodeURL((String)redirect, (String)"UTF-8");
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Skipping undecodable parameter " + redirectParam), (Throwable)iae);
                continue;
            }
            sb.append(key);
            sb.append("=");
            int newLength = sb.length();
            redirect = URLCodec.encodeURL((String)this._shortenURL(redirect, currentLength + newLength));
            if (currentLength + (newLength += redirect.length()) > 2083) {
                sb.setIndex(sb.index() - 2);
                continue;
            }
            sb.append(redirect);
            sb.append("&");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

