/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.dao.orm.hibernate.DB2Dialect;
import com.liferay.portal.dao.orm.hibernate.HSQLDialect;
import com.liferay.portal.dao.orm.hibernate.MariaDBDialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2005Dialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2008Dialect;
import com.liferay.portal.dao.orm.hibernate.SybaseASE157Dialect;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class DialectDetector {
    private static final Log _log = LogFactoryUtil.getLog(DialectDetector.class);
    private static final Map<String, Dialect> _dialects = new ConcurrentHashMap<String, Dialect>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dialect getDialect(DataSource dataSource) {
        Object dialect;
        String dialectKey;
        block28: {
            dialectKey = null;
            dialect = null;
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String dbName = databaseMetaData.getDatabaseProductName();
                String driverName = databaseMetaData.getDriverName();
                int dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                int dbMinorVersion = databaseMetaData.getDatabaseMinorVersion();
                StringBundler sb = new StringBundler(5);
                sb.append(dbName);
                sb.append(":");
                sb.append(dbMajorVersion);
                sb.append(":");
                sb.append(dbMinorVersion);
                dialectKey = sb.toString();
                dialect = _dialects.get(dialectKey);
                if (dialect != null) {
                    DB2400Dialect dB2400Dialect = dialect;
                    return dB2400Dialect;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Determine dialect for ", dbName, " ", String.valueOf(dbMajorVersion), ".", String.valueOf(dbMinorVersion)}));
                }
                if (dbName.startsWith("HSQL")) {
                    dialect = new HSQLDialect();
                    if (_log.isWarnEnabled()) {
                        sb = new StringBundler(6);
                        sb.append("Liferay is configured to use Hypersonic as ");
                        sb.append("its database. Do NOT use Hypersonic in ");
                        sb.append("production. Hypersonic is an embedded ");
                        sb.append("database useful for development and ");
                        sb.append("demonstration purposes. The database settings ");
                        sb.append("can be changed in portal-ext.properties.");
                        _log.warn((Object)sb.toString());
                    }
                    break block28;
                }
                if (dbName.equals("Adaptive Server Enterprise") && dbMajorVersion >= 15) {
                    dialect = new SybaseASE157Dialect();
                } else {
                    if (dbName.equals("ASE")) {
                        throw new RuntimeException("jTDS is no longer suppported. Please use the Sybase JDBC driver to connect to Sybase.");
                    }
                    dialect = dbName.startsWith("DB2") && dbMajorVersion >= 9 ? new DB2Dialect() : (driverName.startsWith("mariadb") ? new MariaDBDialect() : (dbName.startsWith("Microsoft") && dbMajorVersion == 9 ? new SQLServer2005Dialect() : (dbName.startsWith("Microsoft") && dbMajorVersion == 10 ? new SQLServer2008Dialect() : (dbName.startsWith("Oracle") && dbMajorVersion >= 10 ? new Oracle10gDialect() : DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection)))));
                }
            }
            catch (Exception e) {
                String msg = GetterUtil.getString((String)e.getMessage());
                if (msg.contains("explicitly set for database: DB2")) {
                    dialect = new DB2400Dialect();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"DB2400Dialect was dynamically chosen as the Hibernate dialect for DB2. This can be overriden in portal.properties");
                    }
                }
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (dialect == null) {
            throw new RuntimeException("No dialect found");
        }
        if (dialectKey == null) return dialect;
        if (_log.isInfoEnabled()) {
            Class<?> clazz = dialect.getClass();
            _log.info((Object)("Found dialect " + clazz.getName()));
        }
        _dialects.put(dialectKey, (Dialect)dialect);
        return dialect;
    }
}

