/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.servlet.filters.secure.SecureFilter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointFilter
extends SecureFilter {
    private static final String[] _PREFIXES = new String[]{"/_vti_inf.html", "/_vti_bin", "/sharepoint", "/history", "/resources"};

    @Override
    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.setUsePermissionChecker(true);
    }

    protected boolean isSharepointRequest(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.endsWith("*.asmx")) {
            return true;
        }
        for (String prefix : _PREFIXES) {
            if (!uri.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isWebDAVRequest(String uri) {
        return uri.startsWith("/webdav");
    }

    @Override
    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String method = request.getMethod();
        String userAgent = GetterUtil.getString((String)request.getHeader("User-Agent"));
        if ((userAgent.startsWith("Microsoft Data Access Internet Publishing") || userAgent.startsWith("Microsoft Office Protocol Discovery")) && method.equals("OPTIONS")) {
            this.setOptionsHeaders(request, response);
            return;
        }
        if (!this.isSharepointRequest(request.getRequestURI())) {
            this.processFilter(SharepointFilter.class.getName(), request, response, filterChain);
            return;
        }
        if (method.equals("GET") || method.equals("HEAD")) {
            this.setGetHeaders(response);
        } else if (method.equals("POST")) {
            this.setPostHeaders(response);
        }
        super.processFilter(request, response, filterChain);
    }

    protected void setGetHeaders(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setHeader("Public-Extension", "http://schemas.microsoft.com/repl-2");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("Cache-Control", "no-cache");
    }

    protected void setOptionsHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.isWebDAVRequest(request.getRequestURI())) {
            response.setHeader("MS-Author-Via", "DAV,MS-FP/4.0");
        } else {
            response.setHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        }
        response.setHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("DAV", "1,2");
        response.setHeader("Accept-Ranges", "none");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Allow", "COPY, DELETE, GET, GETLIB, HEAD, LOCK, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, UNLOCK");
    }

    protected void setPostHeaders(HttpServletResponse response) {
        response.setContentType("application/x-vermeer-rpc");
        response.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "close");
    }
}

