/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.service.base.RepositoryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import java.util.ArrayList;
import java.util.Collection;

public class RepositoryServiceImpl
extends RepositoryServiceBaseImpl {
    private static final String _CONFIGURATION = "DEFAULT";
    private static final String[] _SUPPORTED_CONFIGURATIONS = new String[]{"DEFAULT"};
    @BeanReference(type=RepositoryClassDefinitionCatalog.class)
    private RepositoryClassDefinitionCatalog _repositoryClassDefinitionCatalog;

    public Repository addRepository(long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        DLPermission.check(this.getPermissionChecker(), groupId, "ADD_REPOSITORY");
        return this.repositoryLocalService.addRepository(this.getUserId(), groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, false, serviceContext);
    }

    public void checkRepository(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId, 0L, 0L, 0L);
    }

    public void deleteRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "DELETE");
        this.repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public Repository getRepository(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "VIEW");
        return repository;
    }

    @Deprecated
    public String[] getSupportedConfigurations(long classNameId) {
        return _SUPPORTED_CONFIGURATIONS;
    }

    @Deprecated
    public String[] getSupportedParameters(long classNameId, String configuration) {
        try {
            ClassName className = this.classNameLocalService.getClassName(classNameId);
            String repositoryImplClassName = className.getValue();
            return this.getSupportedParameters(repositoryImplClassName, configuration);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    @Deprecated
    public String[] getSupportedParameters(String className, String configuration) {
        try {
            if (!configuration.equals(_CONFIGURATION)) {
                throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Specified ", configuration, " does not match ", "supported configuration ", _CONFIGURATION}));
            }
            ArrayList<String> supportedParameters = new ArrayList<String>();
            RepositoryClassDefinition repositoryClassDefinition = this._repositoryClassDefinitionCatalog.getRepositoryClassDefinition(className);
            RepositoryConfiguration repositoryConfiguration = repositoryClassDefinition.getRepositoryConfiguration();
            Collection repositoryConfigurationParameters = repositoryConfiguration.getParameters();
            for (RepositoryConfiguration.Parameter repositoryConfigurationParameter : repositoryConfigurationParameters) {
                supportedParameters.add(repositoryConfigurationParameter.getName());
            }
            return supportedParameters.toArray(new String[repositoryConfigurationParameters.size()]);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getTypeSettingsProperties(repositoryId);
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "UPDATE");
        this.repositoryLocalService.updateRepository(repositoryId, name, description);
    }

    protected void checkModelPermissions(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion;
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
            if (dlFolder != null) {
                DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
            }
        } else if (fileEntryId != 0L) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
            if (dlFileEntry != null) {
                DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
            }
        } else if (fileVersionId != 0L && (dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId)) != null) {
            DLFileEntryPermission.check(this.getPermissionChecker(), dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkRepository(long repositoryId, long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            this.checkModelPermissions(folderId, fileEntryId, fileVersionId);
            return;
        }
        try {
            Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
            if (repository != null) {
                DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "VIEW");
                return;
            }
        }
        catch (NoSuchRepositoryException nsre) {
            throw new InvalidRepositoryIdException(nsre.getMessage());
        }
    }
}

