/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import com.liferay.portal.util.PropsValues;

public class LegacyAlgorithmAwarePasswordEncryptor
extends BasePasswordEncryptor {
    private static final Log _log = LogFactoryUtil.getLog(LegacyAlgorithmAwarePasswordEncryptor.class);
    private final PasswordEncryptor _parentPasswordEncryptor;

    public static PasswordEncryptor create(PasswordEncryptor parentPasswordEncryptor) {
        if (Validator.isNull((String)PropsValues.PASSWORDS_ENCRYPTION_ALGORITHM_LEGACY)) {
            return parentPasswordEncryptor;
        }
        return new LegacyAlgorithmAwarePasswordEncryptor(parentPasswordEncryptor);
    }

    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (_log.isDebugEnabled()) {
            String message = "Using legacy detection scheme for algorithm " + algorithm + " with current password ";
            message = Validator.isNull((String)encryptedPassword) ? message + "empty" : message + "provided";
            _log.debug((Object)message);
        }
        boolean prependAlgorithm = true;
        if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) != '{') {
            algorithm = PropsValues.PASSWORDS_ENCRYPTION_ALGORITHM_LEGACY;
            prependAlgorithm = false;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using legacy algorithm " + algorithm));
            }
        } else if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) == '{') {
            int index = encryptedPassword.indexOf(125);
            if (index > 0) {
                algorithm = encryptedPassword.substring(1, index);
                encryptedPassword = encryptedPassword.substring(index + 1);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgraded password to use algorithm " + algorithm));
            }
        }
        String newEncryptedPassword = this._parentPasswordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
        if (!prependAlgorithm) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Generated password without algorithm prefix using " + algorithm));
            }
            return newEncryptedPassword;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Generated password with algorithm prefix using " + algorithm));
        }
        StringBundler sb = new StringBundler(4);
        sb.append("{");
        sb.append(this.getAlgorithmName(algorithm));
        sb.append("}");
        sb.append(newEncryptedPassword);
        return sb.toString();
    }

    public String[] getSupportedAlgorithmTypes() {
        return this._parentPasswordEncryptor.getSupportedAlgorithmTypes();
    }

    protected String getAlgorithmName(String algorithm) {
        int index = algorithm.indexOf(47);
        if (index > 0) {
            return algorithm.substring(0, index);
        }
        return algorithm;
    }

    private LegacyAlgorithmAwarePasswordEncryptor(PasswordEncryptor parentPasswordEncryptor) {
        this._parentPasswordEncryptor = parentPasswordEncryptor;
    }
}

