/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.portal.fabric.InputResource;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessChannel;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.metadata.XugglerRawMetadataProcessor;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.ContentHandler;

public class TikaRawMetadataProcessor
extends XugglerRawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(TikaRawMetadataProcessor.class);
    private static volatile ProcessExecutor _processExecutor = (ProcessExecutor)ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, TikaRawMetadataProcessor.class, (String)"_processExecutor", (boolean)true);
    private Parser _parser;

    public void setParser(Parser parser) {
        this._parser = parser;
    }

    protected static Metadata extractMetadata(File file, Metadata metadata, Parser parser) throws IOException {
        if (metadata == null) {
            metadata = new Metadata();
        }
        ParseContext parserContext = new ParseContext();
        parserContext.set(Parser.class, (Object)parser);
        WriteOutContentHandler contentHandler = new WriteOutContentHandler((Writer)new DummyWriter());
        try (FileInputStream inputStream = new FileInputStream(file);){
            parser.parse((InputStream)inputStream, (ContentHandler)contentHandler, metadata, parserContext);
        }
        catch (Exception e) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
            if (throwable instanceof EncryptedDocumentException || throwable instanceof UnsupportedZipFeatureException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to extract metadata from an encrypted file");
                }
            } else if (e instanceof TikaException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to extract metadata");
                }
            } else {
                _log.error((Object)e, (Throwable)e);
            }
            throw new IOException(e);
        }
        metadata.remove(XMPDM.ABS_PEAK_AUDIO_FILE_PATH.getName());
        metadata.remove(XMPDM.RELATIVE_PEAK_AUDIO_FILE_PATH.getName());
        return metadata;
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, File file) {
        Metadata metadata = super.extractMetadata(extension, mimeType, file);
        boolean forkProcess = false;
        if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)mimeType)) {
            forkProcess = true;
        }
        if (forkProcess) {
            ExtractMetadataProcessCallable extractMetadataProcessCallable = new ExtractMetadataProcessCallable(file, metadata, this._parser);
            try {
                ProcessChannel processChannel = _processExecutor.execute(ClassPathUtil.getPortalProcessConfig(), (ProcessCallable)extractMetadataProcessCallable);
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                return (Metadata)future.get();
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        try {
            return TikaRawMetadataProcessor.extractMetadata(file, metadata, this._parser);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    @Override
    protected Metadata extractMetadata(String extension, String mimeType, InputStream inputStream) {
        File file = FileUtil.createTempFile();
        try {
            FileUtil.write((File)file, (InputStream)inputStream);
            Metadata metadata = this.extractMetadata(extension, mimeType, file);
            return metadata;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            file.delete();
        }
    }

    private static class ExtractMetadataProcessCallable
    implements ProcessCallable<Metadata> {
        private static final long serialVersionUID = 1L;
        @InputResource
        private final File _file;
        private final Metadata _metadata;
        private final Parser _parser;

        public ExtractMetadataProcessCallable(File file, Metadata metadata, Parser parser) {
            this._file = file;
            this._metadata = metadata;
            this._parser = parser;
        }

        public Metadata call() throws ProcessException {
            try {
                return TikaRawMetadataProcessor.extractMetadata(this._file, this._metadata, this._parser);
            }
            catch (IOException ioe) {
                throw new ProcessException((Throwable)ioe);
            }
        }
    }
}

