/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.metadata;

import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaMetadataKeys;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.metadata.XMPDM;

public abstract class BaseRawMetadataProcessor
implements RawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(BaseRawMetadataProcessor.class);
    private static final Map<String, Field[]> _fields = new HashMap<String, Field[]>();

    public Map<String, Field[]> getFields() {
        return _fields;
    }

    public Map<String, DDMFormValues> getRawMetadataMap(String extension, String mimeType, File file) throws PortalException {
        Metadata metadata = this.extractMetadata(extension, mimeType, file);
        return this.createDDMFormValuesMap(metadata, this.getFields());
    }

    public Map<String, DDMFormValues> getRawMetadataMap(String extension, String mimeType, InputStream inputStream) throws PortalException {
        Metadata metadata = this.extractMetadata(extension, mimeType, inputStream);
        return this.createDDMFormValuesMap(metadata, this.getFields());
    }

    protected DDMForm createDDMForm(Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.addAvailableLocale(defaultLocale);
        ddmForm.setDefaultLocale(defaultLocale);
        return ddmForm;
    }

    protected DDMFormValues createDDMFormValues(Metadata metadata, Field[] fields) {
        Locale defaultLocale = LocaleUtil.getDefault();
        DDMForm ddmForm = this.createDDMForm(defaultLocale);
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(defaultLocale);
        ddmFormValues.setDefaultLocale(defaultLocale);
        for (Field field : fields) {
            Class<?> fieldClass = field.getDeclaringClass();
            String fieldClassName = fieldClass.getSimpleName();
            String name = fieldClassName.concat("_").concat(field.getName());
            String value = this.getMetadataValue(metadata, field);
            if (value == null) continue;
            DDMFormField ddmFormField = this.createTextDDMFormField(name);
            ddmForm.addDDMFormField(ddmFormField);
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(name);
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected Map<String, DDMFormValues> createDDMFormValuesMap(Metadata metadata, Map<String, Field[]> fieldsMap) {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (metadata == null) {
            return ddmFormValuesMap;
        }
        for (Map.Entry<String, Field[]> entry : fieldsMap.entrySet()) {
            Field[] fields = entry.getValue();
            DDMFormValues ddmFormValues = this.createDDMFormValues(metadata, fields);
            Map ddmFormFieldsValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
            Set names = ddmFormFieldsValuesMap.keySet();
            if (names.isEmpty()) continue;
            ddmFormValuesMap.put(entry.getKey(), ddmFormValues);
        }
        return ddmFormValuesMap;
    }

    protected DDMFormField createTextDDMFormField(String name) {
        DDMFormField ddmFormField = new DDMFormField(name, "text");
        ddmFormField.setDataType("string");
        return ddmFormField;
    }

    protected abstract Metadata extractMetadata(String var1, String var2, File var3) throws PortalException;

    protected abstract Metadata extractMetadata(String var1, String var2, InputStream var3) throws PortalException;

    protected Object getFieldValue(Metadata metadata, Field field) {
        Object fieldValue;
        block2: {
            fieldValue = null;
            try {
                fieldValue = field.get(metadata);
            }
            catch (IllegalAccessException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("The property " + field.getName() + " will not be added to the metatada set"));
            }
        }
        return fieldValue;
    }

    protected String getMetadataValue(Metadata metadata, Field field) {
        Object fieldValue = this.getFieldValue(metadata, field);
        if (fieldValue instanceof String) {
            return metadata.get((String)fieldValue);
        }
        Property property = (Property)fieldValue;
        return metadata.get(property.getName());
    }

    private static void _addFields(Class<?> clazz, List<Field> fields) {
        for (Field field : clazz.getFields()) {
            fields.add(field);
        }
    }

    static {
        ArrayList<Field> fields = new ArrayList<Field>();
        BaseRawMetadataProcessor._addFields(ClimateForcast.class, fields);
        BaseRawMetadataProcessor._addFields(CreativeCommons.class, fields);
        BaseRawMetadataProcessor._addFields(DublinCore.class, fields);
        BaseRawMetadataProcessor._addFields(Geographic.class, fields);
        BaseRawMetadataProcessor._addFields(HttpHeaders.class, fields);
        BaseRawMetadataProcessor._addFields(Message.class, fields);
        BaseRawMetadataProcessor._addFields(Office.class, fields);
        BaseRawMetadataProcessor._addFields(OfficeOpenXMLCore.class, fields);
        BaseRawMetadataProcessor._addFields(TIFF.class, fields);
        BaseRawMetadataProcessor._addFields(TikaMetadataKeys.class, fields);
        BaseRawMetadataProcessor._addFields(TikaMimeKeys.class, fields);
        BaseRawMetadataProcessor._addFields(XMPDM.class, fields);
        _fields.put("TIKARAWMETADATA", fields.toArray(new Field[fields.size()]));
    }
}

