/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.xml;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import java.io.IOException;
import org.dom4j.DocumentException;

public class XMLUtil {
    private static final String _XML_INDENT = "  ";

    public static String fixProlog(String xml) {
        int pos;
        if (xml != null && (pos = xml.indexOf(60)) > 0) {
            xml = xml.substring(pos);
        }
        return xml;
    }

    public static String formatXML(Document document) {
        try {
            return document.formattedString(_XML_INDENT);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public static String formatXML(String xml) {
        try {
            xml = StringUtil.replace((String)xml, (String)"&#", (String)"[$SPECIAL_CHARACTER$]");
            xml = Dom4jUtil.toString(xml, _XML_INDENT);
            xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"&#");
            return xml;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    public static String fromCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String)"[$NEW_LINE$]", (String)"\n");
    }

    public static String stripInvalidChars(String xml) {
        if (Validator.isNull((String)xml)) {
            return xml;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "\r"}, (String[])new String[]{"[$NEW_LINE$]", "[$NEW_LINE$]", "[$NEW_LINE$]"});
    }
}

