/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portlet.social.service.base.SocialActivityLocalServiceBaseImpl;
import com.liferay.portlet.social.util.SocialActivityHierarchyEntry;
import com.liferay.portlet.social.util.SocialActivityHierarchyEntryThreadLocal;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class SocialActivityLocalServiceImpl
extends SocialActivityLocalServiceBaseImpl {
    public void addActivity(long userId, long groupId, Date createDate, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        Group group;
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        if (groupId > 0L && (group = this.groupLocalService.getGroup(groupId)).isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            groupId = layout.getGroupId();
        }
        final SocialActivity activity = this.socialActivityPersistence.create(0L);
        activity.setGroupId(groupId);
        activity.setCompanyId(user.getCompanyId());
        activity.setUserId(user.getUserId());
        activity.setCreateDate(createDate.getTime());
        activity.setMirrorActivityId(0L);
        activity.setClassNameId(classNameId);
        activity.setClassPK(classPK);
        SocialActivityHierarchyEntry activityHierarchyEntry = SocialActivityHierarchyEntryThreadLocal.peek();
        if (activityHierarchyEntry != null) {
            activity.setParentClassNameId(activityHierarchyEntry.getClassNameId());
            activity.setParentClassPK(activityHierarchyEntry.getClassPK());
        }
        activity.setType(type);
        activity.setExtraData(extraData);
        activity.setReceiverUserId(receiverUserId);
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        activity.setAssetEntry(assetEntry);
        SocialActivity mirrorActivity = null;
        if (receiverUserId > 0L && userId != receiverUserId) {
            mirrorActivity = this.socialActivityPersistence.create(0L);
            mirrorActivity.setGroupId(groupId);
            mirrorActivity.setCompanyId(user.getCompanyId());
            mirrorActivity.setUserId(receiverUserId);
            mirrorActivity.setCreateDate(createDate.getTime());
            mirrorActivity.setClassNameId(classNameId);
            mirrorActivity.setClassPK(classPK);
            if (activityHierarchyEntry != null) {
                mirrorActivity.setParentClassNameId(activityHierarchyEntry.getClassNameId());
                mirrorActivity.setParentClassPK(activityHierarchyEntry.getClassPK());
            }
            mirrorActivity.setType(type);
            mirrorActivity.setExtraData(extraData);
            mirrorActivity.setReceiverUserId(user.getUserId());
            mirrorActivity.setAssetEntry(assetEntry);
        }
        final SocialActivity finalMirrorActivity = mirrorActivity;
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SocialActivityLocalServiceImpl.this.socialActivityLocalService.addActivity(activity, finalMirrorActivity);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public void addActivity(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        this.addActivity(userId, groupId, new Date(), className, classPK, type, extraData, receiverUserId);
    }

    @Async
    public void addActivity(SocialActivity activity, SocialActivity mirrorActivity) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        if (activity.getActivityId() > 0L || mirrorActivity != null && mirrorActivity.getActivityId() > 0L) {
            throw new PortalException("Activity and mirror activity must not have primary keys set");
        }
        if (this.isLogActivity(activity)) {
            long activityId = this.counterLocalService.increment(SocialActivity.class.getName());
            activity.setActivityId(activityId);
            this.socialActivityPersistence.update((BaseModel)activity);
            if (mirrorActivity != null) {
                long mirrorActivityId = this.counterLocalService.increment(SocialActivity.class.getName());
                mirrorActivity.setActivityId(mirrorActivityId);
                mirrorActivity.setMirrorActivityId(activity.getPrimaryKey());
                this.socialActivityPersistence.update((BaseModel)mirrorActivity);
            }
            this.socialActivityInterpreterLocalService.updateActivitySet(activity.getActivityId());
        }
        this.socialActivityCounterLocalService.addActivityCounters(activity);
    }

    public void addUniqueActivity(long userId, long groupId, Date createDate, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialActivity socialActivity = this.socialActivityPersistence.fetchByG_U_CD_C_C_T_R(groupId, userId, createDate.getTime(), classNameId, classPK, type, receiverUserId);
        if (socialActivity != null) {
            return;
        }
        this.addActivity(userId, groupId, createDate, className, classPK, type, extraData, receiverUserId);
    }

    public void addUniqueActivity(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        int count = this.socialActivityPersistence.countByG_U_C_C_T_R(groupId, userId, classNameId, classPK, type, receiverUserId);
        if (count > 0) {
            return;
        }
        this.addActivity(userId, groupId, new Date(), className, classPK, type, extraData, receiverUserId);
    }

    public void deleteActivities(AssetEntry assetEntry) throws PortalException {
        this.deleteActivities(assetEntry.getClassName(), assetEntry.getClassPK());
    }

    public void deleteActivities(long groupId) {
        this.socialActivitySetPersistence.removeByGroupId(groupId);
        this.socialActivityPersistence.removeByGroupId(groupId);
        this.socialActivityCounterPersistence.removeByGroupId(groupId);
        this.socialActivityLimitPersistence.removeByGroupId(groupId);
        this.socialActivitySettingPersistence.removeByGroupId(groupId);
    }

    public void deleteActivities(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.deleteActivities(classNameId, classPK);
    }

    public void deleteActivity(long activityId) throws PortalException {
        SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
        this.deleteActivity(activity);
    }

    public void deleteActivity(SocialActivity activity) throws PortalException {
        this.socialActivitySetLocalService.decrementActivityCount(activity.getActivitySetId());
        this.socialActivityPersistence.remove((BaseModel)activity);
        SocialActivity mirrorActivity = this.socialActivityPersistence.fetchByMirrorActivityId(activity.getActivityId());
        if (mirrorActivity != null) {
            this.socialActivityPersistence.remove((BaseModel)mirrorActivity);
        }
    }

    public void deleteUserActivities(long userId) throws PortalException {
        List activities = this.socialActivityPersistence.findByUserId(userId, -1, -1);
        for (SocialActivity activity : activities) {
            this.socialActivitySetLocalService.decrementActivityCount(activity.getActivitySetId());
            this.socialActivityPersistence.remove((BaseModel)activity);
        }
        activities = this.socialActivityPersistence.findByReceiverUserId(userId, -1, -1);
        for (SocialActivity activity : activities) {
            this.socialActivitySetLocalService.decrementActivityCount(activity.getActivitySetId());
            this.socialActivityPersistence.remove((BaseModel)activity);
        }
        this.socialActivityCounterLocalService.deleteActivityCounters(User.class.getName(), userId);
    }

    public SocialActivity fetchFirstActivity(String className, long classPK, int type) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.socialActivityPersistence.fetchByC_C_T_First(classNameId, classPK, type, null);
    }

    public List<SocialActivity> getActivities(long classNameId, int start, int end) {
        return this.socialActivityPersistence.findByClassNameId(classNameId, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, long classNameId, long classPK, int start, int end) {
        return this.socialActivityPersistence.findByM_C_C(mirrorActivityId, classNameId, classPK, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, String className, long classPK, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivities(mirrorActivityId, classNameId, classPK, start, end);
    }

    public List<SocialActivity> getActivities(String className, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivities(classNameId, start, end);
    }

    public int getActivitiesCount(long classNameId) {
        return this.socialActivityPersistence.countByClassNameId(classNameId);
    }

    public int getActivitiesCount(long userId, long groupId, Date createDate, String className, long classPK, int type, long receiverUserId) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.socialActivityPersistence.countByG_U_CD_C_C_T_R(groupId, userId, createDate.getTime(), classNameId, classPK, type, receiverUserId);
    }

    public int getActivitiesCount(long mirrorActivityId, long classNameId, long classPK) {
        return this.socialActivityPersistence.countByM_C_C(mirrorActivityId, classNameId, classPK);
    }

    public int getActivitiesCount(long mirrorActivityId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivitiesCount(mirrorActivityId, classNameId, classPK);
    }

    public int getActivitiesCount(String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivitiesCount(classNameId);
    }

    public SocialActivity getActivity(long activityId) throws PortalException {
        return this.socialActivityPersistence.findByPrimaryKey(activityId);
    }

    public List<SocialActivity> getActivitySetActivities(long activitySetId, int start, int end) {
        return this.socialActivityPersistence.findByActivitySetId(activitySetId, start, end);
    }

    public List<SocialActivity> getGroupActivities(long groupId, int start, int end) {
        return this.socialActivityFinder.findByGroupId(groupId, start, end);
    }

    public int getGroupActivitiesCount(long groupId) {
        return this.socialActivityFinder.countByGroupId(groupId);
    }

    public List<SocialActivity> getGroupUsersActivities(long groupId, int start, int end) {
        return this.socialActivityFinder.findByGroupUsers(groupId, start, end);
    }

    public int getGroupUsersActivitiesCount(long groupId) {
        return this.socialActivityFinder.countByGroupUsers(groupId);
    }

    public SocialActivity getMirrorActivity(long mirrorActivityId) throws PortalException {
        return this.socialActivityPersistence.findByMirrorActivityId(mirrorActivityId);
    }

    public List<SocialActivity> getOrganizationActivities(long organizationId, int start, int end) {
        return this.socialActivityFinder.findByOrganizationId(organizationId, start, end);
    }

    public int getOrganizationActivitiesCount(long organizationId) {
        return this.socialActivityFinder.countByOrganizationId(organizationId);
    }

    public List<SocialActivity> getOrganizationUsersActivities(long organizationId, int start, int end) {
        return this.socialActivityFinder.findByOrganizationUsers(organizationId, start, end);
    }

    public int getOrganizationUsersActivitiesCount(long organizationId) {
        return this.socialActivityFinder.countByOrganizationUsers(organizationId);
    }

    public List<SocialActivity> getRelationActivities(long userId, int start, int end) {
        return this.socialActivityFinder.findByRelation(userId, start, end);
    }

    public List<SocialActivity> getRelationActivities(long userId, int type, int start, int end) {
        return this.socialActivityFinder.findByRelationType(userId, type, start, end);
    }

    public int getRelationActivitiesCount(long userId) {
        return this.socialActivityFinder.countByRelation(userId);
    }

    public int getRelationActivitiesCount(long userId, int type) {
        return this.socialActivityFinder.countByRelationType(userId, type);
    }

    public List<SocialActivity> getUserActivities(long userId, int start, int end) {
        return this.socialActivityPersistence.findByUserId(userId, start, end);
    }

    public int getUserActivitiesCount(long userId) {
        return this.socialActivityPersistence.countByUserId(userId);
    }

    public List<SocialActivity> getUserGroupsActivities(long userId, int start, int end) {
        return this.socialActivityFinder.findByUserGroups(userId, start, end);
    }

    public int getUserGroupsActivitiesCount(long userId) {
        return this.socialActivityFinder.countByUserGroups(userId);
    }

    public List<SocialActivity> getUserGroupsAndOrganizationsActivities(long userId, int start, int end) {
        return this.socialActivityFinder.findByUserGroupsAndOrganizations(userId, start, end);
    }

    public int getUserGroupsAndOrganizationsActivitiesCount(long userId) {
        return this.socialActivityFinder.countByUserGroupsAndOrganizations(userId);
    }

    public List<SocialActivity> getUserOrganizationsActivities(long userId, int start, int end) {
        return this.socialActivityFinder.findByUserOrganizations(userId, start, end);
    }

    public int getUserOrganizationsActivitiesCount(long userId) {
        return this.socialActivityFinder.countByUserOrganizations(userId);
    }

    protected void deleteActivities(long classNameId, long classPK) throws PortalException {
        this.socialActivitySetLocalService.decrementActivityCount(classNameId, classPK);
        this.socialActivityPersistence.removeByC_C(classNameId, classPK);
        this.socialActivityCounterLocalService.deleteActivityCounters(classNameId, classPK);
    }

    protected boolean isLogActivity(SocialActivity activity) {
        if (activity.getType() == 10000) {
            return activity.getParentClassPK() == 0L;
        }
        SocialActivityDefinition activityDefinition = this.socialActivitySettingLocalService.getActivityDefinition(activity.getGroupId(), activity.getClassName(), activity.getType());
        if (activityDefinition != null) {
            return activityDefinition.isLogActivity();
        }
        return activity.getType() < 10001;
    }
}

