/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.message.boards.kernel.model.MBBan;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBMessageConstants;
import com.liferay.message.boards.kernel.model.MBStatsUser;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBThreadLocalServiceUtil;
import com.liferay.petra.mail.JavaMailUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class MBUtil {
    public static final String BB_CODE_EDITOR_WYSIWYG_IMPL_KEY = "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_message.bb_code.jsp";
    public static final String EMOTICONS = "/emoticons";
    public static final String MESSAGE_POP_PORTLET_PREFIX = "mb_message.";
    private static final Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static void collectMultipartContent(MimeMultipart multipart, MBMailMessage collector) throws Exception {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            MBUtil.collectPartContent((Part)part, collector);
        }
    }

    public static void collectPartContent(Part part, MBMailMessage mbMailMessage) throws Exception {
        Object partContent = MBUtil._getPartContent(part);
        String contentType = StringUtil.toLowerCase((String)part.getContentType());
        if (part.getDisposition() != null && StringUtil.equalsIgnoreCase((String)part.getDisposition(), (String)"attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                bytes = ((String)partContent).getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = JavaMailUtil.getBytes((Part)part);
            }
            mbMailMessage.addBytes(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)partContent;
            MBUtil.collectMultipartContent(mimeMultipart, mbMailMessage);
        } else if (partContent instanceof String) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("emailPartToMBMessageBody", Boolean.TRUE);
            String messageBody = SanitizerUtil.sanitize((long)0L, (long)0L, (long)0L, (String)MBMessage.class.getName(), (long)0L, (String)contentType, (String)"ALL", (String)((String)partContent), options);
            if (contentType.startsWith("text/html")) {
                mbMailMessage.setHtmlBody(messageBody);
            } else {
                mbMailMessage.setPlainBody(messageBody);
            }
        }
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long mbCategoryId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (mbCategoryId == 0L) {
            return themeDisplay.translate("home");
        }
        MBCategory mbCategory = MBCategoryLocalServiceUtil.fetchMBCategory((long)mbCategoryId);
        List categories = mbCategory.getAncestors();
        Collections.reverse(categories);
        StringBundler sb = new StringBundler(categories.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (MBCategory curCategory : categories) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curCategory.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(mbCategory.getName());
        return sb.toString();
    }

    public static String getBBCodeHTML(String msgBody, String pathThemeImages) {
        return StringUtil.replace((String)BBCodeTranslatorUtil.getHTML((String)msgBody), (String)"@theme_images_path@/emoticons", (String)(pathThemeImages + EMOTICONS));
    }

    public static String getBBCodeQuoteBody(HttpServletRequest request, MBMessage parentMessage) {
        String parentAuthor = null;
        parentAuthor = parentMessage.isAnonymous() ? LanguageUtil.get((HttpServletRequest)request, (String)"anonymous") : HtmlUtil.escape((String)PortalUtil.getUserName((BaseModel)parentMessage));
        StringBundler sb = new StringBundler(5);
        sb.append("[quote=");
        sb.append(StringUtil.replace((String)parentAuthor, (String[])new String[]{"[", "]", "(", ")"}, (String[])new String[]{"&#91;", "&#93;", "&#40;", "&#41;"}));
        sb.append("]\n");
        sb.append(parentMessage.getBody(false));
        sb.append("[/quote]\n\n\n");
        return sb.toString();
    }

    public static String getBBCodeSplitThreadBody(HttpServletRequest request) {
        StringBundler sb = new StringBundler(5);
        sb.append("[url=");
        sb.append("${newThreadURL}");
        sb.append("]");
        sb.append("${newThreadURL}");
        sb.append("[/url]");
        return LanguageUtil.format((HttpServletRequest)request, (String)"the-new-thread-can-be-found-at-x", (Object)sb.toString(), (boolean)false);
    }

    public static long getCategoryId(HttpServletRequest request, MBCategory category) {
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(HttpServletRequest request, MBMessage message) {
        long categoryId = 0L;
        if (message != null) {
            categoryId = message.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(String messageIdString) {
        String[] parts = MBUtil._getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[0]);
    }

    @Deprecated
    public static Set<Long> getCategorySubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBCategory.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$CATEGORY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-category-in-which-the-message-has-been-posted"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-message-board"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            definitionTerms.put("[$MAILING_LIST_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-mailing-list"));
        }
        definitionTerms.put("[$MESSAGE_BODY$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-body"));
        definitionTerms.put("[$MESSAGE_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-id"));
        definitionTerms.put("[$MESSAGE_SUBJECT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-subject"));
        definitionTerms.put("[$MESSAGE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-message-url"));
        definitionTerms.put("[$MESSAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-message"));
        definitionTerms.put("[$MESSAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-message"));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-message-board"));
        if (!PropsValues.MESSAGE_BOARDS_EMAIL_BULK) {
            definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
            definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        }
        return definitionTerms;
    }

    public static Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-message-board"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-message-board"));
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            definitionTerms.put("[$MAILING_LIST_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-mailing-list"));
        }
        definitionTerms.put("[$MESSAGE_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-message"));
        definitionTerms.put("[$MESSAGE_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-message"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-message-board"));
        return definitionTerms;
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            long categoryId = GetterUtil.getLong((String)document.get("categoryId"));
            try {
                MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Message boards search index is stale and contains category " + categoryId));
                continue;
            }
            long threadId = GetterUtil.getLong((String)document.get("threadId"));
            try {
                MBThreadLocalServiceUtil.getThread((long)threadId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Message boards search index is stale and contains thread " + threadId));
                continue;
            }
            String entryClassName = document.get("entryClassName");
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            MBMessage obj = null;
            try {
                if (entryClassName.equals(DLFileEntry.class.getName())) {
                    long classPK = GetterUtil.getLong((String)document.get("classPK"));
                    MBMessageLocalServiceUtil.getMessage((long)classPK);
                    obj = DLFileEntryLocalServiceUtil.getDLFileEntry((long)entryClassPK);
                } else if (entryClassName.equals(MBMessage.class.getName())) {
                    obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Message boards search index is stale and ", "contains entry {className=", entryClassName, ", classPK=", String.valueOf(entryClassPK), "}"}));
            }
        }
        return entries;
    }

    public static String getHtmlQuoteBody(HttpServletRequest request, MBMessage parentMessage) {
        String parentAuthor = null;
        parentAuthor = parentMessage.isAnonymous() ? LanguageUtil.get((HttpServletRequest)request, (String)"anonymous") : HtmlUtil.escape((String)PortalUtil.getUserName((BaseModel)parentMessage));
        StringBundler sb = new StringBundler(5);
        sb.append("<blockquote><div class=\"quote-title\">");
        sb.append(parentAuthor);
        sb.append(": </div><div class=\"quote\"><div class=\"quote-content\">");
        sb.append(parentMessage.getBody(false));
        sb.append("</div></blockquote><br /><br /><br />");
        return sb.toString();
    }

    public static String getHtmlSplitThreadBody(HttpServletRequest request) {
        StringBundler sb = new StringBundler(5);
        sb.append("<a href=");
        sb.append("${newThreadURL}");
        sb.append(">");
        sb.append("${newThreadURL}");
        sb.append("</a>");
        return LanguageUtil.format((HttpServletRequest)request, (String)"the-new-thread-can-be-found-at-x", (Object)sb.toString(), (boolean)false);
    }

    public static long getMessageId(String messageIdString) {
        String[] parts = MBUtil._getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[1]);
    }

    public static int getMessageIdStringOffset() {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() == 0) {
            return 1;
        }
        return 0;
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentMessageIdString = MBUtil.getParentMessageIdString(message);
        if (parentMessageIdString != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentMessageIdString));
            }
            parentMessageId = MBUtil.getMessageId(parentMessageIdString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        Object[] inReplyToHeaders;
        Object reference;
        int x;
        Object parentHeader = null;
        Object[] references = message.getHeader("References");
        if (ArrayUtil.isNotEmpty((Object[])references) && (x = ((String)(reference = references[0])).lastIndexOf("<mb_message.")) > -1) {
            int y = ((String)reference).indexOf(">", x);
            parentHeader = ((String)reference).substring(x, y + 1);
        }
        if (parentHeader == null && ArrayUtil.isNotEmpty((Object[])(inReplyToHeaders = message.getHeader("In-Reply-To")))) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !((String)parentHeader).startsWith(MESSAGE_POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getReplyToAddress(long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() <= 0) {
            return defaultMailingListAddress;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(MESSAGE_POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        return sb.toString();
    }

    public static String getRSSURL(long plid, long categoryId, long threadId, long userId, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(10);
        sb.append(themeDisplay.getPortalURL());
        sb.append(themeDisplay.getPathMain());
        sb.append("/message_boards/rss?p_l_id=");
        sb.append(plid);
        if (categoryId > 0L) {
            sb.append("&mbCategoryId=");
            sb.append(categoryId);
        } else {
            sb.append("&groupId=");
            sb.append(themeDisplay.getScopeGroupId());
        }
        if (threadId > 0L) {
            sb.append("&threadId=");
            sb.append(threadId);
        }
        if (userId > 0L) {
            sb.append("&userId=");
            sb.append(userId);
        }
        return sb.toString();
    }

    public static String getSubjectForEmail(MBMessage message) throws Exception {
        String subject = message.getSubject();
        if (subject.startsWith("RE: ")) {
            return subject;
        }
        return "RE: " + message.getSubject();
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static String[] getThreadPriority(MBGroupServiceSettings mbGroupServiceSettings, String languageId, double value) throws Exception {
        String[] priorities = mbGroupServiceSettings.getPriorities(languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            priorities = mbGroupServiceSettings.getPriorities(defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, priorities);
        }
        return priorityPair;
    }

    @Deprecated
    public static Set<Long> getThreadSubscriptionClassPKs(long userId) {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBThread.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static String getUserRank(MBGroupServiceSettings mbGroupServiceSettings, String languageId, int posts) throws Exception {
        String rank = "";
        String[] ranks = mbGroupServiceSettings.getRanks(languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (char)'=');
            String kvpName = kvp[0];
            int kvpPosts = GetterUtil.getInteger((String)kvp[1]);
            if (posts < kvpPosts) break;
            rank = kvpName;
        }
        return rank;
    }

    public static String[] getUserRank(MBGroupServiceSettings mbGroupServiceSettings, String languageId, MBStatsUser statsUser) throws Exception {
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        String[] ranks = mbGroupServiceSettings.getRanks(languageId);
        for (int i = 0; i < ranks.length; ++i) {
            String[] kvp = StringUtil.split((String)ranks[i], (char)'=');
            String curRank = kvp[0];
            String curRankValue = kvp[1];
            String[] curRankValueKvp = StringUtil.split((String)curRankValue, (char)':');
            if (curRankValueKvp.length <= 1) {
                int posts = GetterUtil.getInteger((String)curRankValue);
                if (posts > statsUser.getMessageCount() || posts < maxPosts) continue;
                rank[0] = curRank;
                maxPosts = posts;
                continue;
            }
            String entityType = curRankValueKvp[0];
            String entityValue = curRankValueKvp[1];
            try {
                if (!MBUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) continue;
                rank[1] = curRank;
                break;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)e);
            }
        }
        return rank;
    }

    public static boolean hasMailIdHeader(Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null) {
            return false;
        }
        for (String messageId : messageIds) {
            if (!Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN) || !messageId.contains(PropsValues.POP_SERVER_SUBDOMAIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMessageFormat(String messageFormat) {
        String editorName = PropsUtil.get((String)BB_CODE_EDITOR_WYSIWYG_IMPL_KEY);
        if (editorName.equals("bbcode")) {
            editorName = "alloyeditor_bbcode";
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Replacing unsupported BBCode editor with AlloyEditor BBCode");
            }
        }
        if (messageFormat.equals("bbcode") && !editorName.equals("alloyeditor_bbcode") && !editorName.equals("ckeditor_bbcode")) {
            return false;
        }
        return ArrayUtil.contains((Object[])MBMessageConstants.FORMATS, (Object)messageFormat);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message) throws Exception {
        return MBUtil.isViewableMessage(themeDisplay, message, message);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message, MBMessage parentMessage) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, parentMessage, "VIEW")) {
            return false;
        }
        if (message.getMessageId() != parentMessage.getMessageId() && !MBMessagePermission.contains(permissionChecker, message, "VIEW")) {
            return false;
        }
        return message.isApproved() || message.getUserId() == themeDisplay.getUserId() || permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId());
    }

    public static void propagatePermissions(long companyId, long groupId, long parentMessageId, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMBMessage((long)parentMessageId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole((long)groupId);
        Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)MBMessage.class.getName());
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)MBMessage.class.getName(), (int)4, (String)String.valueOf(parentMessage.getMessageId()), (Collection)actionIds);
        Set defaultGroupActionIds = (Set)roleIdsToActionIds.get(defaultGroupRole.getRoleId());
        if (defaultGroupActionIds == null) {
            serviceContext.setGroupPermissions(new String[0]);
        } else {
            serviceContext.setGroupPermissions(defaultGroupActionIds.toArray(new String[defaultGroupActionIds.size()]));
        }
        Set guestActionIds = (Set)roleIdsToActionIds.get(guestRole.getRoleId());
        if (guestActionIds == null) {
            serviceContext.setGuestPermissions(new String[0]);
        } else {
            serviceContext.setGuestPermissions(guestActionIds.toArray(new String[guestActionIds.size()]));
        }
    }

    public static String replaceMessageBodyPaths(ThemeDisplay themeDisplay, String messageBody) {
        return StringUtil.replace((String)messageBody, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
    }

    public static void updateCategoryMessageCount(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateMessageCount((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryStatistics(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateStatistics((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryThreadCount(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateThreadCount((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateThreadMessageCount(final long threadId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBThreadLocalServiceUtil.updateMessageCount((long)threadId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    private static String[] _findThreadPriority(double value, String[] priorities) {
        for (int i = 0; i < priorities.length; ++i) {
            String[] priority = StringUtil.split((String)priorities[i], (String)"|");
            try {
                String priorityName = priority[0];
                String priorityImage = priority[1];
                double priorityValue = GetterUtil.getDouble((String)priority[2]);
                if (value != priorityValue) continue;
                return new String[]{priorityName, priorityImage};
            }
            catch (Exception e) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e);
            }
        }
        return null;
    }

    private static String[] _getMessageIdStringParts(String messageIdString) {
        int start = messageIdString.indexOf(MESSAGE_POP_PORTLET_PREFIX) + MESSAGE_POP_PORTLET_PREFIX.length();
        int end = messageIdString.indexOf(64);
        return StringUtil.split((String)messageIdString.substring(start, end), (char)'.');
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        if (message.getSubject() == null) {
            return null;
        }
        String parentMessageId = null;
        String subject = message.getSubject();
        int pos = subject.lastIndexOf(60);
        if (pos != -1) {
            parentMessageId = subject.substring(pos);
        }
        return parentMessageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _getPartContent(Part part) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(Part.class.getClassLoader());
            Object object = part.getContent();
            return object;
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        Role role;
        long groupId = statsUser.getGroupId();
        long userId = statsUser.getUserId();
        return entityType.equals("organization-role") || entityType.equals("site-role") ? UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)groupId, (long)(role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue)).getRoleId(), (boolean)true) : (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId)));
    }
}

