/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.exception.CategoryNameException;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBCategoryConstants;
import com.liferay.message.boards.kernel.model.MBMailingList;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.base.MBCategoryLocalServiceBaseImpl;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MBCategoryLocalServiceImpl
extends MBCategoryLocalServiceBaseImpl {
    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this.addCategory(userId, parentCategoryId, name, description, MBCategoryConstants.DEFAULT_DISPLAY_STYLE, null, null, null, 0, false, null, null, 0, null, false, null, 0, false, null, null, false, false, serviceContext);
    }

    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        MBCategory category = this.mbCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        category.setDisplayStyle(displayStyle);
        category.setExpandoBridgeAttributes(serviceContext);
        this.mbCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getModelPermissions());
        }
        this.mbMailingListLocalService.addMailingList(userId, groupId, category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, ModelPermissions modelPermissions) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, modelPermissions);
    }

    public void addCategoryResources(MBCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(MBCategory category, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), modelPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.mbCategoryLocalService.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.mbCategoryLocalService.deleteCategory(category);
    }

    public void deleteCategory(MBCategory category) throws PortalException {
        this.mbCategoryLocalService.deleteCategory(category, true);
    }

    @SystemEvent(action=1, type=1)
    public void deleteCategory(MBCategory category, boolean includeTrashedEntries) throws PortalException {
        List categories = this.mbCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (MBCategory curCategory : categories) {
            if (!includeTrashedEntries && curCategory.isInTrashExplicitly()) continue;
            this.mbCategoryLocalService.deleteCategory(curCategory, includeTrashedEntries);
        }
        this.mbThreadLocalService.deleteThreads(category.getGroupId(), category.getCategoryId(), includeTrashedEntries);
        MBMailingList mbMailingList = this.mbMailingListLocalService.fetchCategoryMailingList(category.getGroupId(), category.getCategoryId());
        if (mbMailingList != null) {
            this.mbMailingListLocalService.deleteMailingList(mbMailingList);
        }
        this.expandoRowLocalService.deleteRows(category.getCategoryId());
        this.ratingsStatsLocalService.deleteStats(MBCategory.class.getName(), category.getCategoryId());
        this.resourceLocalService.deleteResource(category.getCompanyId(), MBCategory.class.getName(), 4, category.getCategoryId());
        if (category.isInTrashExplicitly()) {
            this.trashEntryLocalService.deleteEntry(MBCategory.class.getName(), category.getCategoryId());
        } else {
            this.trashVersionLocalService.deleteTrashVersion(MBCategory.class.getName(), category.getCategoryId());
        }
        this.mbCategoryPersistence.remove((BaseModel)category);
    }

    public List<MBCategory> getCategories(long groupId) {
        return this.mbCategoryPersistence.findByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, int status) {
        return this.mbCategoryPersistence.findByG_S(groupId, status);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long excludedCategoryId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByNotC_G_P(excludedCategoryId, groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.findByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryIds, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.findByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status, start, end);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.countC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.countC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesCount(long groupId) {
        return this.mbCategoryPersistence.countByGroupId(groupId);
    }

    public int getCategoriesCount(long groupId, int status) {
        return this.mbCategoryPersistence.countByG_S(groupId, status);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long excludedCategoryId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByNotC_G_P(excludedCategoryId, groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.countByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryIds, status);
    }

    public int getCategoriesCount(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.countByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status);
    }

    public MBCategory getCategory(long categoryId) throws PortalException {
        MBCategoryImpl category = null;
        if (categoryId != 0L && categoryId != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(categoryId);
            category.setParentCategoryId(categoryId);
        }
        return category;
    }

    public List<MBCategory> getCompanyCategories(long companyId, int start, int end) {
        return this.mbCategoryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyCategoriesCount(long companyId) {
        return this.mbCategoryPersistence.countByCompanyId(companyId);
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, null);
        return this.mbCategoryFinder.findC_ByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.countC_ByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public void moveCategoriesToTrash(long groupId, long userId) throws PortalException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.moveCategoryToTrash(userId, category.getCategoryId());
        }
    }

    public MBCategory moveCategory(long categoryId, long parentCategoryId, boolean mergeWithParentCategory) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        category.setParentCategoryId(parentCategoryId);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
    }

    public MBCategory moveCategoryFromTrash(long userId, long categoryId, long newCategoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (!category.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (category.isInTrashExplicitly()) {
            this.restoreCategoryFromTrash(userId, categoryId);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(MBCategory.class.getName(), category.getCategoryId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, categoryId, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            User user = this.userPersistence.findByPrimaryKey(userId);
            List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId, 8);
            this.restoreDependentsFromTrash(user, categoriesAndThreads);
        }
        return this.moveCategory(categoryId, newCategoryId, false);
    }

    public MBCategory moveCategoryToTrash(long userId, long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (category.isInTrash()) {
            throw new TrashEntryException();
        }
        category = this.updateStatus(userId, categoryId, 8);
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, category.getGroupId(), MBCategory.class.getName(), categoryId, category.getUuid(), null, 0, null, null);
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId);
        this.moveDependentsToTrash(user, categoriesAndThreads, trashEntry.getEntryId());
        return category;
    }

    public void restoreCategoryFromTrash(long userId, long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (!category.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(MBCategory.class.getName(), categoryId);
        category = this.updateStatus(userId, categoryId, 0);
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Object> categoriesAndThreads = this.getCategoriesAndThreads(category.getGroupId(), categoryId, 8);
        this.restoreDependentsFromTrash(user, categoriesAndThreads);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void subscribeCategory(long userId, long groupId, long categoryId) throws PortalException {
    }

    public void unsubscribeCategory(long userId, long groupId, long categoryId) throws PortalException {
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return null;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        this.validate(name);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        if (!displayStyle.equals(category.getDisplayStyle())) {
            category.setDisplayStyle(displayStyle);
            this.updateChildCategoriesDisplayStyle(category, displayStyle);
        }
        category.setExpandoBridgeAttributes(serviceContext);
        this.mbCategoryPersistence.update((BaseModel)category);
        MBMailingList mailingList = this.mbMailingListPersistence.fetchByG_C(category.getGroupId(), category.getCategoryId());
        if (mailingList != null) {
            this.mbMailingListLocalService.updateMailingList(mailingList.getMailingListId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        } else {
            this.mbMailingListLocalService.addMailingList(category.getUserId(), category.getGroupId(), category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        }
        return category;
    }

    public MBCategory updateMessageCount(long categoryId) {
        MBCategory mbCategory = this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
        if (mbCategory == null) {
            return null;
        }
        int messageCount = this.mbMessageLocalService.getCategoryMessagesCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), 0);
        mbCategory.setMessageCount(messageCount);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)mbCategory);
    }

    public MBCategory updateStatistics(long categoryId) {
        MBCategory mbCategory = this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
        if (mbCategory == null) {
            return null;
        }
        int messageCount = this.mbMessageLocalService.getCategoryMessagesCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), 0);
        mbCategory.setMessageCount(messageCount);
        int threadCount = this.mbThreadLocalService.getCategoryThreadsCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), 0);
        mbCategory.setThreadCount(threadCount);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)mbCategory);
    }

    public MBCategory updateStatus(long userId, long categoryId, int status) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        category.setStatus(status);
        category.setStatusByUserId(user.getUserId());
        category.setStatusByUserName(user.getFullName());
        category.setStatusDate(new Date());
        this.mbCategoryPersistence.update((BaseModel)category);
        return category;
    }

    public MBCategory updateThreadCount(long categoryId) {
        MBCategory mbCategory = this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
        if (mbCategory == null) {
            return null;
        }
        int threadCount = this.mbThreadLocalService.getCategoryThreadsCount(mbCategory.getGroupId(), mbCategory.getCategoryId(), 0);
        mbCategory.setThreadCount(threadCount);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)mbCategory);
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) {
        MBCategory parentCategory;
        if (parentCategoryId != 0L && parentCategoryId != -1L && ((parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(MBCategory category, long parentCategoryId) {
        if (parentCategoryId == 0L || parentCategoryId == -1L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        MBCategory parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(MBCategory fromCategory, long toCategoryId) throws PortalException {
        if (toCategoryId == 0L || toCategoryId == -1L) {
            return;
        }
        List categories = this.mbCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (Object category : categories) {
            this.mergeCategories((MBCategory)category, toCategoryId);
        }
        List threads = this.mbThreadPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBThread thread : threads) {
            thread.setCategoryId(toCategoryId);
            this.mbThreadPersistence.update((BaseModel)thread);
            List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                message.setCategoryId(toCategoryId);
                this.mbMessagePersistence.update((BaseModel)message);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
        }
        MBCategory toCategory = this.mbCategoryPersistence.findByPrimaryKey(toCategoryId);
        toCategory.setThreadCount(fromCategory.getThreadCount() + toCategory.getThreadCount());
        toCategory.setMessageCount(fromCategory.getMessageCount() + toCategory.getMessageCount());
        this.mbCategoryPersistence.update((BaseModel)toCategory);
        this.mbCategoryLocalService.deleteCategory(fromCategory);
    }

    protected void moveDependentsToTrash(User user, List<Object> categoriesAndThreads, long trashEntryId) throws PortalException {
        for (Object object : categoriesAndThreads) {
            MBCategory category;
            int oldStatus;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                oldStatus = thread.getStatus();
                if (oldStatus == 8) continue;
                thread.setStatus(8);
                this.mbThreadPersistence.update((BaseModel)thread);
                if (oldStatus != 0) {
                    this.trashVersionLocalService.addTrashVersion(trashEntryId, MBThread.class.getName(), thread.getThreadId(), oldStatus, null);
                }
                this.mbThreadLocalService.moveDependentsToTrash(thread.getGroupId(), thread.getThreadId(), trashEntryId);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
                indexer.reindex((Object)thread);
                continue;
            }
            if (!(object instanceof MBCategory) || (category = (MBCategory)object).isInTrash()) continue;
            oldStatus = category.getStatus();
            category.setStatus(8);
            this.mbCategoryPersistence.update((BaseModel)category);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, MBCategory.class.getName(), category.getCategoryId(), oldStatus, null);
            }
            this.moveDependentsToTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId()), trashEntryId);
        }
    }

    protected void restoreDependentsFromTrash(User user, List<Object> categoriesAndThreads) throws PortalException {
        for (Object object : categoriesAndThreads) {
            MBCategory category;
            int oldStatus;
            TrashVersion trashVersion;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                if (!thread.isInTrashImplicitly()) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(MBThread.class.getName(), thread.getThreadId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                thread.setStatus(oldStatus);
                this.mbThreadPersistence.update((BaseModel)thread);
                this.mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), thread.getThreadId());
                if (trashVersion != null) {
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
                indexer.reindex((Object)thread);
                continue;
            }
            if (!(object instanceof MBCategory) || !(category = (MBCategory)object).isInTrashImplicitly()) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(MBCategory.class.getName(), category.getCategoryId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            category.setStatus(oldStatus);
            this.mbCategoryPersistence.update((BaseModel)category);
            this.restoreDependentsFromTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId(), 8));
            if (trashVersion == null) continue;
            this.trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
    }

    protected void updateChildCategoriesDisplayStyle(MBCategory category, String displayStyle) throws PortalException {
        List<MBCategory> categories = this.getCategories(category.getGroupId(), category.getCategoryId(), -1, -1);
        for (MBCategory curCategory : categories) {
            this.updateChildCategoriesDisplayStyle(curCategory, displayStyle);
            curCategory.setDisplayStyle(displayStyle);
            this.mbCategoryPersistence.update((BaseModel)curCategory);
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CategoryNameException("Name is null");
        }
    }
}

