/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileRank;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.service.base.DLAppLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DLAppLocalServiceImpl
extends DLAppLocalServiceBaseImpl {
    @BeanReference(type=RepositoryProvider.class)
    protected RepositoryProvider repositoryProvider;
    private static final Log _log = LogFactoryUtil.getLog(DLAppLocalServiceImpl.class);

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, sourceFileName, "", "", bytes, serviceContext);
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.addFileEntry(userId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        return fileEntry;
    }

    @Deprecated
    public DLFileRank addFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.document.library.file.rank.service.DLFileRankLocalService#addFileRank");
    }

    public FileShortcut addFileShortcut(long userId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long userId, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        Folder folder = localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
        this.dlAppHelperLocalService.addFolder(userId, folder, serviceContext);
        return folder;
    }

    public void deleteAll(long repositoryId) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        this.deleteRepository(localRepository);
    }

    public void deleteAllRepositories(long groupId) throws PortalException {
        LocalRepository groupLocalRepository = this.repositoryProvider.getLocalRepository(groupId);
        this.deleteRepository(groupLocalRepository);
        List localRepositories = this.repositoryProvider.getGroupLocalRepositories(groupId);
        for (LocalRepository localRepository : localRepositories) {
            if (localRepository.getRepositoryId() == groupLocalRepository.getRepositoryId()) continue;
            this.deleteRepository(localRepository);
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        localRepository.deleteFileEntry(fileEntryId);
    }

    @Deprecated
    public void deleteFileRanksByFileEntryId(long fileEntryId) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.document.library.file.rank.service.DLFileRankLocalService#deleteFileRanksByFileEntryId");
    }

    @Deprecated
    public void deleteFileRanksByUserId(long userId) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.document.library.file.rank.service.DLFileRankLocalService#deleteFileRanksByUserId");
    }

    public void deleteFileShortcut(FileShortcut fileShortcut) throws PortalException {
        this.deleteFileShortcut(fileShortcut.getFileShortcutId());
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        localRepository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(toFileEntryId);
        localRepository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        List fileEntries = localRepository.getRepositoryFileEntries(0L, folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        Folder folder = this.getFolder(folderId);
        localRepository.deleteFolder(folderId);
        this.dlAppHelperLocalService.deleteFolder(folder);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        return localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
            LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
            return localRepository.getFileEntry(folderId, title);
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        try {
            LocalRepository localRepository = this.getLocalRepository(groupId);
            return localRepository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
            List repositories = this.repositoryPersistence.findByGroupId(groupId);
            for (Repository repository : repositories) {
                try {
                    LocalRepository localRepository = this.getLocalRepository(repository.getRepositoryId());
                    return localRepository.getFileEntryByUuid(uuid);
                }
                catch (NoSuchFileEntryException nsfee2) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)nsfee2, (Throwable)nsfee2);
                }
            }
            StringBundler msg = new StringBundler(6);
            msg.append("No DLFileEntry exists with the key {");
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchFileEntryException(msg.toString());
        }
    }

    @Deprecated
    public List<DLFileRank> getFileRanks(long repositoryId, long userId) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.document.library.file.rank.service.DLFileRankLocalService#getFileRanks");
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        return localRepository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileVersionLocalRepository(fileVersionId);
        return localRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        return localRepository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        LocalRepository localRepository = this.getLocalRepository(repositoryId);
        return localRepository.getFolder(parentFolderId, name);
    }

    public Folder getMountFolder(long repositoryId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getMountFolder(repositoryId);
        return new LiferayFolder(dlFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(FileEntry.class);
        try {
            LocalRepository fromLocalRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
            LocalRepository toLocalRepository = this.getFolderLocalRepository(newFolderId, serviceContext.getScopeGroupId());
            if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
                FileEntry fileEntry = fromLocalRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
                return fileEntry;
            }
            FileEntry fileEntry = this.moveFileEntry(userId, fileEntryId, newFolderId, fromLocalRepository, toLocalRepository, serviceContext);
            return fileEntry;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(FileEntry.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(Folder.class);
        try {
            Folder folder;
            Folder toFolder;
            LocalRepository fromLocalRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
            LocalRepository toLocalRepository = this.getFolderLocalRepository(parentFolderId, serviceContext.getScopeGroupId());
            if (parentFolderId != 0L && (toFolder = toLocalRepository.getFolder(parentFolderId)).isMountPoint()) {
                toLocalRepository = this.getLocalRepository(toFolder.getRepositoryId());
            }
            if (fromLocalRepository.getRepositoryId() == toLocalRepository.getRepositoryId()) {
                folder = fromLocalRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
                return folder;
            }
            folder = this.moveFolder(userId, folderId, parentFolderId, fromLocalRepository, toLocalRepository, serviceContext);
            return folder;
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(Folder.class);
        }
    }

    public void subscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException {
    }

    public void unsubscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException {
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.dlAppHelperLocalService.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, byte[] bytes, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, null, 0L, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)is);
                    FileEntry fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioe) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioe);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(fileEntryId);
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        this.dlAppHelperLocalService.updateFileEntry(userId, fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    @Deprecated
    public DLFileRank updateFileRank(long repositoryId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.document.library.file.rank.service.DLFileRankLocalService#updateFileRank");
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileShortcutLocalRepository(fileShortcutId);
        return localRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFileEntryLocalRepository(newToFileEntryId);
        localRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    @Deprecated
    public void updateFileShortcuts(long toRepositoryId, long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = this.repositoryProvider.getFolderLocalRepository(folderId);
        Folder folder = localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        if (folderId != 0L) {
            this.dlAppHelperLocalService.updateFolder(serviceContext.getUserId(), folder, serviceContext);
        }
        return folder;
    }

    protected FileEntry copyFileEntry(long userId, LocalRepository toLocalRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        String sourceFileName = DLAppUtil.getSourceFileName(latestFileVersion);
        FileEntry destinationFileEntry = toLocalRepository.addFileEntry(userId, newFolderId, sourceFileName, latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), serviceContext);
        for (int i = fileVersions.size() - 2; i >= 0; --i) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            sourceFileName = DLAppUtil.getSourceFileName(fileVersion);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                destinationFileEntry = toLocalRepository.updateFileEntry(userId, destinationFileEntry.getFileEntryId(), sourceFileName, destinationFileEntry.getMimeType(), destinationFileEntry.getTitle(), destinationFileEntry.getDescription(), "", DLAppUtil.isMajorVersion(fileVersion, previousFileVersion), fileVersion.getContentStream(false), fileVersion.getSize(), serviceContext);
                continue;
            }
            catch (PortalException pe) {
                toLocalRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw pe;
            }
        }
        return destinationFileEntry;
    }

    protected Folder copyFolder(long userId, long folderId, long parentFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = null;
        try {
            Folder folder = fromLocalRepository.getFolder(folderId);
            newFolder = toLocalRepository.addFolder(userId, parentFolderId, folder.getName(), folder.getDescription(), serviceContext);
            this.dlAppHelperLocalService.addFolder(userId, newFolder, serviceContext);
            this.copyFolderDependencies(userId, folder, newFolder, fromLocalRepository, toLocalRepository, serviceContext);
            return newFolder;
        }
        catch (PortalException pe) {
            if (newFolder != null) {
                toLocalRepository.deleteFolder(newFolder.getFolderId());
            }
            throw pe;
        }
    }

    protected void copyFolderDependencies(long userId, Folder sourceFolder, Folder destinationFolder, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        List repositoryEntries = fromLocalRepository.getFoldersAndFileEntriesAndFileShortcuts(sourceFolder.getFolderId(), -1, true, -1, -1, null);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                this.copyFileEntry(userId, toLocalRepository, fileEntry, destinationFolder.getFolderId(), serviceContext);
                continue;
            }
            if (repositoryEntry instanceof FileShortcut) {
                if (!destinationFolder.isSupportsShortcuts()) continue;
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                toLocalRepository.addFileShortcut(userId, destinationFolder.getFolderId(), fileShortcut.getToFileEntryId(), serviceContext);
                continue;
            }
            if (!(repositoryEntry instanceof Folder)) continue;
            Folder currentFolder = (Folder)repositoryEntry;
            Folder newFolder = toLocalRepository.addFolder(userId, destinationFolder.getFolderId(), currentFolder.getName(), currentFolder.getDescription(), serviceContext);
            this.dlAppHelperLocalService.addFolder(userId, newFolder, serviceContext);
            this.copyFolderDependencies(userId, currentFolder, newFolder, fromLocalRepository, toLocalRepository, serviceContext);
        }
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository) throws PortalException {
        try {
            FileEntry fileEntry = fromLocalRepository.getFileEntry(oldFileEntryId);
            fromLocalRepository.deleteFileEntry(oldFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        catch (PortalException pe) {
            FileEntry fileEntry = toLocalRepository.getFileEntry(newFileEntryId);
            toLocalRepository.deleteFileEntry(newFileEntryId);
            this.dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw pe;
        }
    }

    protected void deleteRepository(LocalRepository localRepository) throws PortalException {
        long repositoryId = localRepository.getRepositoryId();
        if (!RepositoryUtil.isExternalRepository(localRepository.getRepositoryId())) {
            this.dlAppHelperLocalService.deleteRepositoryFileEntries(repositoryId);
            localRepository.deleteAll();
        }
        this.repositoryLocalService.deleteRepository(repositoryId);
    }

    protected LocalRepository getFolderLocalRepository(long folderId, long groupId) throws PortalException {
        if (folderId == 0L) {
            return this.getLocalRepository(groupId);
        }
        return this.repositoryProvider.getFolderLocalRepository(folderId);
    }

    protected LocalRepository getLocalRepository(long repositoryId) throws PortalException {
        try {
            return this.repositoryProvider.getLocalRepository(repositoryId);
        }
        catch (InvalidRepositoryIdException irie) {
            StringBundler sb = new StringBundler(3);
            sb.append("No Group exists with the key {repositoryId=");
            sb.append(repositoryId);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString(), (Throwable)irie);
        }
    }

    protected FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        FileEntry sourceFileEntry = fromLocalRepository.getFileEntry(fileEntryId);
        FileEntry destinationFileEntry = this.copyFileEntry(userId, toLocalRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromLocalRepository, toLocalRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolder(long userId, long folderId, long parentFolderId, LocalRepository fromLocalRepository, LocalRepository toLocalRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = this.copyFolder(userId, folderId, parentFolderId, fromLocalRepository, toLocalRepository, serviceContext);
        fromLocalRepository.deleteFolder(folderId);
        return newFolder;
    }
}

