/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagStats;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.asset.service.base.AssetTagStatsLocalServiceBaseImpl;
import java.util.List;

public class AssetTagStatsLocalServiceImpl
extends AssetTagStatsLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetTagStatsLocalServiceImpl.class);

    public AssetTagStats addTagStats(long tagId, long classNameId) {
        AssetTagStats tagStats;
        block3: {
            long tagStatsId = this.counterLocalService.increment();
            tagStats = this.assetTagStatsPersistence.create(tagStatsId);
            tagStats.setTagId(tagId);
            tagStats.setClassNameId(classNameId);
            try {
                this.assetTagStatsPersistence.update((BaseModel)tagStats);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Add failed, fetch {tagId=", String.valueOf(tagId), ", classNameId=", String.valueOf(classNameId), "}"}));
                }
                if ((tagStats = this.assetTagStatsPersistence.fetchByT_C(tagId, classNameId, false)) != null) break block3;
                throw se;
            }
        }
        return tagStats;
    }

    public void deleteTagStats(AssetTagStats tagStats) {
        this.assetTagStatsPersistence.remove((BaseModel)tagStats);
    }

    public void deleteTagStats(long tagStatsId) throws PortalException {
        AssetTagStats tagStats = this.assetTagStatsPersistence.findByPrimaryKey(tagStatsId);
        this.deleteTagStats(tagStats);
    }

    public void deleteTagStatsByClassNameId(long classNameId) {
        List tagStatsList = this.assetTagStatsPersistence.findByClassNameId(classNameId);
        for (AssetTagStats tagStats : tagStatsList) {
            this.deleteTagStats(tagStats);
        }
    }

    public void deleteTagStatsByTagId(long tagId) {
        List tagStatsList = this.assetTagStatsPersistence.findByTagId(tagId);
        for (AssetTagStats tagStats : tagStatsList) {
            this.deleteTagStats(tagStats);
        }
    }

    public List<AssetTagStats> getTagStats(long classNameId, int start, int end) {
        return this.assetTagStatsPersistence.findByClassNameId(classNameId, start, end);
    }

    public AssetTagStats getTagStats(long tagId, long classNameId) {
        AssetTagStats tagStats = this.assetTagStatsPersistence.fetchByT_C(tagId, classNameId);
        if (tagStats == null) {
            tagStats = this.assetTagStatsLocalService.addTagStats(tagId, classNameId);
        }
        return tagStats;
    }

    public AssetTagStats updateTagStats(long tagId, long classNameId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        int assetCount = this.assetTagFinder.countByG_C_N(tag.getGroupId(), classNameId, tag.getName());
        AssetTagStats tagStats = this.getTagStats(tagId, classNameId);
        tagStats.setAssetCount(assetCount);
        this.assetTagStatsPersistence.update((BaseModel)tagStats);
        return tagStats;
    }
}

