/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetCategoryProperty;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.asset.service.base.AssetCategoryPropertyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.util.ArrayList;
import java.util.List;

public class AssetCategoryPropertyServiceImpl
extends AssetCategoryPropertyServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryPropertyServiceImpl.class);

    public AssetCategoryProperty addCategoryProperty(long entryId, String key, String value) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.assetCategoryPropertyLocalService.addCategoryProperty(this.getUserId(), entryId, key, value);
    }

    public void deleteCategoryProperty(long categoryPropertyId) throws PortalException {
        AssetCategoryProperty assetCategoryProperty = this.assetCategoryPropertyLocalService.getAssetCategoryProperty(categoryPropertyId);
        AssetCategoryPermission.check(this.getPermissionChecker(), assetCategoryProperty.getCategoryId(), "UPDATE");
        this.assetCategoryPropertyLocalService.deleteCategoryProperty(categoryPropertyId);
    }

    public List<AssetCategoryProperty> getCategoryProperties(long entryId) {
        block3: {
            try {
                if (AssetCategoryPermission.contains(this.getPermissionChecker(), entryId, "VIEW")) {
                    return this.assetCategoryPropertyLocalService.getCategoryProperties(entryId);
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)("Unable to get asset category property for asset entry " + entryId), (Throwable)pe);
            }
        }
        return new ArrayList<AssetCategoryProperty>();
    }

    public List<AssetCategoryProperty> getCategoryPropertyValues(long companyId, String key) {
        return this.filterAssetCategoryProperties(this.assetCategoryPropertyLocalService.getCategoryPropertyValues(companyId, key));
    }

    public AssetCategoryProperty updateCategoryProperty(long userId, long categoryPropertyId, String key, String value) throws PortalException {
        AssetCategoryProperty assetCategoryProperty = this.assetCategoryPropertyLocalService.getAssetCategoryProperty(categoryPropertyId);
        AssetCategoryPermission.check(this.getPermissionChecker(), assetCategoryProperty.getCategoryId(), "UPDATE");
        return this.assetCategoryPropertyLocalService.updateCategoryProperty(userId, categoryPropertyId, key, value);
    }

    public AssetCategoryProperty updateCategoryProperty(long categoryPropertyId, String key, String value) throws PortalException {
        return this.updateCategoryProperty(0L, categoryPropertyId, key, value);
    }

    protected List<AssetCategoryProperty> filterAssetCategoryProperties(List<AssetCategoryProperty> assetCategoryProperties) {
        ArrayList<AssetCategoryProperty> filteredAssetCategoryProperties = new ArrayList<AssetCategoryProperty>(assetCategoryProperties.size());
        for (AssetCategoryProperty assetCategoryProperty : assetCategoryProperties) {
            try {
                if (!AssetCategoryPermission.contains(this.getPermissionChecker(), assetCategoryProperty.getCategoryId(), "VIEW")) continue;
                filteredAssetCategoryProperties.add(assetCategoryProperty);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return filteredAssetCategoryProperties;
    }
}

