/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;

public class VerifyRole
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyRole.class);

    protected void addViewSiteAdministrationPermission(Role role) throws Exception {
        String name = Group.class.getName();
        Group group = GroupLocalServiceUtil.getGroup((long)role.getCompanyId(), (String)"User Personal Site");
        String primKey = String.valueOf(group.getGroupId());
        if (!ResourcePermissionLocalServiceUtil.hasResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"MANAGE_LAYOUTS") || ResourcePermissionLocalServiceUtil.hasResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"VIEW_SITE_ADMINISTRATION")) {
            return;
        }
        ResourcePermissionLocalServiceUtil.addResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"VIEW_SITE_ADMINISTRATION");
    }

    protected void deleteImplicitAssociations(Role role) throws Exception {
        this.runSQL("delete from UserGroupGroupRole where roleId = " + role.getRoleId());
        this.runSQL("delete from UserGroupRole where roleId = " + role.getRoleId());
    }

    @Override
    protected void doVerify() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            this.verifyRoles(companyId);
        }
    }

    protected void verifyRoles(long companyId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(companyId));){
            block20: {
                block19: {
                    RoleLocalServiceUtil.checkSystemRoles((long)companyId);
                    try {
                        Role organizationUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Organization User");
                        this.deleteImplicitAssociations(organizationUserRole);
                    }
                    catch (NoSuchRoleException nsre) {
                        if (!_log.isDebugEnabled()) break block19;
                        _log.debug((Throwable)nsre);
                    }
                }
                try {
                    Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
                    this.addViewSiteAdministrationPermission(powerUserRole);
                }
                catch (NoSuchRoleException nsre) {
                    if (!_log.isDebugEnabled()) break block20;
                    _log.debug((Throwable)nsre);
                }
            }
            try {
                Role siteMemberRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Site Member");
                this.deleteImplicitAssociations(siteMemberRole);
            }
            catch (NoSuchRoleException nsre) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)nsre);
                }
            }
        }
    }
}

