/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    public void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            ArrayList<VerifyResourcedModelCallable> verifyResourcedModelCallables = new ArrayList<VerifyResourcedModelCallable>(verifiableResourcedModels.length);
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                VerifyResourcedModelCallable verifyResourcedModelCallable = new VerifyResourcedModelCallable(role, verifiableResourcedModel);
                verifyResourcedModelCallables.add(verifyResourcedModelCallable);
            }
            this.doVerify(verifyResourcedModelCallables);
        }
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableResourcedModelsMap = PortalBeanLocatorUtil.locate(VerifiableResourcedModel.class);
        Collection verifiableResourcedModels = verifiableResourcedModelsMap.values();
        this.verify(verifiableResourcedModels.toArray(new VerifiableResourcedModel[verifiableResourcedModels.size()]));
    }

    private String _getVerifyResourcedModelSQL(boolean count, VerifiableResourcedModel verifiableResourcedModel, Role role) {
        StringBundler sb = new StringBundler(28);
        String modelName = verifiableResourcedModel.getModelName();
        if (modelName.equals(User.class.getName())) {
            sb.append("select ");
            if (count) {
                sb.append("count(*)");
            } else {
                sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
                sb.append(", ");
                sb.append(verifiableResourcedModel.getUserIdColumnName());
            }
            sb.append(" from ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(" where companyId = ");
            sb.append(role.getCompanyId());
        } else {
            sb.append("select ");
            if (count) {
                sb.append("count(*)");
            } else {
                sb.append(verifiableResourcedModel.getTableName());
                sb.append(".");
                sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
                sb.append(", ");
                sb.append(verifiableResourcedModel.getTableName());
                sb.append(".");
                sb.append(verifiableResourcedModel.getUserIdColumnName());
                sb.append(", ResourcePermission.resourcePermissionId");
            }
            sb.append(" from ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(" left join ResourcePermission on (ResourcePermission.");
            sb.append("companyId = ");
            sb.append(role.getCompanyId());
            sb.append(" and ResourcePermission.name = '");
            sb.append(verifiableResourcedModel.getModelName());
            sb.append("' and ResourcePermission.scope = ");
            sb.append(4);
            sb.append(" and ResourcePermission.primKey = CAST_TEXT(");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
            sb.append(") and ResourcePermission.roleId = ");
            sb.append(role.getRoleId());
            sb.append(") where ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".companyId = ");
            sb.append(role.getCompanyId());
            sb.append(" and ResourcePermission.resourcePermissionId is NULL");
        }
        return SQLTransformer.transform(sb.toString());
    }

    private void _verifyResourcedModel(long companyId, String modelName, long primKey, Role role, long ownerId, int cur, int total) throws Exception {
        if (_log.isInfoEnabled() && cur % 100 == 0) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Processed ", String.valueOf(cur), " of ", String.valueOf(total), " resource permissions for company ", "= ", String.valueOf(companyId), " and model ", modelName}));
        }
        ResourcePermission resourcePermission = null;
        if (modelName.equals(User.class.getName())) {
            resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
        }
        if (resourcePermission == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"No resource found for {", String.valueOf(companyId), ", ", modelName, ", ", String.valueOf(4), ", ", String.valueOf(primKey), ", ", String.valueOf(role.getRoleId()), "}"}));
            }
            ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)modelName, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
        }
        if (!modelName.equals(User.class.getName())) {
            return;
        }
        User user = UserLocalServiceUtil.getUserById((long)ownerId);
        Contact contact = ContactLocalServiceUtil.fetchContact((long)user.getContactId());
        if (contact != null && ownerId != contact.getUserId() && resourcePermission == null && (resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)modelName, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId())) != null) {
            resourcePermission.setOwnerId(contact.getUserId());
            ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
        }
    }

    private void _verifyResourcedModel(Role role, VerifiableResourcedModel verifiableResourcedModel) throws Exception {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement ps2;
        Throwable throwable3;
        Connection con;
        int total = 0;
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());){
            con = DataAccess.getUpgradeOptimizedConnection();
            throwable3 = null;
            try {
                ps2 = con.prepareStatement(this._getVerifyResourcedModelSQL(true, verifiableResourcedModel, role));
                throwable2 = null;
                try {
                    rs2 = ps2.executeQuery();
                    throwable = null;
                    try {
                        if (rs2.next()) {
                            total = rs2.getInt(1);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
                finally {
                    if (ps2 != null) {
                        if (throwable2 != null) {
                            try {
                                ps2.close();
                            }
                            catch (Throwable rs2) {
                                throwable2.addSuppressed(rs2);
                            }
                        } else {
                            ps2.close();
                        }
                    }
                }
            }
            catch (Throwable ps2) {
                throwable3 = ps2;
                throw ps2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable ps2) {
                            throwable3.addSuppressed(ps2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());
        var5_5 = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            throwable3 = null;
            try {
                ps2 = con.prepareStatement(this._getVerifyResourcedModelSQL(false, verifiableResourcedModel, role));
                throwable2 = null;
                try {
                    rs2 = ps2.executeQuery();
                    throwable = null;
                    try {
                        int i = 1;
                        while (rs2.next()) {
                            long primKey = rs2.getLong(verifiableResourcedModel.getPrimaryKeyColumnName());
                            long userId = rs2.getLong(verifiableResourcedModel.getUserIdColumnName());
                            this._verifyResourcedModel(role.getCompanyId(), verifiableResourcedModel.getModelName(), primKey, role, userId, i, total);
                            ++i;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (ps2 != null) {
                        if (throwable2 != null) {
                            try {
                                ps2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            ps2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Throwable throwable12) {
            var5_5 = throwable12;
            throw throwable12;
        }
        finally {
            if (loggingTimer != null) {
                if (var5_5 != null) {
                    try {
                        loggingTimer.close();
                    }
                    catch (Throwable throwable13) {
                        var5_5.addSuppressed(throwable13);
                    }
                } else {
                    loggingTimer.close();
                }
            }
        }
    }

    private class VerifyResourcedModelCallable
    implements Callable<Void> {
        private final Role _role;
        private final VerifiableResourcedModel _verifiableResourcedModel;

        @Override
        public Void call() throws Exception {
            VerifyResourcePermissions.this._verifyResourcedModel(this._role, this._verifiableResourcedModel);
            return null;
        }

        private VerifyResourcedModelCallable(Role role, VerifiableResourcedModel verifiableResourcedModel) {
            this._role = role;
            this._verifiableResourcedModel = verifiableResourcedModel;
        }
    }
}

