/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class VerifyMySQL
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyMySQL.class);

    @Override
    protected void doVerify() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MARIADB || db.getDBType() == DBType.MYSQL) {
            this.verifyTableEngine();
            this.verifyDatetimePrecision();
        }
    }

    protected String getActualColumnType(Statement statement, String tableName, String columnName) throws SQLException {
        StringBundler sb = new StringBundler(5);
        sb.append("show columns from ");
        sb.append(tableName);
        sb.append(" like \"");
        sb.append(columnName);
        sb.append("\"");
        try (ResultSet rs = statement.executeQuery(sb.toString());){
            if (!rs.next()) {
                throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Table ", tableName, " does not have column ", columnName}));
            }
            String string = rs.getString("Type");
            return string;
        }
    }

    protected void verifyDatetimePrecision() throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs = databaseMetaData.getTables(null, null, null, null);){
            while (rs.next()) {
                this.verifyDatetimePrecisionForTable(databaseMetaData, statement, rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
            }
        }
    }

    protected void verifyDatetimePrecisionForTable(DatabaseMetaData databaseMetaData, Statement statement, String catalog, String schemaPattern, String tableName) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(catalog, schemaPattern, tableName, null);){
            while (rs.next()) {
                String columnName;
                String actualColumnType;
                if (93 != rs.getInt("DATA_TYPE") || (actualColumnType = this.getActualColumnType(statement, tableName, columnName = rs.getString("COLUMN_NAME"))).equals("datetime(6)")) continue;
                StringBundler sb = new StringBundler(5);
                sb.append("ALTER TABLE ");
                sb.append(tableName);
                sb.append(" MODIFY ");
                sb.append(columnName);
                sb.append(" datetime(6)");
                String sql = sb.toString();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Updating table ", tableName, " column ", columnName, " to datetime(6)"}));
                }
                statement.executeUpdate(sql);
            }
        }
    }

    protected void verifyTableEngine() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery("show table status");){
            while (rs.next()) {
                String tableName = rs.getString("Name");
                if (!this.isPortalTableName(tableName)) continue;
                String engine = GetterUtil.getString((String)rs.getString("Engine"));
                String comment = GetterUtil.getString((String)rs.getString("Comment"));
                if (StringUtil.equalsIgnoreCase((String)comment, (String)"VIEW") || StringUtil.equalsIgnoreCase((String)engine, (String)PropsValues.DATABASE_MYSQL_ENGINE)) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Updating table ", tableName, " to use engine ", PropsValues.DATABASE_MYSQL_ENGINE}));
                }
                statement.executeUpdate(StringBundler.concat((String[])new String[]{"alter table ", tableName, " engine ", PropsValues.DATABASE_MYSQL_ENGINE}));
            }
        }
    }
}

