/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class VerifyLayout
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyLayout.class);

    protected void deleteLinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(3);
            sb.append("delete from Layout where layoutPrototypeUuid != '' ");
            sb.append("and layoutPrototypeUuid not in (select uuid_ from ");
            sb.append("LayoutPrototype) and layoutPrototypeLinkEnabled = TRUE");
            this.runSQL(sb.toString());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteLinkedOrphanedLayouts();
        this.updateUnlinkedOrphanedLayouts();
        this.verifyFriendlyURL();
        this.verifyLayoutIdFriendlyURL();
        this.verifyLayoutPrototypeLinkEnabled();
        this.verifyUuid();
    }

    protected List<Layout> getInvalidLayoutIdFriendlyURLLayouts() throws Exception {
        final ArrayList<Layout> layouts = new ArrayList<Layout>();
        ActionableDynamicQuery actionableDynamicQuery = LayoutLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Layout>(){

            public void performAction(Layout layout) {
                String friendlyURL = layout.getFriendlyURL();
                if (Validator.isNumber((String)(friendlyURL = friendlyURL.substring(1))) && !friendlyURL.equals(String.valueOf(layout.getLayoutId()))) {
                    layouts.add(layout);
                }
            }
        });
        actionableDynamicQuery.performActions();
        return layouts;
    }

    protected void updateUnlinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("update Layout set layoutPrototypeUuid = null where ");
            sb.append("layoutPrototypeUuid != '' and layoutPrototypeUuid not ");
            sb.append("in (select uuid_ from LayoutPrototype) and ");
            sb.append("layoutPrototypeLinkEnabled = FALSE");
            this.runSQL(sb.toString());
        }
    }

    protected void verifyFriendlyURL() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List layouts = LayoutLocalServiceUtil.getNullFriendlyURLLayouts();
            for (Layout layout : layouts) {
                List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
                for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                    String friendlyURL = "/" + layout.getLayoutId();
                    LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getUserId(), (long)layout.getPlid(), (String)friendlyURL, (String)layoutFriendlyURL.getLanguageId());
                }
            }
            ActionableDynamicQuery actionableDynamicQuery = LayoutFriendlyURLLocalServiceUtil.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    DynamicQuery layoutDynamicQuery = LayoutLocalServiceUtil.dynamicQuery();
                    Projection projection = ProjectionFactoryUtil.property((String)"plid");
                    layoutDynamicQuery.setProjection(projection);
                    Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
                    dynamicQuery.add(plidProperty.notIn(layoutDynamicQuery));
                }
            });
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutFriendlyURL>(){

                public void performAction(LayoutFriendlyURL layoutFriendlyURL) {
                    LayoutFriendlyURLLocalServiceUtil.deleteLayoutFriendlyURL((LayoutFriendlyURL)layoutFriendlyURL);
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyLayoutIdFriendlyURL() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List<Layout> layouts;
            block9: while (!(layouts = this.getInvalidLayoutIdFriendlyURLLayouts()).isEmpty()) {
                Iterator<Layout> iterator = layouts.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block9;
                    Layout layout = iterator.next();
                    if (!this.verifyLayoutIdFriendlyURL(layout)) continue;
                }
                break;
            }
        }
    }

    protected boolean verifyLayoutIdFriendlyURL(Layout layout) throws Exception {
        String oldFriendlyURL = layout.getFriendlyURL();
        String newFriendlyURL = "/" + layout.getLayoutId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Updating layout ", String.valueOf(layout.getPlid()), " from friendly URL ", oldFriendlyURL, " to friendly URL ", newFriendlyURL}));
        }
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            if (!oldFriendlyURL.equals(layoutFriendlyURL.getFriendlyURL())) continue;
            try {
                layout = LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getUserId(), (long)layout.getPlid(), (String)newFriendlyURL, (String)layoutFriendlyURL.getLanguageId());
            }
            catch (LayoutFriendlyURLException lfurle) {
                int type = lfurle.getType();
                if (type == 6) continue;
                throw lfurle;
            }
        }
        try {
            Layout duplicateLayout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)newFriendlyURL);
            if (duplicateLayout != null) {
                throw new LayoutFriendlyURLException(6);
            }
            LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getUserId(), (long)layout.getPlid(), (String)newFriendlyURL, (String)LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        }
        catch (LayoutFriendlyURLException lfurle) {
            int type = lfurle.getType();
            if (type == 6) {
                return true;
            }
            throw lfurle;
        }
        return false;
    }

    protected void verifyLayoutPrototypeLinkEnabled() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update Layout set layoutPrototypeLinkEnabled = [$FALSE$] where type_ = 'link_to_layout' and layoutPrototypeLinkEnabled = [$TRUE$]");
        }
    }

    protected void verifyUuid() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update Layout set uuid_ = sourcePrototypeLayoutUuid where sourcePrototypeLayoutUuid != '' and uuid_ != sourcePrototypeLayoutUuid");
        }
    }

    protected void verifyUuid(String tableName) throws Exception {
        StringBundler sb = new StringBundler(12);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set layoutUuid = (select distinct ");
        sb.append("sourcePrototypeLayoutUuid from Layout where Layout.uuid_ ");
        sb.append("= ");
        sb.append(tableName);
        sb.append(".layoutUuid) where exists (select 1 from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid and Layout.uuid_ != ");
        sb.append("Layout.sourcePrototypeLayoutUuid and ");
        sb.append("Layout.sourcePrototypeLayoutUuid != '')");
        this.runSQL(sb.toString());
    }
}

