/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.document.library.kernel.exception.ImageSizeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.petra.encryptor.Encryptor;
import com.liferay.portal.comment.action.EditDiscussionStrutsAction;
import com.liferay.portal.comment.action.GetCommentsStrutsAction;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RSSFeedException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AlwaysAllowDoAsUser;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.DeterminateKeyGenerator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InheritableMap;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.kernel.util.PortalPortEventListener;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.RemotePreference;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.impl.CookieRemotePreference;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.jaas.JAASHelper;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.upload.UploadPortletRequestImpl;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.StateAwareResponseImpl;
import com.liferay.portlet.admin.util.OmniadminUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.util.JS;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@DoPrivileged
public class PortalImpl
implements Portal {
    private static final Log _logWebServerServlet = LogFactoryUtil.getLog(WebServerServlet.class);
    private static final String _J_SECURITY_CHECK = "j_security_check";
    private static final String _JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR = "/-/";
    private static final String _LOCALHOST = "localhost";
    private static final Locale _NULL_LOCALE;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING;
    private static final Log _log;
    private static final Map<Long, String> _cdnHostHttpMap;
    private static final Map<Long, String> _cdnHostHttpsMap;
    private static final MethodHandler _resetCDNHostsMethodHandler;
    private static final Date _upTime;
    private final String[] _allSystemGroups;
    private final String[] _allSystemOrganizationRoles;
    private final String[] _allSystemRoles;
    private final String[] _allSystemSiteRoles;
    private final List<AlwaysAllowDoAsUser> _alwaysAllowDoAsUsers = new ArrayList<AlwaysAllowDoAsUser>();
    private final Pattern _bannedResourceIdPattern = Pattern.compile(PropsValues.PORTLET_RESOURCE_ID_BANNED_PATHS_REGEXP, 2);
    private final Set<String> _computerAddresses = new HashSet<String>();
    private final String _computerName;
    private String[] _customSqlKeys;
    private String[] _customSqlValues;
    private final EditDiscussionStrutsAction _editDiscussionStrutsAction = new EditDiscussionStrutsAction();
    private final GetCommentsStrutsAction _getCommentsStrutsAction = new GetCommentsStrutsAction();
    private final String _pathContext;
    private final String _pathFriendlyURLPrivateGroup;
    private final String _pathFriendlyURLPrivateUser;
    private final String _pathFriendlyURLPublic;
    private final String _pathImage;
    private final String _pathMain;
    private final String _pathModule;
    private final String _pathProxy;
    private final Map<String, Long> _plidToPortletIdMap = new ConcurrentHashMap<String, Long>();
    private final Set<PortalInetSocketAddressEventListener> _portalInetSocketAddressEventListeners = new CopyOnWriteArraySet<PortalInetSocketAddressEventListener>();
    private final AtomicReference<InetSocketAddress> _portalLocalInetSocketAddress = new AtomicReference();
    @Deprecated
    private final AtomicInteger _portalPort = new AtomicInteger(-1);
    @Deprecated
    private final List<PortalPortEventListener> _portalPortEventListeners = new ArrayList<PortalPortEventListener>();
    private final AtomicReference<InetSocketAddress> _portalServerInetSocketAddress = new AtomicReference();
    private final Set<String> _reservedParams;
    private final AtomicReference<InetSocketAddress> _securePortalLocalInetSocketAddress = new AtomicReference();
    @Deprecated
    private final AtomicInteger _securePortalPort = new AtomicInteger(-1);
    private final AtomicReference<InetSocketAddress> _securePortalServerInetSocketAddress = new AtomicReference();
    private final String _servletContextName;
    private final String[] _sortedSystemGroups;
    private final String[] _sortedSystemOrganizationRoles;
    private final String[] _sortedSystemRoles;
    private final String[] _sortedSystemSiteRoles;
    private final boolean _validPortalDomainCheckDisabled;

    public PortalImpl() {
        String computerName = System.getProperty("env.COMPUTERNAME");
        if (Validator.isNull((String)computerName)) {
            computerName = System.getProperty("env.HOST");
        }
        if (Validator.isNull((String)computerName)) {
            computerName = System.getProperty("env.HOSTNAME");
        }
        if (Validator.isNull((String)computerName)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                computerName = inetAddress.getHostName();
            }
            catch (UnknownHostException inetAddress) {
                // empty catch block
            }
        }
        this._computerName = computerName;
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : inetAddresses) {
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    this._computerAddresses.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to determine server's IP addresses");
            _log.error((Object)e, (Throwable)e);
        }
        this._pathProxy = PropsValues.PORTAL_PROXY_PATH;
        this._pathContext = this._pathProxy.concat(this.getContextPath(PortalContextLoaderListener.getPortalServletContextPath()));
        this._pathFriendlyURLPrivateGroup = this._pathContext + _PRIVATE_GROUP_SERVLET_MAPPING;
        this._pathFriendlyURLPrivateUser = this._pathContext + _PRIVATE_USER_SERVLET_MAPPING;
        this._pathFriendlyURLPublic = this._pathContext + _PUBLIC_GROUP_SERVLET_MAPPING;
        this._pathImage = this._pathContext + "/image";
        this._pathMain = this._pathContext + "/c";
        this._pathModule = this._pathContext + "/o";
        Object[] customSystemGroups = PropsUtil.getArray("system.groups");
        this._allSystemGroups = ArrayUtil.isEmpty((Object[])customSystemGroups) ? GroupConstants.SYSTEM_GROUPS : (String[])ArrayUtil.append((Object[])GroupConstants.SYSTEM_GROUPS, (Object[])customSystemGroups);
        this._sortedSystemGroups = new String[this._allSystemGroups.length];
        System.arraycopy(this._allSystemGroups, 0, this._sortedSystemGroups, 0, this._allSystemGroups.length);
        Arrays.sort(this._sortedSystemGroups, new StringComparator());
        Object[] customSystemRoles = PropsUtil.getArray("system.roles");
        this._allSystemRoles = ArrayUtil.isEmpty((Object[])customSystemRoles) ? RoleConstants.SYSTEM_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ROLES, (Object[])customSystemRoles);
        this._sortedSystemRoles = new String[this._allSystemRoles.length];
        System.arraycopy(this._allSystemRoles, 0, this._sortedSystemRoles, 0, this._allSystemRoles.length);
        Arrays.sort(this._sortedSystemRoles, new StringComparator());
        Object[] customSystemOrganizationRoles = PropsUtil.getArray("system.organization.roles");
        this._allSystemOrganizationRoles = ArrayUtil.isEmpty((Object[])customSystemOrganizationRoles) ? RoleConstants.SYSTEM_ORGANIZATION_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ORGANIZATION_ROLES, (Object[])customSystemOrganizationRoles);
        this._sortedSystemOrganizationRoles = new String[this._allSystemOrganizationRoles.length];
        System.arraycopy(this._allSystemOrganizationRoles, 0, this._sortedSystemOrganizationRoles, 0, this._allSystemOrganizationRoles.length);
        Arrays.sort(this._sortedSystemOrganizationRoles, new StringComparator());
        Object[] customSystemSiteRoles = PropsUtil.getArray("system.site.roles");
        this._allSystemSiteRoles = ArrayUtil.isEmpty((Object[])customSystemSiteRoles) ? RoleConstants.SYSTEM_SITE_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_SITE_ROLES, (Object[])customSystemSiteRoles);
        this._sortedSystemSiteRoles = new String[this._allSystemSiteRoles.length];
        System.arraycopy(this._allSystemSiteRoles, 0, this._sortedSystemSiteRoles, 0, this._allSystemSiteRoles.length);
        Arrays.sort(this._sortedSystemSiteRoles, new StringComparator());
        this._reservedParams = new HashSet<String>();
        this._reservedParams.add("p_auth");
        this._reservedParams.add("p_auth_secret");
        this._reservedParams.add("p_l_id");
        this._reservedParams.add("p_l_reset");
        this._reservedParams.add("p_p_auth");
        this._reservedParams.add("p_p_id");
        this._reservedParams.add("p_p_i_id");
        this._reservedParams.add("p_p_lifecycle");
        this._reservedParams.add("p_p_url_type");
        this._reservedParams.add("p_p_state");
        this._reservedParams.add("p_p_state_rcv");
        this._reservedParams.add("p_p_mode");
        this._reservedParams.add("p_p_resource_id");
        this._reservedParams.add("p_p_cacheability");
        this._reservedParams.add("p_p_width");
        this._reservedParams.add("p_p_col_id");
        this._reservedParams.add("p_p_col_pos");
        this._reservedParams.add("p_p_col_count");
        this._reservedParams.add("p_p_boundary");
        this._reservedParams.add("p_p_decorate");
        this._reservedParams.add("p_p_static");
        this._reservedParams.add("p_p_isolated");
        this._reservedParams.add("p_t_lifecycle");
        this._reservedParams.add("p_v_l_s_g_id");
        this._reservedParams.add("p_f_id");
        this._reservedParams.add("p_j_a_id");
        this._reservedParams.add("saveLastPath");
        this._reservedParams.add("scroll");
        this._reservedParams.add("switchGroup");
        this._servletContextName = PortalContextLoaderListener.getPortalServletContextName();
        this._validPortalDomainCheckDisabled = ArrayUtil.isEmpty((Object[])PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) || ArrayUtil.contains((Object[])PropsValues.VIRTUAL_HOSTS_VALID_HOSTS, (Object)"*");
        try {
            Registry registry = RegistryUtil.getRegistry();
            ServiceTracker alwaysAllowDoAsUserServiceTracker = registry.trackServices(AlwaysAllowDoAsUser.class, (ServiceTrackerCustomizer)new AlwaysAllowDoAsUserServiceTrackerCustomizer());
            alwaysAllowDoAsUserServiceTracker.open();
            ServiceTracker portalInetSocketAddressEventListenerServiceTracker = registry.trackServices(PortalInetSocketAddressEventListener.class, (ServiceTrackerCustomizer)new PortalInetSocketAddressEventListenerServiceTrackerCustomizer());
            portalInetSocketAddressEventListenerServiceTracker.open();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addPageDescription(String description, HttpServletRequest request) {
        ListMergeable descriptionListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION");
        if (descriptionListMergeable == null) {
            descriptionListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
        }
        descriptionListMergeable.add((Object)description);
    }

    public void addPageKeywords(String keywords, HttpServletRequest request) {
        String[] keywordsArray;
        ListMergeable keywordsListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        if (keywordsListMergeable == null) {
            keywordsListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_KEYWORDS", (Object)keywordsListMergeable);
        }
        for (String keyword : keywordsArray = StringUtil.split((String)keywords)) {
            if (keywordsListMergeable.contains((Object)StringUtil.toLowerCase((String)keyword))) continue;
            keywordsListMergeable.add((Object)StringUtil.toLowerCase((String)keyword));
        }
    }

    public void addPageSubtitle(String subtitle, HttpServletRequest request) {
        ListMergeable subtitleListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_SUBTITLE");
        if (subtitleListMergeable == null) {
            subtitleListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
        }
        subtitleListMergeable.add((Object)subtitle);
    }

    public void addPageTitle(String title, HttpServletRequest request) {
        ListMergeable titleListMergeable = (ListMergeable)request.getAttribute("LIFERAY_SHARED_PAGE_TITLE");
        if (titleListMergeable == null) {
            titleListMergeable = new ListMergeable();
            request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
        }
        titleListMergeable.add((Object)title);
    }

    public boolean addPortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.add(portalInetSocketAddressEventListener);
    }

    @Deprecated
    public void addPortalPortEventListener(PortalPortEventListener portalPortEventListener) {
        if (!this._portalPortEventListeners.contains(portalPortEventListener)) {
            this._portalPortEventListeners.add(portalPortEventListener);
        }
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest request, String title, String url) {
        this.addPortletBreadcrumbEntry(request, title, url, null);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest request, String title, String url, Map<String, Object> data) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        boolean portletBreadcrumbEntry = false;
        if (Validator.isNotNull((String)portletDisplay.getId()) && !portletDisplay.isFocused()) {
            portletBreadcrumbEntry = true;
        }
        this.addPortletBreadcrumbEntry(request, title, url, null, portletBreadcrumbEntry);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest request, String title, String url, Map<String, Object> data, boolean portletBreadcrumbEntry) {
        ArrayList<BreadcrumbEntry> breadcrumbEntries;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        if (portletBreadcrumbEntry) {
            name = name + "_" + portletDisplay.getId();
        }
        if ((breadcrumbEntries = (ArrayList<BreadcrumbEntry>)request.getAttribute(name)) == null) {
            breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
            request.setAttribute(name, breadcrumbEntries);
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setData(data);
        breadcrumbEntry.setTitle(title);
        breadcrumbEntry.setURL(url);
        breadcrumbEntries.add(breadcrumbEntry);
    }

    public void addPortletDefaultResource(HttpServletRequest request, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource((String)portlet.getRootPortletId());
        if (Validator.isNull((String)name)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long groupId = 0L;
        groupId = layout.isTypeControlPanel() ? themeDisplay.getScopeGroupId() : this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(themeDisplay.getCompanyId(), groupId, name);
    }

    public void addPortletDefaultResource(long companyId, Layout layout, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource((String)portlet.getRootPortletId());
        if (Validator.isNull((String)name)) {
            return;
        }
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(companyId, groupId, name);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, Layout layout, String url, boolean doAsUser) {
        return this.addPreservedParameters(themeDisplay, url, layout.isTypeControlPanel(), doAsUser);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, String url) {
        return this.addPreservedParameters(themeDisplay, themeDisplay.getLayout(), url, true);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, String url, boolean typeControlPanel, boolean doAsUser) {
        if (doAsUser) {
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                url = HttpUtil.setParameter((String)url, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                url = HttpUtil.setParameter((String)url, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
            }
        }
        if (typeControlPanel) {
            if (Validator.isNotNull((String)themeDisplay.getPpid())) {
                url = HttpUtil.setParameter((String)url, (String)"p_p_id", (String)themeDisplay.getPpid());
            }
            if (themeDisplay.getDoAsGroupId() > 0L) {
                url = HttpUtil.setParameter((String)url, (String)"doAsGroupId", (long)themeDisplay.getDoAsGroupId());
            }
            if (themeDisplay.getRefererGroupId() != 0L) {
                url = HttpUtil.setParameter((String)url, (String)"refererGroupId", (long)themeDisplay.getRefererGroupId());
            }
            if (themeDisplay.getRefererPlid() != 0L) {
                url = HttpUtil.setParameter((String)url, (String)"refererPlid", (long)themeDisplay.getRefererPlid());
            }
        }
        return url;
    }

    public void addUserLocaleOptionsMessage(HttpServletRequest request) {
        boolean ignoreUserLocaleOptions = GetterUtil.getBoolean((String)SessionClicks.get((HttpSession)request.getSession(), (String)"ignoreUserLocaleOptions", (String)Boolean.FALSE.toString()));
        if (ignoreUserLocaleOptions) {
            return;
        }
        boolean showUserLocaleOptionsMessage = ParamUtil.getBoolean((HttpServletRequest)request, (String)"showUserLocaleOptionsMessage", (boolean)true);
        if (!showUserLocaleOptionsMessage) {
            return;
        }
        PortalMessages.add((HttpServletRequest)request, (String)"animation", (Object)false);
        PortalMessages.add((HttpServletRequest)request, (String)"jspPath", (Object)"/html/common/themes/user_locale_options.jsp");
        PortalMessages.add((HttpServletRequest)request, (String)"timeout", (Object)-1);
    }

    public void clearRequestParameters(RenderRequest renderRequest) {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)renderRequest;
        if (renderRequestImpl.isTriggeredByActionURL()) {
            renderRequestImpl.clearRenderParameters();
        }
    }

    public void copyRequestParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        StateAwareResponseImpl stateAwareResponseImpl;
        if (actionResponse instanceof StateAwareResponseImpl && (stateAwareResponseImpl = (StateAwareResponseImpl)actionResponse).getRedirectLocation() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Cannot copy parameters on a redirected StateAwareResponseImpl");
            }
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this.getLiferayPortletResponse((PortletResponse)actionResponse);
        StateAwareResponse stateAwareResponse = (StateAwareResponse)liferayPortletResponse;
        Map renderParameters = stateAwareResponse.getRenderParameterMap();
        actionResponse.setRenderParameter("p_p_lifecycle", "1");
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = actionRequest.getParameterValues(param);
            if (renderParameters.get(actionResponse.getNamespace() + param) != null) continue;
            actionResponse.setRenderParameter(param, values);
        }
    }

    public String escapeRedirect(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        String domain = HttpUtil.getDomain((String)url);
        if (domain.isEmpty()) {
            return url;
        }
        int pos = domain.indexOf(58);
        if (pos != -1) {
            domain = domain.substring(0, pos);
        }
        if (!this._validPortalDomainCheckDisabled && this.isValidPortalDomain(domain)) {
            return url;
        }
        String securityMode = PropsValues.REDIRECT_URL_SECURITY_MODE;
        if (securityMode.equals("domain")) {
            String[] allowedDomains = PropsValues.REDIRECT_URL_DOMAINS_ALLOWED;
            if (allowedDomains.length == 0) {
                return url;
            }
            for (String allowedDomain : allowedDomains) {
                if (allowedDomain.startsWith("*.") && (allowedDomain.regionMatches(1, domain, domain.length() - (allowedDomain.length() - 1), allowedDomain.length() - 1) || allowedDomain.regionMatches(2, domain, 0, domain.length()))) {
                    return url;
                }
                if (!allowedDomain.equals(domain)) continue;
                return url;
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Redirect URL " + url + " is not allowed"));
            }
            url = null;
        } else if (securityMode.equals("ip")) {
            block16: {
                String[] allowedIps = PropsValues.REDIRECT_URL_IPS_ALLOWED;
                if (allowedIps.length == 0) {
                    return url;
                }
                try {
                    InetAddress inetAddress = InetAddress.getByName(domain);
                    String hostAddress = inetAddress.getHostAddress();
                    boolean serverIpIsHostAddress = this._computerAddresses.contains(hostAddress);
                    for (String ip : allowedIps) {
                        if ((!serverIpIsHostAddress || !ip.equals("SERVER_IP")) && !ip.equals(hostAddress)) continue;
                        return url;
                    }
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Redirect URL " + url + " is not allowed"));
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!_log.isDebugEnabled()) break block16;
                    _log.debug((Object)("Unable to determine IP for redirect URL " + url));
                }
            }
            url = null;
        }
        return url;
    }

    public String generateRandomKey(HttpServletRequest request, String input) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isAjax() || themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
            return StringUtil.randomId();
        }
        StringBundler sb = new StringBundler(5);
        sb.append(DeterminateKeyGenerator.generate((String)input));
        sb.append("_");
        sb.append(request.getAttribute("RENDER_PORTLET_COLUMN_ID"));
        sb.append("_");
        sb.append(request.getAttribute("RENDER_PORTLET_COLUMN_POS"));
        return JS.getSafeName((String)sb.toString());
    }

    public String getAbsoluteURL(HttpServletRequest request, String url) {
        String portalURL = this.getPortalURL(request);
        if (url.charAt(0) == '/' && Validator.isNotNull((String)portalURL)) {
            url = portalURL.concat(url);
        }
        if (!CookieKeys.hasSessionId((HttpServletRequest)request) && url.startsWith(portalURL)) {
            url = this.getURLWithSessionId(url, request.getSession().getId());
        }
        return url;
    }

    public LayoutQueryStringComposite getActualLayoutQueryStringComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        List layouts;
        Layout layout = null;
        String layoutQueryStringCompositeFriendlyURL = friendlyURL;
        String queryString = "";
        if (Validator.isNull((String)friendlyURL)) {
            layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
            if (layouts.isEmpty()) {
                throw new NoSuchLayoutException(StringBundler.concat((String[])new String[]{"{groupId=", String.valueOf(groupId), ", privateLayout=", String.valueOf(privateLayout), "}"}));
            }
        } else {
            return this.getPortletFriendlyURLMapperLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        }
        layout = (Layout)layouts.get(0);
        return new LayoutQueryStringComposite(layout, layoutQueryStringCompositeFriendlyURL, queryString);
    }

    public String getActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String actualURL = null;
        if (friendlyURL != null) {
            HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(request);
            Collection friendlyURLResolvers = FriendlyURLResolverRegistryUtil.getFriendlyURLResolversAsCollection();
            for (FriendlyURLResolver friendlyURLResolver : friendlyURLResolvers) {
                if (!friendlyURL.startsWith(friendlyURLResolver.getURLSeparator())) continue;
                try {
                    actualURL = friendlyURLResolver.getActualURL(companyId, groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception e) {
                    throw new NoSuchLayoutException((Throwable)e);
                }
            }
        }
        if (actualURL == null) {
            actualURL = this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
        }
        return actualURL;
    }

    public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
        Map<Locale, String> alternateURLs = this._getAlternateURLs(canonicalURL, themeDisplay, layout, Collections.singleton(locale));
        return alternateURLs.get(locale);
    }

    public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        Set availableLocales = LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId());
        return this._getAlternateURLs(canonicalURL, themeDisplay, layout, availableLocales);
    }

    public long[] getAncestorSiteGroupIds(long groupId) {
        int i = 0;
        Set<Group> groups = this.doGetAncestorSiteGroups(groupId, false);
        long[] groupIds = new long[groups.size()];
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    public BaseModel<?> getBaseModel(ResourcePermission resourcePermission) throws PortalException {
        String modelName = resourcePermission.getName();
        String primKey = resourcePermission.getPrimKey();
        return this.getBaseModel(modelName, primKey);
    }

    public BaseModel<?> getBaseModel(String modelName, String primKey) throws PortalException {
        if (!modelName.contains(".model.")) {
            return null;
        }
        Object[] parts = StringUtil.split((String)modelName, (char)'.');
        if (parts.length <= 2 || !parts[parts.length - 2].equals("model")) {
            return null;
        }
        parts[parts.length - 2] = "service";
        String serviceName = StringUtil.merge((Object[])parts, (String)".") + "LocalServiceUtil";
        String methodName = "get" + (String)parts[parts.length - 1];
        Method method = null;
        try {
            Class<?> serviceUtil = Class.forName(serviceName);
            if (Validator.isNumber((String)primKey)) {
                method = serviceUtil.getMethod(methodName, Long.TYPE);
                return (BaseModel)method.invoke(null, Long.valueOf(primKey));
            }
            method = serviceUtil.getMethod(methodName, String.class);
            return (BaseModel)method.invoke(null, primKey);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof PortalException) {
                throw (PortalException)cause;
            }
            if (cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            throw new SystemException(cause);
        }
    }

    @Deprecated
    public long getBasicAuthUserId(HttpServletRequest request) throws PortalException {
        long companyId = PortalInstances.getCompanyId(request);
        return this.getBasicAuthUserId(request, companyId);
    }

    @Deprecated
    public long getBasicAuthUserId(HttpServletRequest request, long companyId) throws PortalException {
        return HttpAuthManagerUtil.getBasicUserId((HttpServletRequest)request);
    }

    public List<Group> getBrowsableScopeGroups(long userId, long companyId, long groupId, String portletId) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
        params.put("usersGroups", userId);
        groups.addAll(0, GroupLocalServiceUtil.search((long)companyId, null, null, params, (int)-1, (int)-1));
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        for (Organization organization : organizations) {
            groups.add(0, organization.getGroup());
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            groups.add(0, GroupLocalServiceUtil.getUserGroup((long)companyId, (long)userId));
        }
        groups.addAll(0, this.getCurrentAndAncestorSiteGroups(groupId));
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : ListUtil.unique(groups)) {
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                if (stagingGroup.getGroupId() != groupId || !group.isStagedPortlet(portletId) || group.isStagedRemotely() || !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet")) continue;
                filteredGroups.add(stagingGroup);
                continue;
            }
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, false);
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL) throws PortalException {
        String groupFriendlyURL = "";
        String parametersURL = "";
        if (Validator.isNotNull((String)completeURL)) {
            int pos = (completeURL = this.removeRedirectParameter(completeURL)).indexOf(_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR);
            if (pos == -1) {
                pos = completeURL.indexOf("?");
            }
            groupFriendlyURL = completeURL;
            if (pos != -1) {
                groupFriendlyURL = completeURL.substring(0, pos);
                parametersURL = completeURL.substring(pos);
            }
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String canonicalLayoutFriendlyURL = "";
        String defaultLayoutFriendlyURL = null;
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        defaultLayoutFriendlyURL = siteDefaultLocale.equals(themeDisplay.getLocale()) ? themeDisplay.getLayoutFriendlyURL(layout) : layout.getFriendlyURL(this.getSiteDefaultLocale(layout.getGroupId()));
        if ((!layout.isFirstParent() || Validator.isNotNull((String)parametersURL)) && (groupFriendlyURL.contains(themeDisplay.getLayoutFriendlyURL(layout)) || groupFriendlyURL.contains("/" + layout.getLayoutId()))) {
            canonicalLayoutFriendlyURL = defaultLayoutFriendlyURL;
        } else if (forceLayoutFriendlyURL) {
            canonicalLayoutFriendlyURL = defaultLayoutFriendlyURL;
        }
        groupFriendlyURL = this.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay, true, layout.isTypeControlPanel());
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            StringBundler sb = new StringBundler(4);
            sb.append(groupFriendlyURL);
            sb.append(this._buildI18NPath(siteDefaultLocale.getLanguage(), siteDefaultLocale));
            sb.append(canonicalLayoutFriendlyURL);
            sb.append(parametersURL);
            return sb.toString();
        }
        return groupFriendlyURL.concat(canonicalLayoutFriendlyURL).concat(parametersURL);
    }

    public String getCDNHost(boolean secure) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (secure) {
            return this.getCDNHostHttps(companyId);
        }
        return this.getCDNHostHttp(companyId);
    }

    public String getCDNHost(HttpServletRequest request) throws PortalException {
        boolean cdnEnabled = ParamUtil.getBoolean((HttpServletRequest)request, (String)"cdn_enabled", (boolean)true);
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (!cdnEnabled || portletId.equals("com_liferay_portal_settings_web_portlet_PortalSettingsPortlet")) {
            return "";
        }
        String cdnHost = null;
        Company company = this.getCompany(request);
        cdnHost = request.isSecure() ? this.getCDNHostHttps(company.getCompanyId()) : this.getCDNHostHttp(company.getCompanyId());
        if (Validator.isUrl((String)cdnHost)) {
            return cdnHost;
        }
        return "";
    }

    public String getCDNHostHttp(long companyId) {
        String cdnHostHttp = _cdnHostHttpMap.get(companyId);
        if (cdnHostHttp != null) {
            return cdnHostHttp;
        }
        try {
            cdnHostHttp = PrefsPropsUtil.getString(companyId, "cdn.host.http", PropsValues.CDN_HOST_HTTP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cdnHostHttp == null || cdnHostHttp.startsWith("${") || !Validator.isUrl((String)cdnHostHttp)) {
            cdnHostHttp = "";
        }
        _cdnHostHttpMap.put(companyId, cdnHostHttp);
        return cdnHostHttp;
    }

    public String getCDNHostHttps(long companyId) {
        String cdnHostHttps;
        block4: {
            cdnHostHttps = _cdnHostHttpsMap.get(companyId);
            if (cdnHostHttps != null) {
                return cdnHostHttps;
            }
            try {
                cdnHostHttps = PrefsPropsUtil.getString(companyId, "cdn.host.https", PropsValues.CDN_HOST_HTTPS);
            }
            catch (SystemException se) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)se, (Throwable)se);
            }
        }
        if (cdnHostHttps == null || cdnHostHttps.startsWith("${") || !Validator.isUrl((String)cdnHostHttps)) {
            cdnHostHttps = "";
        }
        _cdnHostHttpsMap.put(companyId, cdnHostHttps);
        return cdnHostHttps;
    }

    public String getClassName(long classNameId) {
        try {
            ClassName className = ClassNameLocalServiceUtil.getClassName((long)classNameId);
            return className.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get class name from id " + classNameId, e);
        }
    }

    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    public long getClassNameId(String value) {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            long l;
            if (!StartupHelperUtil.isUpgrading()) {
                return ClassNameLocalServiceUtil.getClassNameId((String)value);
            }
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select classNameId from ClassName_ where value = ?");
                ps.setString(1, value);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                l = rs.getLong("classNameId");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Unable to get class name ID from value " + value, e);
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                    throw throwable;
                }
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    public Company getCompany(HttpServletRequest request) throws PortalException {
        long companyId = this.getCompanyId(request);
        if (companyId <= 0L) {
            return null;
        }
        Company company = (Company)request.getAttribute("COMPANY");
        if (company == null) {
            company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company == null) {
                company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
            }
            request.setAttribute("COMPANY", (Object)company);
        }
        return company;
    }

    public Company getCompany(PortletRequest portletRequest) throws PortalException {
        return this.getCompany(this.getHttpServletRequest(portletRequest));
    }

    public long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId(request);
    }

    public long getCompanyId(PortletRequest portletRequest) {
        return this.getCompanyId(this.getHttpServletRequest(portletRequest));
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public Set<String> getComputerAddresses() {
        return this._computerAddresses;
    }

    public String getComputerName() {
        return this._computerName;
    }

    public String getControlPanelFullURL(long scopeGroupId, String ppid, Map<String, String[]> params) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        Group controlPanelDisplayGroup = this.getControlPanelDisplayGroup(group.getCompanyId(), scopeGroupId, 0L, ppid);
        return this.getSiteAdminURL(controlPanelDisplayGroup, ppid, params);
    }

    public long getControlPanelPlid(long companyId) throws PortalException {
        Group controlPanelGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Control Panel");
        return LayoutLocalServiceUtil.getDefaultPlid((long)controlPanelGroup.getGroupId(), (boolean)true);
    }

    public long getControlPanelPlid(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    public PortletURL getControlPanelPortletURL(HttpServletRequest request, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)request);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(HttpServletRequest request, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(request, null, portletId, 0L, 0L, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((PortletRequest)portletRequest);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(portletRequest, null, portletId, 0L, 0L, lifecycle);
    }

    public String getCreateAccountURL(HttpServletRequest request, ThemeDisplay themeDisplay) throws Exception {
        if (Validator.isNull((String)PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
            LiferayPortletURL createAccountURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
            createAccountURL.setParameter("saveLastPath", Boolean.FALSE.toString());
            createAccountURL.setParameter("mvcRenderCommandName", "/login/create_account");
            createAccountURL.setPortletMode(PortletMode.VIEW);
            createAccountURL.setWindowState(WindowState.MAXIMIZED);
            if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
                return createAccountURL.toString();
            }
            String portalURL = this.getPortalURL(request);
            String portalURLSecure = this.getPortalURL(request, true);
            return StringUtil.replaceFirst((String)createAccountURL.toString(), (String)portalURL, (String)portalURLSecure);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (String)PropsValues.COMPANY_SECURITY_STRANGERS_URL);
            return this.getLayoutURL(layout, themeDisplay);
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsle, (Throwable)nsle);
            }
            return "";
        }
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupId, false);
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled);
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return groupIds;
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupIds, false);
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupIds, checkContentSharingWithChildrenEnabled);
        long[] currentAndAncestorSiteGroupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            currentAndAncestorSiteGroupIds[i] = group.getGroupId();
        }
        return currentAndAncestorSiteGroupIds;
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupId, false);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.doGetCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
        }
        groups.addAll(this.doGetAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled));
        return new ArrayList<Group>(groups);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupIds, false);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (int i = 0; i < groupIds.length; ++i) {
            groups.addAll(this.getCurrentAndAncestorSiteGroups(groupIds[i], checkContentSharingWithChildrenEnabled));
        }
        return new ArrayList<Group>(groups);
    }

    public String getCurrentCompleteURL(HttpServletRequest request) {
        String currentCompleteURL = (String)request.getAttribute("CURRENT_COMPLETE_URL");
        if (currentCompleteURL == null) {
            currentCompleteURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            request.setAttribute("CURRENT_COMPLETE_URL", (Object)currentCompleteURL);
        }
        return currentCompleteURL;
    }

    public String getCurrentURL(HttpServletRequest request) {
        String currentURL = (String)request.getAttribute("CURRENT_URL");
        if (currentURL != null) {
            return currentURL;
        }
        currentURL = ParamUtil.getString((HttpServletRequest)request, (String)"currentURL");
        if (Validator.isNull((String)currentURL) && Validator.isNotNull((String)(currentURL = HttpUtil.getCompleteURL((HttpServletRequest)request))) && !currentURL.contains(_J_SECURITY_CHECK)) {
            currentURL = currentURL.substring(currentURL.indexOf("://") + "://".length());
            currentURL = currentURL.substring(currentURL.indexOf(47));
        }
        if (Validator.isNull((String)currentURL)) {
            currentURL = this.getPathMain();
        }
        request.setAttribute("CURRENT_URL", (Object)currentURL);
        return currentURL;
    }

    public String getCurrentURL(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("CURRENT_URL");
    }

    public String getCustomSQLFunctionIsNotNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNOTNULL;
    }

    public String getCustomSQLFunctionIsNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNULL;
    }

    public Date getDate(int month, int day, int year) {
        try {
            return this.getDate(month, day, year, null);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    public Date getDate(int month, int day, int year, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, hour, min, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        if (!Validator.isGregorianDate((int)month, (int)day, (int)year)) {
            if (clazz != null) {
                try {
                    throw clazz.newInstance();
                }
                catch (PortalException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PortalException((Throwable)e);
                }
            }
            return null;
        }
        Calendar cal = null;
        cal = timeZone == null ? CalendarFactoryUtil.getCalendar() : CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
        if (hour == -1 || min == -1) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, hour, min, 0);
        }
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public Date getDate(int month, int day, int year, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, -1, -1, timeZone, clazz);
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    @Deprecated
    public long getDigestAuthUserId(HttpServletRequest request) throws PortalException {
        return HttpAuthManagerUtil.getDigestUserId((HttpServletRequest)request);
    }

    public String getEmailFromAddress(PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        return preferences.getValue("emailFromAddress", defaultValue);
    }

    public String getEmailFromName(PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        return preferences.getValue("emailFromName", defaultValue);
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, HttpServletRequest request) throws PortalException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString((HttpServletRequest)request, (String)param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString((String)properties.getProperty("display-type"), (String)"text-box");
            Serializable value = this.getExpandoValue(request, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, this.getHttpServletRequest(portletRequest));
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, UploadPortletRequest uploadPortletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, (HttpServletRequest)uploadPortletRequest);
    }

    public Serializable getExpandoValue(HttpServletRequest request, String name, int type, String displayType) throws PortalException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((HttpServletRequest)request, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "Month"));
                int valueDateDay = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "Day"));
                int valueDateYear = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "Year"));
                int valueDateHour = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((HttpServletRequest)request, (String)(name + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = this.getUser(request);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = this.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((HttpServletRequest)request, (String)name);
                } else if (type == 6) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((HttpServletRequest)request, (String)name));
                } else if (type == 8) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((HttpServletRequest)request, (String)name);
                } else if (type == 10) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((HttpServletRequest)request, (String)name);
                } else if (type == 12) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber((HttpServletRequest)request, (String)name);
                } else if (type == 18) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((HttpServletRequest)request, (String)name);
                } else if (type == 14) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    Object[] values = request.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = values;
                } else {
                    value = type == 20 ? (Serializable)((Object)LocalizationUtil.getLocalizationMap((HttpServletRequest)request, (String)name)) : ParamUtil.getString((HttpServletRequest)request, (String)name);
                }
            }
        }
        return value;
    }

    public Serializable getExpandoValue(PortletRequest portletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue(this.getHttpServletRequest(portletRequest), name, type, displayType);
    }

    public Serializable getExpandoValue(UploadPortletRequest uploadPortletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue((HttpServletRequest)uploadPortletRequest, name, type, displayType);
    }

    @Deprecated
    public String getFacebookURL(Portlet portlet, String facebookCanvasPageURL, ThemeDisplay themeDisplay) throws PortalException {
        String facebookURL = this.getServletURL(portlet, "/facebook/" + facebookCanvasPageURL, themeDisplay);
        if (!facebookURL.endsWith("/")) {
            facebookURL = facebookURL + "/";
        }
        return facebookURL;
    }

    public String getFirstPageLayoutTypes(HttpServletRequest request) {
        StringBundler sb = new StringBundler();
        for (String type : LayoutTypeControllerTracker.getTypes()) {
            LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type);
            if (!layoutTypeController.isFirstPageable()) continue;
            sb.append(LanguageUtil.get((HttpServletRequest)request, (String)("layout.types." + type)));
            sb.append(",");
            sb.append(" ");
        }
        if (sb.index() >= 2) {
            sb.setIndex(sb.index() - 2);
        }
        return sb.toString();
    }

    public String getForwardedHost(HttpServletRequest request) {
        if (!PropsValues.WEB_SERVER_FORWARDED_HOST_ENABLED) {
            return request.getServerName();
        }
        return GetterUtil.get((String)request.getHeader(PropsValues.WEB_SERVER_FORWARDED_HOST_HEADER), (String)request.getServerName());
    }

    public int getForwardedPort(HttpServletRequest request) {
        if (!PropsValues.WEB_SERVER_FORWARDED_PORT_ENABLED) {
            return request.getServerPort();
        }
        return GetterUtil.getInteger((String)request.getHeader(PropsValues.WEB_SERVER_FORWARDED_PORT_HEADER), (int)request.getServerPort());
    }

    public String getFullName(String firstName, String middleName, String lastName) {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(firstName, middleName, lastName);
    }

    public String getGlobalLibDir() {
        return PropsValues.LIFERAY_LIB_GLOBAL_DIR;
    }

    public String getGoogleGadgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, themeDisplay);
    }

    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getGroupFriendlyURL(layoutSet, themeDisplay, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getGroupFriendlyURL(layoutSet, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public int[] getGroupFriendlyURLIndex(String requestURI) {
        if (requestURI.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING + "/") || requestURI.startsWith(_PRIVATE_USER_SERVLET_MAPPING + "/") || requestURI.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING + "/")) {
            int x = requestURI.indexOf("/", 1);
            int y = requestURI.indexOf(47, x + 1);
            if (y == -1) {
                requestURI = requestURI + "/";
                y = requestURI.indexOf(47, x + 1);
            }
            return new int[]{x, y};
        }
        return null;
    }

    public String[] getGroupPermissions(HttpServletRequest request) {
        return request.getParameterValues("groupPermissions");
    }

    public String[] getGroupPermissions(HttpServletRequest request, String className) {
        String[] groupPermissions = request.getParameterValues("groupPermissions_" + className);
        String inputPermissionsShowOptions = request.getParameter("inputPermissionsShowOptions");
        return this.getGroupPermissions(groupPermissions, className, inputPermissionsShowOptions);
    }

    public String[] getGroupPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("groupPermissions");
    }

    public String[] getGroupPermissions(PortletRequest portletRequest, String className) {
        String[] groupPermissions = portletRequest.getParameterValues("groupPermissions_" + className);
        String inputPermissionsShowOptions = portletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGroupPermissions(groupPermissions, className, inputPermissionsShowOptions);
    }

    public String[] getGuestPermissions(HttpServletRequest request) {
        return request.getParameterValues("guestPermissions");
    }

    public String[] getGuestPermissions(HttpServletRequest request, String className) {
        String[] guestPermissions = request.getParameterValues("guestPermissions_" + className);
        String inputPermissionsShowOptions = request.getParameter("inputPermissionsShowOptions");
        return this.getGuestPermissions(guestPermissions, className, inputPermissionsShowOptions);
    }

    public String[] getGuestPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("guestPermissions");
    }

    public String[] getGuestPermissions(PortletRequest portletRequest, String className) {
        String[] guestPermissions = portletRequest.getParameterValues("guestPermissions_" + className);
        String inputPermissionsShowOptions = portletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGuestPermissions(guestPermissions, className, inputPermissionsShowOptions);
    }

    public String getHomeURL(HttpServletRequest request) throws PortalException {
        String portalURL = this.getPortalURL(request);
        return portalURL + this._pathContext + this.getRelativeHomeURL(request);
    }

    public String getHost(HttpServletRequest request) {
        int pos;
        String host = (request = this.getOriginalServletRequest(request)).getHeader("Host");
        if (host != null && (pos = (host = StringUtil.toLowerCase((String)host.trim())).indexOf(58)) >= 0) {
            host = host.substring(0, pos);
        }
        return host;
    }

    public String getHost(PortletRequest portletRequest) {
        return this.getHost(this.getHttpServletRequest(portletRequest));
    }

    public HttpServletRequest getHttpServletRequest(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)portletRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        if (httpServletRequest != null) {
            return httpServletRequest;
        }
        if (portletRequest instanceof LiferayPortletRequest) {
            LiferayPortletRequest liferayPortletRequest = (LiferayPortletRequest)portletRequest;
            return liferayPortletRequest.getHttpServletRequest();
        }
        PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
        return portletRequestImpl.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)portletResponse;
            return liferayPortletResponse.getHttpServletResponse();
        }
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return portletResponseImpl.getHttpServletResponse();
    }

    public String getI18nPathLanguageId(Locale locale, String defaultI18nPathLanguageId) {
        String i18nPathLanguageId = defaultI18nPathLanguageId;
        if (!LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            i18nPathLanguageId = locale.getLanguage();
        } else {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                i18nPathLanguageId = locale.getLanguage();
            }
        }
        return i18nPathLanguageId;
    }

    @Deprecated
    public String getJournalArticleActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR);
        if (friendlyURLResolver == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        long companyId = PortalInstances.getCompanyId(request);
        return friendlyURLResolver.getActualURL(companyId, groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
    }

    @Deprecated
    public Layout getJournalArticleLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR);
        if (friendlyURLResolver == null) {
            return null;
        }
        LayoutFriendlyURLComposite layoutFriendlyURLComposite = friendlyURLResolver.getLayoutFriendlyURLComposite(0L, groupId, privateLayout, friendlyURL, new HashMap(), new HashMap());
        return layoutFriendlyURLComposite.getLayout();
    }

    public String getJsSafePortletId(String portletId) {
        return JS.getSafeName((String)portletId);
    }

    public String getLayoutActualURL(Layout layout) {
        return this.getLayoutActualURL(layout, this.getPathMain());
    }

    public String getLayoutActualURL(Layout layout, String mainPath) {
        HashMap<String, String> variables = new HashMap<String, String>();
        layout = this.getBrowsableLayout(layout);
        variables.put("liferay:groupId", String.valueOf(layout.getGroupId()));
        variables.put("liferay:mainPath", mainPath);
        variables.put("liferay:plid", String.valueOf(layout.getPlid()));
        if (layout instanceof VirtualLayout) {
            variables.put("liferay:pvlsgid", String.valueOf(layout.getGroupId()));
        } else {
            variables.put("liferay:pvlsgid", "0");
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        variables.putAll((Map<String, String>)typeSettingsProperties);
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        return LayoutTypeImpl.getURL(layoutTypeController.getURL(), variables);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL) throws PortalException {
        return this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, null, null);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        UnicodeProperties typeSettingsProperties;
        LayoutQueryStringComposite actualLayoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        Layout layout = actualLayoutQueryStringComposite.getLayout();
        String queryString = actualLayoutQueryStringComposite.getQueryString();
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        if (Validator.isNotNull((String)queryString)) {
            layoutActualURL = layoutActualURL.concat(queryString);
        } else if (params.isEmpty() && Validator.isNotNull((String)(queryString = (typeSettingsProperties = layout.getTypeSettingsProperties()).getProperty("query-string"))) && layoutActualURL.contains("?")) {
            layoutActualURL = layoutActualURL.concat("&").concat(queryString);
        }
        return layoutActualURL;
    }

    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (themeDisplay.getLayout() == layout) {
            return this.getLayoutFriendlyURL(themeDisplay);
        }
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (layoutSet == null || layoutSet.getGroupId() != layout.getGroupId() || layoutSet.getPrivateLayout() != layout.getPrivateLayout()) {
            layoutSet = layout.getLayoutSet();
        }
        String groupFriendlyURL = this.getGroupFriendlyURL(layoutSet, themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutFriendlyURL(layout, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public String getLayoutFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        Group group = themeDisplay.getSiteGroup();
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        String groupFriendlyURL = this._getGroupFriendlyURL(group, themeDisplay.getLayoutSet(), themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    @Deprecated
    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = this.getLayoutFriendlyURLSeparatorComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        return layoutFriendlyURLSeparatorComposite;
    }

    public LayoutFriendlyURLSeparatorComposite getLayoutFriendlyURLSeparatorComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = null;
        if (friendlyURL != null) {
            HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(request);
            Collection friendlyURLResolvers = FriendlyURLResolverRegistryUtil.getFriendlyURLResolversAsCollection();
            for (FriendlyURLResolver friendlyURLResolver : friendlyURLResolvers) {
                if (!friendlyURL.startsWith(friendlyURLResolver.getURLSeparator())) continue;
                try {
                    layoutFriendlyURLSeparatorComposite = friendlyURLResolver.getLayoutFriendlyURLSeparatorComposite(companyId, groupId, privateLayout, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception e) {
                    throw new NoSuchLayoutException((Throwable)e);
                }
            }
        }
        if (layoutFriendlyURLSeparatorComposite != null) {
            return layoutFriendlyURLSeparatorComposite;
        }
        LayoutQueryStringComposite layoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        return new LayoutFriendlyURLSeparatorComposite(layoutQueryStringComposite.getLayout(), layoutQueryStringComposite.getFriendlyURL(), _JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(layout, themeDisplay, true);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutURL = this.getLayoutURL(layout, themeDisplay, doAsUser);
        if (!HttpUtil.hasProtocol((String)layoutURL)) {
            layoutURL = this.getPortalURL(layout, themeDisplay) + layoutURL;
        }
        return layoutURL;
    }

    public String getLayoutFullURL(long groupId, String portletId) throws PortalException {
        return this.getLayoutFullURL(groupId, portletId, false);
    }

    public String getLayoutFullURL(long groupId, String portletId, boolean secure) throws PortalException {
        long parentGroupId;
        long plid = this.getPlidFromPortletId(groupId, portletId);
        if (plid == 0L) {
            return null;
        }
        StringBundler sb = new StringBundler(4);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        String virtualHostname = null;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)layoutSet.getVirtualHostname())) {
            virtualHostname = layoutSet.getVirtualHostname();
        } else {
            Company company = CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId());
            virtualHostname = company.getVirtualHostname();
        }
        String portalURL = this.getPortalURL(virtualHostname, this.getPortalServerPort(secure), secure);
        sb.append(portalURL);
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(this.getPathFriendlyURLPrivateUser());
            } else {
                sb.append(this.getPathFriendlyURLPrivateGroup());
            }
        } else {
            sb.append(this.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutFullURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutRelativeURL(layout, themeDisplay, true);
    }

    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutFullURL = this.getLayoutFullURL(layout, themeDisplay, doAsUser);
        return HttpUtil.removeDomain((String)layoutFullURL);
    }

    public String getLayoutSetDisplayURL(LayoutSet layoutSet, boolean secureConnection) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany((long)layoutSet.getCompanyId());
        int portalPort = this.getPortalServerPort(secureConnection);
        String portalURL = this.getPortalURL(company.getVirtualHostname(), portalPort, secureConnection);
        String virtualHostname = this.getVirtualHostname(layoutSet);
        if (Validator.isNotNull((String)virtualHostname) && !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
            int index = portalURL.indexOf("://");
            String portalDomain = portalURL.substring(index + 3);
            virtualHostname = this.getCanonicalDomain(virtualHostname, portalDomain);
            if ((virtualHostname = this.getPortalURL(virtualHostname, portalPort, secureConnection)).contains(portalDomain)) {
                return virtualHostname.concat(this.getPathContext());
            }
        }
        StringBundler sb = new StringBundler(4);
        sb.append(portalURL);
        sb.append(this.getPathContext());
        Group group = layoutSet.getGroup();
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutSetFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        String virtualHostname = this.getVirtualHostname(layoutSet);
        if (Validator.isNotNull((String)virtualHostname) && !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
            String portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
            Layout curLayout = themeDisplay.getLayout();
            LayoutSet curLayoutSet = curLayout.getLayoutSet();
            long curLayoutSetId = curLayoutSet.getLayoutSetId();
            if (layoutSet.getLayoutSetId() != curLayoutSetId || portalURL.startsWith(themeDisplay.getURLPortal())) {
                String layoutSetFriendlyURL = portalURL + this._pathContext;
                if (themeDisplay.isI18n()) {
                    layoutSetFriendlyURL = layoutSetFriendlyURL + themeDisplay.getI18nPath();
                }
                return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
            }
        }
        Group group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isI18n()) {
            friendlyURL = themeDisplay.getI18nPath() + friendlyURL;
        }
        String layoutSetFriendlyURL = this._pathContext + friendlyURL + group.getFriendlyURL();
        return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
    }

    public String getLayoutTarget(Layout layout) {
        UnicodeProperties typeSettingsProps = layout.getTypeSettingsProperties();
        String target = typeSettingsProps.getProperty("target");
        target = Validator.isNull((String)target) ? "" : "target=\"" + HtmlUtil.escapeAttribute((String)target) + "\"";
        return target;
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(layout, themeDisplay, true);
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutFriendlyURL;
        if (layout == null) {
            return themeDisplay.getPathMain() + "/portal/layout";
        }
        if (!layout.isTypeURL() && Validator.isNotNull((String)(layoutFriendlyURL = this.getLayoutFriendlyURL(layout, themeDisplay)))) {
            layoutFriendlyURL = this.addPreservedParameters(themeDisplay, layout, layoutFriendlyURL, doAsUser);
            return layoutFriendlyURL;
        }
        String layoutURL = this.getLayoutActualURL(layout);
        layoutURL = this.addPreservedParameters(themeDisplay, layout, layoutURL, doAsUser);
        return layoutURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutURL(layout, themeDisplay, true);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public String getLayoutURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(themeDisplay.getLayout(), themeDisplay);
    }

    public LiferayPortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        if (portletRequest instanceof LiferayPortletRequest) {
            return (LiferayPortletRequest)portletRequest;
        }
        PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
        return DoPrivilegedUtil.wrapWhenActive(portletRequestImpl);
    }

    public LiferayPortletResponse getLiferayPortletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            return (LiferayPortletResponse)portletResponse;
        }
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return DoPrivilegedUtil.wrapWhenActive(portletResponseImpl);
    }

    public Locale getLocale(HttpServletRequest request) {
        Locale locale = (Locale)request.getAttribute("LOCALE");
        if (locale == _NULL_LOCALE) {
            return null;
        }
        if (locale == null) {
            locale = this.getLocale(request, null, false);
            if (locale == null) {
                request.setAttribute("LOCALE", (Object)_NULL_LOCALE);
            } else {
                request.setAttribute("LOCALE", (Object)locale);
            }
        }
        return locale;
    }

    public Locale getLocale(HttpServletRequest request, HttpServletResponse response, boolean initialize) {
        Locale cookieLocale;
        Locale userLocale;
        String doAsUserLanguageId;
        String i18nLanguageId;
        User user = null;
        if (initialize) {
            try {
                user = this.initUser(request);
            }
            catch (NoSuchUserException nsue) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsue, (Throwable)nsue);
                }
                return null;
            }
            catch (Exception nsue) {
                // empty catch block
            }
        }
        Locale locale = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            locale = themeDisplay.getLocale();
            if (LanguageUtil.isAvailableLocale((long)themeDisplay.getSiteGroupId(), (Locale)locale)) {
                return locale;
            }
        }
        long groupId = 0L;
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        if (layout != null && !layout.isTypeControlPanel()) {
            try {
                long scopeGroupId = this.getScopeGroupId(request);
                groupId = this.getSiteGroupId(scopeGroupId);
            }
            catch (Exception scopeGroupId) {
                // empty catch block
            }
        }
        if (Validator.isNotNull((String)(i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID")))) {
            locale = LocaleUtil.fromLanguageId((String)i18nLanguageId, (boolean)true, (boolean)false);
            if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)locale)) {
                return locale;
            }
            if (groupId > 0L) {
                String i18nLanguageCode;
                boolean inheritLocales = true;
                try {
                    inheritLocales = LanguageUtil.isInheritLocales((long)groupId);
                }
                catch (PortalException pe) {
                    _log.error((Object)("Unable to check if group " + groupId + " inherits locales"), (Throwable)pe);
                }
                if (!inheritLocales && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LanguageUtil.getLocale((long)groupId, (String)(i18nLanguageCode = (String)request.getAttribute("I18N_LANGUAGE_CODE")))))) {
                    return locale;
                }
            }
        }
        if (Validator.isNotNull((String)(doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId"))) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LocaleUtil.fromLanguageId((String)doAsUserLanguageId)))) {
            return locale;
        }
        HttpSession session = request.getSession(false);
        if (session != null && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE")))) {
            return locale;
        }
        if (user == null) {
            try {
                user = this.getUser(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user != null && !user.isDefaultUser() && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(userLocale = this.getAvailableLocale(groupId, user.getLocale())))) {
            if (initialize) {
                this.setLocale(request, response, userLocale);
            }
            return userLocale;
        }
        String languageId = CookieKeys.getCookie((HttpServletRequest)request, (String)"GUEST_LANGUAGE_ID", (boolean)false);
        if (Validator.isNotNull((String)languageId) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(cookieLocale = this.getAvailableLocale(groupId, LocaleUtil.fromLanguageId((String)languageId))))) {
            if (initialize) {
                this.setLocale(request, response, cookieLocale);
            }
            return cookieLocale;
        }
        if (PropsValues.LOCALE_DEFAULT_REQUEST) {
            Enumeration locales = request.getLocales();
            while (locales.hasMoreElements()) {
                Locale requestLocale = this.getAvailableLocale(groupId, (Locale)locales.nextElement());
                if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)requestLocale)) continue;
                if (initialize) {
                    this.setLocale(request, response, requestLocale);
                }
                return requestLocale;
            }
        }
        if (groupId > 0L) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                String defaultLanguageId = typeSettingsProperties.getProperty("languageId");
                if (Validator.isNotNull((String)defaultLanguageId) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LocaleUtil.fromLanguageId((String)defaultLanguageId)))) {
                    if (initialize) {
                        this.setLocale(request, response, locale);
                    }
                    return locale;
                }
            }
            catch (Exception group) {
                // empty catch block
            }
        }
        Company company = null;
        try {
            company = this.getCompany(request);
        }
        catch (Exception typeSettingsProperties) {
            // empty catch block
        }
        if (company == null) {
            return null;
        }
        User defaultUser = null;
        try {
            defaultUser = company.getDefaultUser();
        }
        catch (Exception defaultLanguageId) {
            // empty catch block
        }
        if (defaultUser == null) {
            return null;
        }
        Locale defaultUserLocale = this.getAvailableLocale(groupId, defaultUser.getLocale());
        if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)defaultUserLocale)) {
            if (initialize) {
                this.setLocale(request, response, defaultUserLocale);
            }
            return defaultUserLocale;
        }
        try {
            if (themeDisplay != null) {
                return themeDisplay.getSiteDefaultLocale();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return this.getSiteDefaultLocale(groupId);
        }
        catch (Exception e) {
            return LocaleUtil.getDefault();
        }
    }

    public Locale getLocale(PortletRequest portletRequest) {
        return this.getLocale(this.getHttpServletRequest(portletRequest));
    }

    public String getLocalizedFriendlyURL(HttpServletRequest request, Layout layout, Locale locale, Locale originalLocale) {
        String contextPath = this.getPathContext();
        String requestURI = request.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String path = request.getPathInfo();
        int x = path.indexOf(47, 1);
        String layoutFriendlyURL = null;
        if (originalLocale == null) {
            int y;
            if (x != -1 && x + 1 != path.length()) {
                layoutFriendlyURL = path.substring(x);
            }
            if ((y = layoutFriendlyURL.indexOf("/~")) != -1 && (y = layoutFriendlyURL.indexOf(47, 3)) != -1 && y + 1 != layoutFriendlyURL.length()) {
                layoutFriendlyURL = layoutFriendlyURL.substring(y);
            }
            if ((y = layoutFriendlyURL.indexOf(_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR)) != -1) {
                layoutFriendlyURL = layoutFriendlyURL.substring(0, y);
            }
        } else {
            layoutFriendlyURL = layout.getFriendlyURL(originalLocale);
        }
        if (requestURI.contains(layoutFriendlyURL)) {
            requestURI = StringUtil.replaceFirst((String)requestURI, (String)layoutFriendlyURL, (String)layout.getFriendlyURL(locale));
        }
        String i18nPath = "/" + this.getI18nPathLanguageId(locale, LocaleUtil.toLanguageId((Locale)locale));
        boolean appendI18nPath = true;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && locale.equals(LocaleUtil.getDefault())) {
            appendI18nPath = false;
        }
        String localizedFriendlyURL = contextPath;
        if (appendI18nPath) {
            localizedFriendlyURL = localizedFriendlyURL + i18nPath;
        }
        localizedFriendlyURL = localizedFriendlyURL + requestURI;
        String queryString = request.getQueryString();
        if (Validator.isNotNull((String)queryString)) {
            localizedFriendlyURL = localizedFriendlyURL + "?" + request.getQueryString();
        }
        return localizedFriendlyURL;
    }

    public String getMailId(String mx, String popPortletPrefix, Object ... ids) {
        StringBundler sb = new StringBundler(ids.length * 2 + 7);
        sb.append("<");
        sb.append(popPortletPrefix);
        if (!popPortletPrefix.endsWith(".")) {
            sb.append(".");
        }
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            if (i != 0) {
                sb.append(".");
            }
            sb.append(id);
        }
        sb.append("@");
        if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public String getNetvibesURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.NETVIBES_SERVLET_MAPPING, themeDisplay);
    }

    public String getNewPortletTitle(String portletTitle, String oldScopeName, String newScopeName) {
        if (portletTitle.endsWith(" (" + oldScopeName + ")")) {
            int pos = portletTitle.lastIndexOf(" (" + oldScopeName + ")");
            portletTitle = portletTitle.substring(0, pos);
        }
        if (Validator.isNull((String)newScopeName)) {
            return portletTitle;
        }
        return StringUtil.appendParentheticalSuffix((String)portletTitle, (String)newScopeName);
    }

    public HttpServletRequest getOriginalServletRequest(HttpServletRequest request) {
        HttpServletRequest currentRequest = request;
        PersistentHttpServletRequestWrapper currentRequestWrapper = null;
        PersistentHttpServletRequestWrapper originalRequest = null;
        while (currentRequest instanceof HttpServletRequestWrapper) {
            if (currentRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentRequest;
                persistentHttpServletRequestWrapper = persistentHttpServletRequestWrapper.clone();
                if (originalRequest == null) {
                    originalRequest = persistentHttpServletRequestWrapper;
                }
                if (currentRequestWrapper != null) {
                    currentRequestWrapper.setRequest((ServletRequest)persistentHttpServletRequestWrapper);
                }
                currentRequestWrapper = persistentHttpServletRequestWrapper;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentRequest;
            currentRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (currentRequestWrapper != null) {
            currentRequestWrapper.setRequest((ServletRequest)currentRequest);
        }
        if (originalRequest != null) {
            return originalRequest;
        }
        return currentRequest;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathContext(HttpServletRequest request) {
        return this.getPathContext(request.getContextPath());
    }

    public String getPathContext(PortletRequest portletRequest) {
        return this.getPathContext(portletRequest.getContextPath());
    }

    public String getPathContext(String contextPath) {
        return this._pathProxy.concat(this.getContextPath(contextPath));
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public String getPathModule() {
        return this._pathModule;
    }

    public String getPathProxy() {
        return this._pathProxy;
    }

    public long getPlidFromFriendlyURL(long companyId, String friendlyURL) {
        if (Validator.isNull((String)friendlyURL) || friendlyURL.equals("/")) {
            return 0L;
        }
        String[] urlParts = friendlyURL.split("\\/", 4);
        if (friendlyURL.charAt(0) != '/' && urlParts.length != 4) {
            return 0L;
        }
        boolean privateLayout = true;
        String urlPrefix = "/" + urlParts[1];
        if (_PUBLIC_GROUP_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = false;
        } else if (_PRIVATE_GROUP_SERVLET_MAPPING.equals(urlPrefix) || _PRIVATE_USER_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = true;
        } else {
            return 0L;
        }
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + urlParts[2]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group == null) {
            return 0L;
        }
        Layout layout = null;
        try {
            String layoutFriendlyURL = null;
            if (urlParts.length == 4) {
                layoutFriendlyURL = "/" + urlParts[3];
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)group.getGroupId(), (boolean)privateLayout, (String)layoutFriendlyURL);
            } else {
                List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)privateLayout, (long)0L, (boolean)true, (int)0, (int)1);
                if (!layouts.isEmpty()) {
                    layout = (Layout)layouts.get(0);
                } else {
                    return 0L;
                }
            }
            return layout.getPlid();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long plid = 0L;
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append(" ");
        sb.append(privateLayout);
        sb.append(" ");
        sb.append(portletId);
        String key = sb.toString();
        Long plidObj = this._plidToPortletIdMap.get(key);
        if (plidObj == null) {
            plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdMap.put(key, plid);
            }
        } else {
            plid = plidObj;
            boolean validPlid = false;
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasDefaultScopePortletId(groupId, portletId)) {
                    validPlid = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!validPlid) {
                this._plidToPortletIdMap.remove(key);
                plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
                if (plid != 0L) {
                    this._plidToPortletIdMap.put(key, plid);
                }
            }
        }
        return plid;
    }

    public long getPlidFromPortletId(long groupId, String portletId) {
        long plid = this.getPlidFromPortletId(groupId, false, portletId);
        if (plid == 0L) {
            plid = this.getPlidFromPortletId(groupId, true, portletId);
        }
        if (plid == 0L && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Portlet ", portletId, " does not exist on a page in group ", String.valueOf(groupId)}));
        }
        return plid;
    }

    public PortalInetSocketAddressEventListener[] getPortalInetSocketAddressEventListeners() {
        return this._portalInetSocketAddressEventListeners.toArray(new PortalInetSocketAddressEventListener[this._portalInetSocketAddressEventListeners.size()]);
    }

    public String getPortalLibDir() {
        return PropsValues.LIFERAY_LIB_PORTAL_DIR;
    }

    public InetAddress getPortalLocalInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    public int getPortalLocalPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    @Deprecated
    public int getPortalPort(boolean secure) {
        return this.getPortalServerPort(secure);
    }

    public Properties getPortalProperties() {
        return PropsUtil.getProperties();
    }

    public InetAddress getPortalServerInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    public int getPortalServerPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    public String getPortalURL(HttpServletRequest request) {
        return this.getPortalURL(request, this.isSecure(request));
    }

    public String getPortalURL(HttpServletRequest request, boolean secure) {
        int serverPort = this.getForwardedPort(request);
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(this.getForwardedHost(request), serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    public String getPortalURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        String serverName = themeDisplay.getServerName();
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        if (layout != null) {
            Layout virtualHostLayout = layout;
            long refererPlid = themeDisplay.getRefererPlid();
            if (refererPlid > 0L) {
                virtualHostLayout = LayoutLocalServiceUtil.getLayout((long)refererPlid);
            }
            return this.getPortalURL(virtualHostLayout.getLayoutSet(), themeDisplay);
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) {
        String domain;
        String serverName = themeDisplay.getServerName();
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNotNull((String)virtualHostname) && (domain = themeDisplay.getPortalDomain()).startsWith(virtualHostname)) {
            serverName = virtualHostname;
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest) {
        return this.getPortalURL(portletRequest, portletRequest.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest, boolean secure) {
        int port = portletRequest.getServerPort();
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(portletRequest.getServerName(), port, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, port, secure);
    }

    public String getPortalURL(String serverName, int serverPort, boolean secure) {
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(serverName, serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    public String getPortalURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getPortalURL((Layout)null, themeDisplay);
    }

    public String getPortalWebDir() {
        return PropsValues.LIFERAY_WEB_PORTAL_DIR;
    }

    @Deprecated
    public List<BreadcrumbEntry> getPortletBreadcrumbs(HttpServletRequest request) {
        return BreadcrumbUtil.getPortletBreadcrumbEntries((HttpServletRequest)request);
    }

    public PortletConfig getPortletConfig(long companyId, String portletId, ServletContext servletContext) throws PortletException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        return invokerPortlet.getPortletConfig();
    }

    public String getPortletDescription(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletDescription = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.description".concat(".").concat(portlet.getRootPortletId()), null);
        if (Validator.isNull((String)portletDescription)) {
            portletDescription = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.description");
        }
        return portletDescription;
    }

    public String getPortletDescription(Portlet portlet, User user) {
        return this.getPortletDescription(portlet.getPortletId(), user);
    }

    public String getPortletDescription(String portletId, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"javax.portlet.description".concat(".").concat(portletId));
    }

    public String getPortletDescription(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletDescription(portletId, locale);
    }

    public String getPortletDescription(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)"javax.portlet.description".concat(".").concat(portletId));
    }

    public LayoutQueryStringComposite getPortletFriendlyURLMapperLayoutQueryStringComposite(long groupId, boolean privateLayout, String url, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        int x;
        boolean foundFriendlyURLMapper = false;
        String friendlyURL = url;
        String queryString = "";
        List portlets = PortletLocalServiceUtil.getFriendlyURLMapperPortlets();
        for (Portlet portlet : portlets) {
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (url.endsWith("/" + friendlyURLMapper.getMapping())) {
                url = url + "/";
            }
            int pos = -1;
            pos = friendlyURLMapper.isCheckMappingWithPrefix() ? url.indexOf(_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR + friendlyURLMapper.getMapping() + "/") : url.indexOf("/" + friendlyURLMapper.getMapping() + "/");
            if (pos == -1) continue;
            foundFriendlyURLMapper = true;
            friendlyURL = url.substring(0, pos);
            InheritableMap actualParams = new InheritableMap();
            if (params != null) {
                actualParams.setParentMap(params);
            }
            HashMap<String, String> prpIdentifiers = new HashMap<String, String>();
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                QName qName = publicRenderParameter.getQName();
                String publicRenderParameterIdentifier = qName.getLocalPart();
                String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
                prpIdentifiers.put(publicRenderParameterIdentifier, publicRenderParameterName);
            }
            FriendlyURLMapperThreadLocal.setPRPIdentifiers(prpIdentifiers);
            if (friendlyURLMapper.isCheckMappingWithPrefix()) {
                friendlyURLMapper.populateParams(url.substring(pos + 2), (Map)actualParams, requestContext);
            } else {
                friendlyURLMapper.populateParams(url.substring(pos), (Map)actualParams, requestContext);
            }
            queryString = "&" + HttpUtil.parameterMapToString((Map)actualParams, (boolean)false);
            break;
        }
        if (!foundFriendlyURLMapper && (x = url.indexOf(_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR)) != -1) {
            String ppid;
            int y = url.indexOf(47, x + 3);
            if (y == -1) {
                y = url.length();
            }
            if (Validator.isNotNull((String)(ppid = url.substring(x + 3, y)))) {
                friendlyURL = url.substring(0, x);
                HashMap<Object, Object> actualParams = null;
                actualParams = params != null ? new HashMap<String, String[]>(params) : new HashMap();
                actualParams.put("p_p_id", new String[]{ppid});
                actualParams.put("p_p_lifecycle", new String[]{"0"});
                actualParams.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
                actualParams.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
                queryString = "&" + HttpUtil.parameterMapToString(actualParams, (boolean)false);
            }
        }
        if ((friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/")).endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        Layout layout = null;
        if (Validator.isNotNull((String)friendlyURL)) {
            layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)privateLayout, (String)friendlyURL);
        } else {
            long defaultPlid = LayoutLocalServiceUtil.getDefaultPlid((long)groupId, (boolean)privateLayout);
            layout = LayoutLocalServiceUtil.getLayout((long)defaultPlid);
        }
        return new LayoutQueryStringComposite(layout, friendlyURL, queryString);
    }

    public String getPortletId(HttpServletRequest request) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)request.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletId(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletLongTitle(Portlet portlet, Locale locale) {
        return this.getPortletLongTitle(portlet.getPortletId(), locale);
    }

    public String getPortletLongTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        try {
            String portletLongTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.long-title");
            if (portletLongTitle.startsWith("javax.portlet.long-title")) {
                portletLongTitle = this.getPortletTitle(portlet, servletContext, locale);
            }
            return portletLongTitle;
        }
        catch (Exception e) {
            return this.getPortletTitle(portlet, servletContext, locale);
        }
    }

    public String getPortletLongTitle(Portlet portlet, String languageId) {
        return this.getPortletLongTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletLongTitle(Portlet portlet, User user) {
        return this.getPortletLongTitle(portlet.getPortletId(), user);
    }

    public String getPortletLongTitle(String portletId, Locale locale) {
        String portletLongTitle = LanguageUtil.get((Locale)locale, (String)"javax.portlet.long-title".concat(".").concat(portletId), (String)"");
        if (Validator.isNull((String)portletLongTitle)) {
            portletLongTitle = this.getPortletTitle(portletId, locale);
        }
        return portletLongTitle;
    }

    public String getPortletLongTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletLongTitle(portletId, locale);
    }

    public String getPortletLongTitle(String portletId, User user) {
        return this.getPortletLongTitle(portletId, user.getLocale());
    }

    public String getPortletNamespace(String portletId) {
        return "_".concat(portletId).concat("_");
    }

    public String getPortletTitle(Portlet portlet, Locale locale) {
        return this.getPortletTitle(portlet.getPortletId(), locale);
    }

    public String getPortletTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        return this._getPortletTitle(portlet.getRootPortletId(), portletConfig, locale);
    }

    public String getPortletTitle(Portlet portlet, String languageId) {
        return this.getPortletTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletTitle(Portlet portlet, User user) {
        return this.getPortletTitle(portlet.getPortletId(), user);
    }

    public String getPortletTitle(PortletRequest portletRequest) {
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        PortletConfig portletConfig = PortletConfigFactoryUtil.get((String)portletId);
        Locale locale = portletRequest.getLocale();
        if (portletConfig == null) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(portletRequest), (String)portletId);
            HttpServletRequest request = this.getHttpServletRequest(portletRequest);
            ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
            return this.getPortletTitle(portlet, servletContext, locale);
        }
        return this._getPortletTitle(PortletIdCodec.decodePortletName((String)portletId), portletConfig, locale);
    }

    public String getPortletTitle(PortletResponse portletResponse) {
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        return ((RenderResponseImpl)portletResponseImpl).getTitle();
    }

    public String getPortletTitle(String portletId, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.get((String)portletId);
        return this.getPortletTitle(portletId, portletConfig.getResourceBundle(locale));
    }

    public String getPortletTitle(String portletId, ResourceBundle resourceBundle) {
        portletId = PortletIdCodec.decodePortletName((String)portletId);
        String portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.title".concat(".").concat(portletId), null);
        if (Validator.isNull((String)portletTitle)) {
            portletTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.title");
        }
        return portletTitle;
    }

    public String getPortletTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletTitle(portletId, locale);
    }

    public String getPortletTitle(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)"javax.portlet.title".concat(".").concat(portletId));
    }

    public String getPortletXmlFileName() {
        if (PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML) {
            return "portlet-custom.xml";
        }
        return "portlet.xml";
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (renderRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)renderRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
        if (portletBag == null) {
            return null;
        }
        List preferencesValidatorInstances = portletBag.getPreferencesValidatorInstances();
        if (preferencesValidatorInstances.isEmpty()) {
            return null;
        }
        return (PreferencesValidator)preferencesValidatorInstances.get(0);
    }

    public String getRelativeHomeURL(HttpServletRequest request) throws PortalException {
        Company company = this.getCompany(request);
        String homeURL = company.getHomeURL();
        if (Validator.isNull((String)homeURL)) {
            homeURL = PropsValues.COMPANY_DEFAULT_HOME_URL;
        }
        return homeURL;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle(locale);
    }

    public long getScopeGroupId(HttpServletRequest request) throws PortalException {
        String portletId = this.getPortletId(request);
        return this.getScopeGroupId(request, portletId);
    }

    public long getScopeGroupId(HttpServletRequest request, String portletId) throws PortalException {
        return this.getScopeGroupId(request, portletId, false);
    }

    public long getScopeGroupId(HttpServletRequest request, String portletId, boolean checkStagingGroup) throws PortalException {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = 0L;
        if (layout != null) {
            Group layoutGroup;
            Group group = layout.getGroup();
            long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
            if (doAsGroupId <= 0L) {
                HttpServletRequest originalRequest = this.getOriginalServletRequest(request);
                doAsGroupId = ParamUtil.getLong((HttpServletRequest)originalRequest, (String)"doAsGroupId");
            }
            Group doAsGroup = null;
            if (doAsGroupId > 0L) {
                doAsGroup = GroupLocalServiceUtil.fetchGroup((long)doAsGroupId);
            }
            if (group.isControlPanel()) {
                if (doAsGroupId > 0L) {
                    scopeGroupId = doAsGroupId;
                }
                if ((group = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId)) != null && group.hasStagingGroup()) {
                    try {
                        Group stagingGroup = group.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    }
                    catch (Exception stagingGroup) {}
                }
            } else if (doAsGroup != null) {
                scopeGroupId = doAsGroupId;
            }
            if (group != null && group.isInheritContent() && !(layoutGroup = layout.getGroup()).isControlPanel()) {
                scopeGroupId = group.getParentGroupId();
            }
            if (portletId != null && group != null && (group.isStaged() || group.isStagingGroup())) {
                Group liveGroup = group;
                if (group.isStagingGroup()) {
                    liveGroup = group.getLiveGroup();
                }
                if (liveGroup.isStaged() && !liveGroup.isStagedPortlet(portletId)) {
                    Layout liveGroupLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)liveGroup.getGroupId(), (boolean)layout.isPrivateLayout());
                    if (liveGroupLayout != null && liveGroupLayout.hasScopeGroup()) {
                        scopeGroupId = this._getScopeGroupId(themeDisplay, liveGroupLayout, portletId);
                    } else if (checkStagingGroup && !liveGroup.isStagedRemotely()) {
                        Group stagingGroup = liveGroup.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    } else {
                        scopeGroupId = liveGroup.getGroupId();
                    }
                }
            }
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = this._getScopeGroupId(themeDisplay, layout, portletId);
        }
        return scopeGroupId;
    }

    public long getScopeGroupId(Layout layout) {
        if (layout == null) {
            return 0L;
        }
        return layout.getGroupId();
    }

    public long getScopeGroupId(Layout layout, String portletId) {
        return this._getScopeGroupId(null, layout, portletId);
    }

    public long getScopeGroupId(long plid) {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getScopeGroupId(layout);
    }

    public long getScopeGroupId(PortletRequest portletRequest) throws PortalException {
        return this.getScopeGroupId(this.getHttpServletRequest(portletRequest));
    }

    public User getSelectedUser(HttpServletRequest request) throws PortalException {
        return this.getSelectedUser(request, true);
    }

    public User getSelectedUser(HttpServletRequest request, boolean checkPermission) throws PortalException {
        User user;
        block2: {
            long userId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_u_i_d");
            user = null;
            try {
                user = checkPermission ? UserServiceUtil.getUserById((long)userId) : UserLocalServiceUtil.getUserById((long)userId);
            }
            catch (NoSuchUserException nsue) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)nsue, (Throwable)nsue);
            }
        }
        return user;
    }

    public User getSelectedUser(PortletRequest portletRequest) throws PortalException {
        return this.getSelectedUser(portletRequest, true);
    }

    public User getSelectedUser(PortletRequest portletRequest, boolean checkPermission) throws PortalException {
        return this.getSelectedUser(this.getHttpServletRequest(portletRequest), checkPermission);
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public long[] getSharedContentSiteGroupIds(long companyId, long groupId, long userId) throws PortalException {
        int sitesContentSharingWithChildrenEnabled;
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.doGetCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
            groups.addAll(siteGroup.getDescendants(true));
            groups.addAll(GroupLocalServiceUtil.getGroups((long)siteGroup.getCompanyId(), (String)Layout.class.getName(), (long)siteGroup.getGroupId()));
        }
        if (PrefsPropsUtil.getBoolean(companyId, "sites.content.sharing.through.administrators.enabled")) {
            groups.addAll(GroupLocalServiceUtil.getUserSitesGroups((long)userId));
        }
        if ((sitesContentSharingWithChildrenEnabled = PrefsPropsUtil.getInteger(companyId, "sites.content.sharing.with.children.enabled")) != 0) {
            groups.addAll(this.doGetAncestorSiteGroups(groupId, true));
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (StagingUtil.isGroupAccessible((Group)group, (Group)siteGroup)) continue;
            iterator.remove();
        }
        long[] groupIds = new long[groups.size()];
        int i = 0;
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    @Deprecated
    public PortletURL getSiteAdministrationURL(HttpServletRequest request, ThemeDisplay themeDisplay, String portletId) {
        PortletURL portletURL = this.getControlPanelPortletURL(request, portletId, "RENDER_PHASE");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        return portletURL;
    }

    @Deprecated
    public PortletURL getSiteAdministrationURL(PortletResponse portletResponse, ThemeDisplay themeDisplay, String portletName) {
        LiferayPortletResponse liferayPortletResponse = this.getLiferayPortletResponse(portletResponse);
        LiferayPortletURL siteAdministrationURL = liferayPortletResponse.createRenderURL(portletName);
        siteAdministrationURL.setDoAsGroupId(themeDisplay.getScopeGroupId());
        siteAdministrationURL.setParameter("redirect", themeDisplay.getURLCurrent());
        return siteAdministrationURL;
    }

    @Deprecated
    public String getSiteAdminURL(Company company, Group group, String ppid, Map<String, String[]> params) throws PortalException {
        return this._getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), group, ppid, params);
    }

    @Deprecated
    public String getSiteAdminURL(Group group, String ppid, Map<String, String[]> params) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        return this._getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), group, ppid, params);
    }

    public String getSiteAdminURL(ThemeDisplay themeDisplay, String ppid, Map<String, String[]> params) throws PortalException {
        return this._getSiteAdminURL(themeDisplay.getPortalURL(), themeDisplay.getScopeGroup(), ppid, params);
    }

    @Deprecated
    public long[] getSiteAndCompanyGroupIds(long groupId) throws PortalException {
        Group scopeGroup = GroupLocalServiceUtil.getGroup((long)groupId);
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)scopeGroup.getCompanyId());
        if (scopeGroup.isLayout()) {
            return new long[]{groupId, scopeGroup.getParentGroupId(), companyGroup.getGroupId()};
        }
        if (scopeGroup.isLayoutSetPrototype() || scopeGroup.isOrganization() || scopeGroup.isRegularSite() || scopeGroup.isUser()) {
            return new long[]{groupId, companyGroup.getGroupId()};
        }
        return new long[]{companyGroup.getGroupId()};
    }

    @Deprecated
    public long[] getSiteAndCompanyGroupIds(ThemeDisplay themeDisplay) throws PortalException {
        return this.getSiteAndCompanyGroupIds(themeDisplay.getScopeGroupId());
    }

    public Locale getSiteDefaultLocale(long groupId) throws PortalException {
        Group group;
        if (groupId <= 0L) {
            return LocaleUtil.getDefault();
        }
        Group liveGroup = group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            liveGroup = group.getLiveGroup();
        }
        if (LanguageUtil.isInheritLocales((long)liveGroup.getGroupId())) {
            return LocaleUtil.getDefault();
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        User defaultUser = UserLocalServiceUtil.getDefaultUser((long)group.getCompanyId());
        String languageId = GetterUtil.getString((String)typeSettingsProperties.getProperty("languageId"), (String)defaultUser.getLanguageId());
        return LocaleUtil.fromLanguageId((String)languageId);
    }

    public long getSiteGroupId(long groupId) {
        Group group = this._getSiteGroup(groupId);
        if (group == null) {
            return 0L;
        }
        return group.getGroupId();
    }

    public String getSiteLoginURL(ThemeDisplay themeDisplay) throws PortalException {
        if (Validator.isNull((String)PropsValues.AUTH_LOGIN_SITE_URL)) {
            return null;
        }
        List layouts = themeDisplay.getUnfilteredLayouts();
        if (layouts == null) {
            return null;
        }
        for (Layout layout : layouts) {
            String friendlyURL = themeDisplay.getLayoutFriendlyURL(layout);
            if (!friendlyURL.equals(PropsValues.AUTH_LOGIN_SITE_URL)) continue;
            if (themeDisplay.getLayout() == null) break;
            String layoutSetFriendlyURL = this.getLayoutSetFriendlyURL(layout.getLayoutSet(), themeDisplay);
            return layoutSetFriendlyURL + PropsValues.AUTH_LOGIN_SITE_URL;
        }
        return null;
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri) {
        return this.getStaticResourceURL(request, uri, null, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, long timestamp) {
        return this.getStaticResourceURL(request, uri, null, timestamp);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString) {
        return this.getStaticResourceURL(request, uri, queryString, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest request, String uri, String queryString, long timestamp) {
        if (uri.indexOf(63) != -1) {
            return uri;
        }
        if (uri.startsWith("//")) {
            uri = uri.substring(1);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        ColorScheme colorScheme = themeDisplay.getColorScheme();
        Map parameterMap = null;
        if (Validator.isNotNull((String)queryString)) {
            parameterMap = HttpUtil.getParameterMap((String)queryString);
        }
        StringBundler sb = new StringBundler(18);
        sb.append(uri);
        boolean firstParam = true;
        if (parameterMap == null || !parameterMap.containsKey("browserId")) {
            sb.append("?browserId=");
            sb.append(BrowserSnifferUtil.getBrowserId((HttpServletRequest)request));
            firstParam = false;
        }
        if (!(!uri.endsWith(".css") && !uri.endsWith(".jsp") || parameterMap != null && parameterMap.containsKey("themeId"))) {
            if (firstParam) {
                sb.append("?themeId=");
                firstParam = false;
            } else {
                sb.append("&themeId=");
            }
            sb.append(URLCodec.encodeURL((String)theme.getThemeId()));
        }
        if (uri.endsWith(".jsp") && (parameterMap == null || !parameterMap.containsKey("colorSchemeId"))) {
            if (firstParam) {
                sb.append("?colorSchemeId=");
                firstParam = false;
            } else {
                sb.append("&colorSchemeId=");
            }
            sb.append(URLCodec.encodeURL((String)colorScheme.getColorSchemeId()));
        }
        if (parameterMap == null || !parameterMap.containsKey("minifierType")) {
            String minifierType = "";
            if (uri.endsWith(".css") || uri.endsWith("css.jsp") || uri.endsWith(".jsp") && uri.contains("/css/")) {
                if (themeDisplay.isThemeCssFastLoad()) {
                    minifierType = "css";
                }
            } else if (themeDisplay.isThemeJsFastLoad()) {
                minifierType = "js";
            }
            if (Validator.isNotNull((String)minifierType)) {
                if (firstParam) {
                    sb.append("?minifierType=");
                    firstParam = false;
                } else {
                    sb.append("&minifierType=");
                }
                sb.append(minifierType);
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            if (queryString.charAt(0) == '&') {
                if (firstParam) {
                    sb.append("?");
                    sb.append(queryString.substring(1));
                } else {
                    sb.append(queryString);
                }
            } else if (firstParam) {
                sb.append("?");
                sb.append(queryString);
            } else {
                sb.append("&");
                sb.append(queryString);
            }
            firstParam = false;
        }
        if (firstParam) {
            sb.append("?languageId=");
        } else {
            sb.append("&languageId=");
        }
        sb.append(themeDisplay.getLanguageId());
        sb.append("&b=");
        sb.append(ReleaseInfo.getBuildNumber());
        if (!(parameterMap != null && parameterMap.containsKey("t") || timestamp < 0L)) {
            if (timestamp == 0L) {
                String portalURL = this.getPortalURL(request);
                String path = uri;
                if (uri.startsWith(portalURL)) {
                    path = uri.substring(portalURL.length());
                }
                if (path.startsWith("/html")) {
                    ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
                    timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext, (String)path, (boolean)true);
                } else {
                    timestamp = PortalWebResourcesUtil.getPathLastModified((String)path, (long)theme.getTimestamp());
                }
            }
            sb.append("&t=");
            sb.append(timestamp);
        }
        return sb.toString();
    }

    public String getStrutsAction(HttpServletRequest request) {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        if (Validator.isNotNull((String)strutsAction)) {
            return "";
        }
        return this.getPortletParam(request, "struts_action");
    }

    public String[] getSystemGroups() {
        return this._allSystemGroups;
    }

    public String[] getSystemOrganizationRoles() {
        return this._allSystemOrganizationRoles;
    }

    public String[] getSystemRoles() {
        return this._allSystemRoles;
    }

    public String[] getSystemSiteRoles() {
        return this._allSystemSiteRoles;
    }

    public String getUniqueElementId(HttpServletRequest request, String namespace, String elementId) {
        String uniqueElementId = elementId;
        Set uniqueElementIds = (Set)request.getAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS");
        if (uniqueElementIds == null) {
            uniqueElementIds = Collections.newSetFromMap(new ConcurrentHashMap());
            request.setAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS", uniqueElementIds);
        } else {
            int i = 1;
            while (uniqueElementIds.contains(namespace.concat(uniqueElementId))) {
                uniqueElementId = Validator.isNull((String)elementId) || elementId.endsWith("_") ? elementId.concat(String.valueOf(i)) : elementId.concat("_").concat(String.valueOf(i));
                ++i;
            }
        }
        uniqueElementIds.add(namespace.concat(uniqueElementId));
        return uniqueElementId;
    }

    public String getUniqueElementId(PortletRequest request, String namespace, String elementId) {
        return this.getUniqueElementId(this.getHttpServletRequest(request), namespace, elementId);
    }

    public UploadPortletRequest getUploadPortletRequest(PortletRequest portletRequest) {
        PortletRequestImpl portletRequestImpl = PortletRequestImpl.getPortletRequestImpl(portletRequest);
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)portletRequestImpl.getHttpServletRequest();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)dynamicRequest.getRequest();
        UploadServletRequest uploadServletRequest = this.getUploadServletRequest((HttpServletRequest)requestWrapper);
        return new UploadPortletRequestImpl(uploadServletRequest, (PortletRequest)portletRequestImpl, this.getPortletNamespace(portletRequestImpl.getPortletName()));
    }

    public UploadServletRequest getUploadServletRequest(HttpServletRequest request) {
        ArrayList<PersistentHttpServletRequestWrapper> persistentHttpServletRequestWrappers = new ArrayList<PersistentHttpServletRequestWrapper>();
        HttpServletRequest currentRequest = request;
        while (currentRequest instanceof HttpServletRequestWrapper) {
            if (currentRequest instanceof UploadServletRequest) {
                return (UploadServletRequest)currentRequest;
            }
            Class<?> currentRequestClass = currentRequest.getClass();
            String currentRequestClassName = currentRequestClass.getName();
            if (!this.isUnwrapRequest(currentRequestClassName)) break;
            if (currentRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentRequest;
                persistentHttpServletRequestWrappers.add(persistentHttpServletRequestWrapper.clone());
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentRequest;
            currentRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (ServerDetector.isWebLogic()) {
            currentRequest = new NonSerializableObjectRequestWrapper(currentRequest);
        }
        for (int i = persistentHttpServletRequestWrappers.size() - 1; i >= 0; --i) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)persistentHttpServletRequestWrappers.get(i);
            httpServletRequestWrapper.setRequest((ServletRequest)currentRequest);
            currentRequest = httpServletRequestWrapper;
        }
        return new UploadServletRequestImpl(currentRequest);
    }

    public Date getUptime() {
        return _upTime;
    }

    public String getURLWithSessionId(String url, String sessionId) {
        int y;
        StringBundler sb;
        HttpSession httpSession;
        if (!PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID) {
            return url;
        }
        if (Validator.isNull((String)url)) {
            return url;
        }
        int x = url.indexOf(59);
        if (x != -1) {
            return url;
        }
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && (httpSession = PortalSessionContext.get((String)sessionId)) != null) {
            while (httpSession instanceof HttpSessionWrapper) {
                HttpSessionWrapper httpSessionWrapper = (HttpSessionWrapper)httpSession;
                httpSession = httpSessionWrapper.getWrappedSession();
            }
            sessionId = httpSession.getId();
        }
        if ((x = url.indexOf(63)) != -1) {
            sb = new StringBundler(4);
            sb.append(url.substring(0, x));
            sb.append(";jsessionid=");
            sb.append(sessionId);
            sb.append(url.substring(x));
            return sb.toString();
        }
        x = url.indexOf("//");
        sb = new StringBundler(4);
        sb.append(url);
        if (x != -1 && x + 1 == (y = url.lastIndexOf(47))) {
            sb.append("/");
        }
        sb.append(";jsessionid=");
        sb.append(sessionId);
        return sb.toString();
    }

    public User getUser(HttpServletRequest request) throws PortalException {
        Cookie[] cookies;
        User user = (User)request.getAttribute("USER");
        if (user != null) {
            return user;
        }
        long userId = this.getUserId(request);
        if (userId <= 0L) {
            String remoteUser = request.getRemoteUser();
            if (remoteUser == null && !PropsValues.PORTAL_JAAS_ENABLE) {
                HttpSession session = request.getSession();
                remoteUser = (String)session.getAttribute("j_remoteuser");
            }
            if (remoteUser == null) {
                return null;
            }
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                long companyId = this.getCompanyId(request);
                try {
                    userId = JAASHelper.getJaasUserId(companyId, remoteUser);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                }
            } else {
                userId = GetterUtil.getLong((String)remoteUser);
            }
        }
        if (userId > 0L) {
            user = UserLocalServiceUtil.getUserById((long)userId);
            request.setAttribute("USER", (Object)user);
        }
        if ((cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!cookieName.startsWith("REMOTE_PREFERENCE_")) continue;
                user.addRemotePreference((RemotePreference)new CookieRemotePreference(cookie));
            }
        }
        return user;
    }

    public User getUser(PortletRequest portletRequest) throws PortalException {
        return this.getUser(this.getHttpServletRequest(portletRequest));
    }

    public String getUserEmailAddress(long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return user.getEmailAddress();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return "";
        }
    }

    public long getUserId(HttpServletRequest request) {
        HttpSession session;
        Long userIdObj = (Long)request.getAttribute("USER_ID");
        if (userIdObj != null) {
            return userIdObj;
        }
        String doAsUserIdString = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId", null);
        if (doAsUserIdString != null) {
            String actionName = this.getPortletParam(request, "actionName");
            String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
            String path = GetterUtil.getString((String)request.getPathInfo());
            String strutsAction = this.getStrutsAction(request);
            boolean alwaysAllowDoAsUser = false;
            if (actionName.equals("addFile") || mvcRenderCommandName.equals("/document_library/edit_file_entry") || path.equals("/portal/session_click") || this.isAlwaysAllowDoAsUser(actionName, mvcRenderCommandName, path, strutsAction)) {
                try {
                    alwaysAllowDoAsUser = this.isAlwaysAllowDoAsUser(request);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            if (!PropsValues.PORTAL_JAAS_ENABLE && PropsValues.PORTAL_IMPERSONATION_ENABLE || alwaysAllowDoAsUser) {
                try {
                    long doAsUserId = this.getDoAsUserId(request, doAsUserIdString, alwaysAllowDoAsUser);
                    if (doAsUserId > 0L) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Impersonating user " + doAsUserId));
                        }
                        return doAsUserId;
                    }
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to impersonate user " + doAsUserIdString), (Throwable)e);
                }
            }
        }
        if ((userIdObj = (Long)(session = request.getSession()).getAttribute("USER_ID")) != null) {
            request.setAttribute("USER_ID", (Object)userIdObj);
            return userIdObj;
        }
        return 0L;
    }

    public long getUserId(PortletRequest portletRequest) {
        return this.getUserId(this.getHttpServletRequest(portletRequest));
    }

    public String getUserName(BaseModel<?> baseModel) {
        long userId = 0L;
        String userName = "";
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)baseModel;
            userId = auditedModel.getUserId();
            userName = auditedModel.getUserName();
        } else {
            userId = BeanPropertiesUtil.getLongSilent(baseModel, (String)"userId");
            userName = BeanPropertiesUtil.getStringSilent(baseModel, (String)"userName");
        }
        if (userId == 0L) {
            return "";
        }
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.unescape((String)userName);
        }
        userName = this.getUserName(userId, userName);
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.escape((String)userName);
        }
        return userName;
    }

    public String getUserName(long userId, String defaultUserName) {
        return this.getUserName(userId, defaultUserName, "user.name.full");
    }

    public String getUserName(long userId, String defaultUserName, HttpServletRequest request) {
        return this.getUserName(userId, defaultUserName, "user.name.full", request);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute) {
        return this.getUserName(userId, defaultUserName, userAttribute, null);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute, HttpServletRequest request) {
        String userName = defaultUserName;
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            userName = userAttribute.equals("user.name.full") ? user.getFullName() : user.getScreenName();
            if (request != null) {
                Layout layout = (Layout)request.getAttribute("LAYOUT");
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_directory_web_portlet_DirectoryPortlet", (Layout)layout, (String)"RENDER_PHASE");
                portletURL.setParameter("struts_action", "/directory/view_user");
                portletURL.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
                portletURL.setPortletMode(PortletMode.VIEW);
                portletURL.setWindowState(WindowState.MAXIMIZED);
                userName = StringBundler.concat((String[])new String[]{"<a href=\"", portletURL.toString(), "\">", HtmlUtil.escape((String)userName), "</a>"});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userName;
    }

    public String getUserPassword(HttpServletRequest request) {
        request = this.getOriginalServletRequest(request);
        HttpSession session = request.getSession();
        return this.getUserPassword(session);
    }

    public String getUserPassword(HttpSession session) {
        return (String)session.getAttribute("USER_PASSWORD");
    }

    public String getUserPassword(PortletRequest portletRequest) {
        return this.getUserPassword(this.getHttpServletRequest(portletRequest));
    }

    @Deprecated
    public String getUserValue(long userId, String param, String defaultValue) {
        if (Validator.isNotNull((String)defaultValue)) {
            return defaultValue;
        }
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return BeanPropertiesUtil.getString((Object)user, (String)param, (String)defaultValue);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return "";
        }
    }

    public String getValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return domain;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase((String)domain, (String)virtualHost) && !StringUtil.wildcardMatches((String)domain, (String)virtualHost, (char)'?', (char)'*', (char)'%', (boolean)false)) continue;
            return domain;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Set the property \"", "virtual.hosts.valid.hosts", "\" in portal.properties to allow \"", domain, "\" as a domain"}));
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getDefaultCompanyId());
            return company.getVirtualHostname();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to load default portal instance", (Throwable)e);
            return _LOCALHOST;
        }
    }

    public long getValidUserId(long companyId, long userId) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)userId);
        if (user == null) {
            return UserLocalServiceUtil.getDefaultUserId((long)companyId);
        }
        if (user.getCompanyId() == companyId) {
            return user.getUserId();
        }
        return userId;
    }

    public String getVirtualHostname(LayoutSet layoutSet) {
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname)) {
            virtualHostname = layoutSet.getCompanyFallbackVirtualHostname();
        }
        return virtualHostname;
    }

    @Deprecated
    public String getVirtualLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)"/~");
        if (friendlyURLResolver == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        long companyId = PortalInstances.getCompanyId(request);
        return friendlyURLResolver.getActualURL(companyId, groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
    }

    @Deprecated
    public LayoutFriendlyURLComposite getVirtualLayoutFriendlyURLComposite(boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)"/~");
        if (friendlyURLResolver == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        long companyId = PortalInstances.getCompanyId(request);
        return friendlyURLResolver.getLayoutFriendlyURLComposite(companyId, 0L, privateLayout, friendlyURL, params, requestContext);
    }

    public String getWidgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.WIDGET_SERVLET_MAPPING, themeDisplay);
    }

    public void initCustomSQL() {
        this._customSqlKeys = new String[]{"[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.GROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.LAYOUT$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ORGANIZATION$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ROLE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.TEAM$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USERGROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFILEENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFOLDER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.MESSAGEBOARDS.MODEL.MBMESSAGE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.MESSAGEBOARDS.MODEL.MBTHREAD$]", "[$RESOURCE_SCOPE_COMPANY$]", "[$RESOURCE_SCOPE_GROUP$]", "[$RESOURCE_SCOPE_GROUP_TEMPLATE$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$SOCIAL_RELATION_TYPE_BI_COWORKER$]", "[$SOCIAL_RELATION_TYPE_BI_FRIEND$]", "[$SOCIAL_RELATION_TYPE_BI_ROMANTIC_PARTNER$]", "[$SOCIAL_RELATION_TYPE_BI_SIBLING$]", "[$SOCIAL_RELATION_TYPE_BI_SPOUSE$]", "[$SOCIAL_RELATION_TYPE_UNI_CHILD$]", "[$SOCIAL_RELATION_TYPE_UNI_ENEMY$]", "[$SOCIAL_RELATION_TYPE_UNI_FOLLOWER$]", "[$SOCIAL_RELATION_TYPE_UNI_PARENT$]", "[$SOCIAL_RELATION_TYPE_UNI_SUBORDINATE$]", "[$SOCIAL_RELATION_TYPE_UNI_SUPERVISOR$]", "[$FALSE$]", "[$TRUE$]"};
        DB db = DBManagerUtil.getDB();
        Object[] customSqlValues = new Object[]{this.getClassNameId(Group.class), this.getClassNameId(Layout.class), this.getClassNameId(Organization.class), this.getClassNameId(Role.class), this.getClassNameId(Team.class), this.getClassNameId(User.class), this.getClassNameId(UserGroup.class), this.getClassNameId(DLFileEntry.class), this.getClassNameId(DLFolder.class), this.getClassNameId(MBMessage.class), this.getClassNameId(MBThread.class), 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 9, 8, 7, 10, 11, db.getTemplateFalse(), db.getTemplateTrue()};
        this._customSqlValues = ArrayUtil.toStringArray((Object[])customSqlValues);
    }

    public User initUser(HttpServletRequest request) throws Exception {
        User user = null;
        try {
            user = this.getUser(request);
        }
        catch (NoSuchUserException nsue) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsue.getMessage());
            }
            if ((userId = this.getUserId(request)) > 0L) {
                HttpSession session = request.getSession();
                session.invalidate();
            }
            throw nsue;
        }
        if (user != null) {
            return user;
        }
        Company company = this.getCompany(request);
        return company.getDefaultUser();
    }

    @Deprecated
    public void invokeTaglibDiscussion(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this._editDiscussionStrutsAction.execute(this.getHttpServletRequest((PortletRequest)actionRequest), this.getHttpServletResponse((PortletResponse)actionResponse));
    }

    @Deprecated
    public void invokeTaglibDiscussionPagination(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        try {
            this._getCommentsStrutsAction.execute(this.getHttpServletRequest((PortletRequest)resourceRequest), this.getHttpServletResponse((PortletResponse)resourceResponse));
        }
        catch (IOException | RuntimeException | PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public boolean isCDNDynamicResourcesEnabled(HttpServletRequest request) throws PortalException {
        Company company = this.getCompany(request);
        return this.isCDNDynamicResourcesEnabled(company.getCompanyId());
    }

    public boolean isCDNDynamicResourcesEnabled(long companyId) {
        try {
            return PrefsPropsUtil.getBoolean(companyId, "cdn.dynamic.resources.enabled", PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED);
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)se, (Throwable)se);
            }
            return PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED;
        }
    }

    public boolean isCompanyAdmin(User user) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isCompanyAdmin();
    }

    public boolean isCompanyControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, category, themeDisplay);
    }

    public boolean isCompanyControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, themeDisplay);
    }

    public boolean isControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (controlPanelEntryCategory.equals(category) || category.endsWith(".") && StringUtil.startsWith((String)controlPanelEntryCategory, (String)category)) {
            return this.isControlPanelPortlet(portletId, themeDisplay);
        }
        return false;
    }

    public boolean isControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) {
        try {
            return PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId);
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to check control panel access permission", (Throwable)pe);
            }
            return false;
        }
    }

    public boolean isForwardedSecure(HttpServletRequest request) {
        String forwardedProtocol;
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED && Validator.isNotNull((String)(forwardedProtocol = request.getHeader(PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_HEADER))) && Objects.equals("https", forwardedProtocol)) {
            return true;
        }
        return request.isSecure();
    }

    public boolean isGroupAdmin(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupAdmin(groupId);
    }

    public boolean isGroupFriendlyURL(String fullURL, String groupFriendlyURL, String layoutFriendlyURL) {
        return fullURL.endsWith(groupFriendlyURL) && !fullURL.endsWith(groupFriendlyURL.concat(layoutFriendlyURL));
    }

    public boolean isGroupOwner(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupOwner(groupId);
    }

    public boolean isLayoutDescendant(Layout layout, long layoutId) throws PortalException {
        if (layout.getLayoutId() == layoutId) {
            return true;
        }
        for (Layout childLayout : layout.getChildren()) {
            if (!this.isLayoutDescendant(childLayout, layoutId)) continue;
            return true;
        }
        return false;
    }

    public boolean isLayoutSitemapable(Layout layout) {
        if (layout.isPrivateLayout()) {
            return false;
        }
        LayoutType layoutType = layout.getLayoutType();
        return layoutType.isSitemapable();
    }

    public boolean isLoginRedirectRequired(HttpServletRequest request) {
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !request.isSecure()) {
            return true;
        }
        long companyId = this.getCompanyId(request);
        return SSOUtil.isLoginRedirectRequired(companyId);
    }

    public boolean isMethodGet(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return StringUtil.equalsIgnoreCase((String)method, (String)"GET");
    }

    public boolean isMethodPost(PortletRequest portletRequest) {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)request.getMethod());
        return StringUtil.equalsIgnoreCase((String)method, (String)"POST");
    }

    public boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public boolean isOmniadmin(long userId) {
        return OmniadminUtil.isOmniadmin(userId);
    }

    public boolean isOmniadmin(User user) {
        return OmniadminUtil.isOmniadmin(user);
    }

    public boolean isReservedParameter(String name) {
        return this._reservedParams.contains(name);
    }

    public boolean isRightToLeft(HttpServletRequest request) {
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String langDir = LanguageUtil.get((Locale)locale, (String)"lang.dir");
        return langDir.equals("rtl");
    }

    public boolean isRSSFeedsEnabled() {
        return PropsValues.RSS_FEEDS_ENABLED;
    }

    public boolean isSecure(HttpServletRequest request) {
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED) {
            return this.isForwardedSecure(request);
        }
        if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            return request.isSecure();
        }
        HttpSession session = request.getSession();
        if (session == null) {
            return request.isSecure();
        }
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null || httpsInitial.booleanValue()) {
            return request.isSecure();
        }
        return false;
    }

    public boolean isSkipPortletContentProcessing(Group group, HttpServletRequest httpServletRequest, LayoutTypePortlet layoutTypePortlet, PortletDisplay portletDisplay, String portletName) throws Exception {
        ServletContext servletContext;
        boolean skipPortletContentRendering = this.isSkipPortletContentRendering(group, layoutTypePortlet, portletDisplay, portletName);
        if (!skipPortletContentRendering) {
            return false;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)group.getCompanyId(), (String)portletDisplay.getId());
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)(servletContext = (ServletContext)httpServletRequest.getAttribute("CTX")));
        return !invokerPortlet.isStrutsBridgePortlet() && !invokerPortlet.isStrutsPortlet();
    }

    public boolean isSkipPortletContentRendering(Group group, LayoutTypePortlet layoutTypePortlet, PortletDisplay portletDisplay, String portletName) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)group.getCompanyId(), (String)portletDisplay.getId());
        if (portlet.isSystem()) {
            return false;
        }
        return group.isLayoutPrototype() && layoutTypePortlet.hasPortletId(portletDisplay.getId()) && portletDisplay.isModeView() && !portletName.equals("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet");
    }

    public boolean isSystemGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemGroups, groupName = groupName.trim(), new StringComparator());
        return pos >= 0;
    }

    public boolean isSystemRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemRoles, roleName = roleName.trim(), new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemSiteRoles, roleName, new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemOrganizationRoles, roleName, new StringComparator());
        return pos >= 0;
    }

    public boolean isUpdateAvailable() {
        return PluginPackageUtil.isUpdateAvailable();
    }

    public boolean isValidResourceId(String resourceId) {
        if (Validator.isNull((String)resourceId)) {
            return true;
        }
        Matcher matcher = this._bannedResourceIdPattern.matcher(resourceId);
        return !matcher.matches();
    }

    public boolean removePortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.remove(portalInetSocketAddressEventListener);
    }

    @Deprecated
    public void removePortalPortEventListener(PortalPortEventListener portalPortEventListener) {
        this._portalPortEventListeners.remove(portalPortEventListener);
    }

    public void resetCDNHosts() {
        _cdnHostHttpMap.clear();
        _cdnHostHttpsMap.clear();
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)_resetCDNHostsMethodHandler, (boolean)true);
        try {
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to clear cluster wide CDN hosts", (Throwable)e);
        }
    }

    public String resetPortletParameters(String url, String portletId) {
        if (Validator.isNull((String)url) || Validator.isNull((String)portletId)) {
            return url;
        }
        String portletNamespace = this.getPortletNamespace(portletId);
        Map parameterMap = HttpUtil.getParameterMap((String)url);
        for (String name : parameterMap.keySet()) {
            if (!name.startsWith(portletNamespace)) continue;
            url = HttpUtil.removeParameter((String)url, (String)name);
        }
        return url;
    }

    public void sendError(Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendError(0, e, actionRequest, actionResponse);
    }

    public void sendError(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.sendError(0, e, request, response);
    }

    public void sendError(int status, Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StringBundler sb = new StringBundler(7);
        sb.append(this._pathMain);
        sb.append("/portal/status?status=");
        sb.append(status);
        sb.append("&exception=");
        Class<?> clazz = e.getClass();
        sb.append(clazz.getName());
        sb.append("&previousURL=");
        sb.append(URLCodec.encodeURL((String)this.getCurrentURL((PortletRequest)actionRequest)));
        actionResponse.sendRedirect(sb.toString());
    }

    public void sendError(int status, Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            String currentURL = (String)request.getAttribute("CURRENT_URL");
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Current URL ", currentURL, " generates exception: ", e.getMessage()}));
        }
        if (e instanceof NoSuchImageException) {
            if (_logWebServerServlet.isWarnEnabled()) {
                _logWebServerServlet.warn((Object)e, (Throwable)e);
            }
        } else if (e instanceof PortalException && _log.isDebugEnabled()) {
            if (e instanceof NoSuchLayoutException || e instanceof PrincipalException) {
                String msg = e.getMessage();
                if (Validator.isNotNull((String)msg)) {
                    _log.debug((Object)msg);
                }
            } else {
                _log.debug((Object)e, (Throwable)e);
            }
        } else if (e instanceof SystemException && _log.isWarnEnabled()) {
            _log.warn((Object)e, (Throwable)e);
        }
        if (response.isCommitted()) {
            return;
        }
        if (status == 0) {
            if (e instanceof PrincipalException) {
                status = 403;
            } else {
                Class<?> clazz = e.getClass();
                String name = clazz.getName();
                if ((name = name.substring(name.lastIndexOf(46) + 1)).startsWith("NoSuch") && name.endsWith("Exception")) {
                    status = 404;
                }
            }
            if (status == 0) {
                status = 400;
            }
        }
        String redirect = null;
        if (e instanceof NoSuchGroupException && Validator.isNotNull((String)PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND;
        } else if (e instanceof NoSuchLayoutException && Validator.isNotNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND;
        } else if (PropsValues.LAYOUT_SHOW_HTTP_STATUS) {
            redirect = "/c/portal/status";
        }
        if (Objects.equals(redirect, request.getRequestURI())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to redirect to missing URI: " + redirect));
            }
            redirect = null;
        }
        if (Validator.isNotNull((String)redirect)) {
            HttpSession session = PortalSessionThreadLocal.getHttpSession();
            if (session == null) {
                session = request.getSession();
            }
            response.setStatus(status);
            SessionErrors.add((HttpSession)session, e.getClass(), (Object)e);
            ServletContext servletContext = session.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (e != null) {
            response.sendError(status, e.getMessage());
        } else {
            String currentURL = (String)request.getAttribute("CURRENT_URL");
            response.sendError(status, "Current URL " + currentURL);
        }
    }

    public void sendRSSFeedsDisabledError(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.sendError(404, (Exception)new RSSFeedException(), request, response);
    }

    public void sendRSSFeedsDisabledError(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ServletException {
        HttpServletRequest request = this.getHttpServletRequest(portletRequest);
        HttpServletResponse response = this.getHttpServletResponse(portletResponse);
        this.sendRSSFeedsDisabledError(request, response);
    }

    public void setPageDescription(String description, HttpServletRequest request) {
        ListMergeable descriptionListMergeable = new ListMergeable();
        descriptionListMergeable.add((Object)description);
        request.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
    }

    public void setPageKeywords(String keywords, HttpServletRequest request) {
        request.removeAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        this.addPageKeywords(keywords, request);
    }

    public void setPageSubtitle(String subtitle, HttpServletRequest request) {
        ListMergeable subtitleListMergeable = new ListMergeable();
        subtitleListMergeable.add((Object)subtitle);
        request.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
    }

    public void setPageTitle(String title, HttpServletRequest request) {
        ListMergeable titleListMergeable = new ListMergeable();
        titleListMergeable.add((Object)title);
        request.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
    }

    public void setPortalInetSocketAddresses(HttpServletRequest request) {
        boolean secure = request.isSecure();
        if (secure && this._securePortalLocalInetSocketAddress.get() != null && this._securePortalServerInetSocketAddress.get() != null || !secure && this._portalLocalInetSocketAddress.get() != null && this._portalServerInetSocketAddress.get() != null) {
            return;
        }
        InetAddress localInetAddress = null;
        InetAddress serverInetAddress = null;
        try {
            localInetAddress = InetAddress.getByName(request.getLocalAddr());
            serverInetAddress = InetAddress.getByName(request.getServerName());
        }
        catch (UnknownHostException uhe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to resolve portal host", (Throwable)uhe);
            }
            return;
        }
        InetSocketAddress localInetSocketAddress = new InetSocketAddress(localInetAddress, request.getLocalPort());
        InetSocketAddress serverInetSocketAddress = new InetSocketAddress(serverInetAddress, request.getServerPort());
        if (secure) {
            if (this._securePortalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, true);
            }
            if (this._securePortalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, true);
            }
        } else {
            if (this._portalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, false);
            }
            if (this._portalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, false);
            }
        }
    }

    @Deprecated
    public void setPortalPort(HttpServletRequest request) {
        int portalPort;
        if (request.isSecure()) {
            int securePortalPort;
            if (this._securePortalPort.get() == -1 && this._securePortalPort.compareAndSet(-1, securePortalPort = request.getServerPort()) && StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)) {
                this.notifyPortalPortEventListeners(securePortalPort);
            }
        } else if (this._portalPort.get() == -1 && this._portalPort.compareAndSet(-1, portalPort = request.getServerPort())) {
            this.notifyPortalPortEventListeners(portalPort);
        }
    }

    public void storePreferences(PortletPreferences portletPreferences) throws IOException, ValidatorException {
        PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
        PortletPreferencesImpl portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        portletPreferencesImpl.store();
    }

    public String[] stripURLAnchor(String url, String separator) {
        String anchor = "";
        int pos = url.indexOf(separator);
        if (pos != -1) {
            anchor = url.substring(pos);
            url = url.substring(0, pos);
        }
        return new String[]{url, anchor};
    }

    public String transformCustomSQL(String sql) {
        if (this._customSqlKeys == null || this._customSqlValues == null) {
            this.initCustomSQL();
        }
        return StringUtil.replace((String)sql, (String[])this._customSqlKeys, (String[])this._customSqlValues);
    }

    public String transformSQL(String sql) {
        return SQLTransformer.transform(sql);
    }

    public void updateImageId(BaseModel<?> baseModel, boolean hasImage, byte[] bytes, String fieldName, long maxSize, int maxHeight, int maxWidth) throws PortalException {
        long imageId = BeanPropertiesUtil.getLong(baseModel, (String)fieldName);
        if (!hasImage) {
            if (imageId > 0L) {
                ImageLocalServiceUtil.deleteImage((long)imageId);
                BeanPropertiesUtil.setProperty(baseModel, (String)fieldName, (Object)0);
            }
            return;
        }
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return;
        }
        if (maxSize > 0L && (long)bytes.length > maxSize) {
            throw new ImageSizeException();
        }
        if (maxHeight > 0 || maxWidth > 0) {
            try {
                ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                if (renderedImage == null) {
                    throw new ImageTypeException();
                }
                renderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)maxHeight, (int)maxWidth);
                bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
            }
            catch (IOException ioe) {
                throw new ImageSizeException((Throwable)ioe);
            }
        }
        Image image = ImageLocalServiceUtil.moveImage((long)imageId, (byte[])bytes);
        BeanPropertiesUtil.setProperty(baseModel, (String)fieldName, (Object)image.getImageId());
    }

    public PortletMode updatePortletMode(String portletId, User user, Layout layout, PortletMode portletMode, HttpServletRequest request) throws PortalException {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            if (layoutType.hasModeAboutPortletId(portletId)) {
                return LiferayPortletMode.ABOUT;
            }
            if (layoutType.hasModeConfigPortletId(portletId)) {
                return LiferayPortletMode.CONFIG;
            }
            if (layoutType.hasModeEditPortletId(portletId)) {
                return PortletMode.EDIT;
            }
            if (layoutType.hasModeEditDefaultsPortletId(portletId)) {
                return LiferayPortletMode.EDIT_DEFAULTS;
            }
            if (layoutType.hasModeEditGuestPortletId(portletId)) {
                return LiferayPortletMode.EDIT_GUEST;
            }
            if (layoutType.hasModeHelpPortletId(portletId)) {
                return PortletMode.HELP;
            }
            if (layoutType.hasModePreviewPortletId(portletId)) {
                return LiferayPortletMode.PREVIEW;
            }
            if (layoutType.hasModePrintPortletId(portletId)) {
                return LiferayPortletMode.PRINT;
            }
            return PortletMode.VIEW;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(request), (String)portletId);
        boolean updateLayout = false;
        if (portletMode.equals((Object)LiferayPortletMode.ABOUT) && !layoutType.hasModeAboutPortletId(portletId)) {
            layoutType.addModeAboutPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG) && !layoutType.hasModeConfigPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(request), (Layout)layout, (Portlet)portlet, (String)"CONFIGURATION")) {
            layoutType.addModeConfigPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.EDIT) && !layoutType.hasModeEditPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(request), (Layout)layout, (Portlet)portlet, (String)"PREFERENCES")) {
            layoutType.addModeEditPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS) && !layoutType.hasModeEditDefaultsPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(request), (Layout)layout, (Portlet)portlet, (String)"PREFERENCES")) {
            layoutType.addModeEditDefaultsPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST) && !layoutType.hasModeEditGuestPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(request), (Layout)layout, (Portlet)portlet, (String)"GUEST_PREFERENCES")) {
            layoutType.addModeEditGuestPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.HELP) && !layoutType.hasModeHelpPortletId(portletId)) {
            layoutType.addModeHelpPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW) && !layoutType.hasModePreviewPortletId(portletId)) {
            layoutType.addModePreviewPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT) && !layoutType.hasModePrintPortletId(portletId)) {
            layoutType.addModePrintPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.VIEW) && !layoutType.hasModeViewPortletId(portletId)) {
            layoutType.removeModesPortletId(portletId);
            updateLayout = true;
        }
        if (updateLayout && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(request), (Layout)layout, (Portlet)portlet, (String)"VIEW") && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
        }
        return portletMode;
    }

    public String updateRedirect(String redirect, String oldPath, String newPath) {
        if (Validator.isNull((String)redirect) || oldPath == null || oldPath.equals(newPath)) {
            return redirect;
        }
        String queryString = HttpUtil.getQueryString((String)redirect);
        String redirectParam = HttpUtil.getParameter((String)redirect, (String)"redirect", (boolean)false);
        if (Validator.isNotNull((String)redirectParam)) {
            String newRedirectParam = StringUtil.replace((String)redirectParam, (String)URLCodec.encodeURL((String)oldPath), (String)URLCodec.encodeURL((String)newPath));
            queryString = StringUtil.replace((String)queryString, (String)redirectParam, (String)newRedirectParam);
        }
        String redirectPath = HttpUtil.getPath((String)redirect);
        int pos = redirect.indexOf(redirectPath);
        String prefix = redirect.substring(0, pos);
        pos = redirectPath.lastIndexOf(oldPath);
        if (pos != -1) {
            prefix = prefix + redirectPath.substring(0, pos);
            String suffix = redirectPath.substring(pos + oldPath.length());
            redirect = prefix + newPath + suffix;
        } else {
            redirect = prefix + redirectPath;
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + "?" + queryString;
        }
        return redirect;
    }

    public WindowState updateWindowState(String portletId, User user, Layout layout, WindowState windowState, HttpServletRequest request) {
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (windowState == null || Validator.isNull((String)windowState.toString())) {
            windowState = layoutType.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutType.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        } else {
            LayoutClone layoutClone;
            boolean updateLayout = false;
            if (windowState.equals((Object)WindowState.MAXIMIZED) && !layoutType.hasStateMaxPortletId(portletId)) {
                layoutType.addStateMaxPortletId(portletId);
                if (PropsValues.LAYOUT_REMEMBER_MAXIMIZED_WINDOW_STATE) {
                    updateLayout = true;
                }
            } else if (windowState.equals((Object)WindowState.MINIMIZED) && !layoutType.hasStateMinPortletId(portletId)) {
                layoutType.addStateMinPortletId(portletId);
                updateLayout = true;
            } else if (windowState.equals((Object)WindowState.NORMAL) && !layoutType.hasStateNormalPortletId(portletId)) {
                layoutType.removeStatesPortletId(portletId);
                updateLayout = true;
            }
            if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
                layoutClone.update(request, layout.getPlid(), layout.getTypeSettings());
            }
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setStateExclusive(windowState.equals((Object)LiferayWindowState.EXCLUSIVE));
        themeDisplay.setStateMaximized(windowState.equals((Object)WindowState.MAXIMIZED));
        themeDisplay.setStatePopUp(windowState.equals((Object)LiferayWindowState.POP_UP));
        request.setAttribute("WINDOW_STATE", (Object)windowState);
        return windowState;
    }

    @Deprecated
    protected void addDefaultResource(long companyId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException {
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(companyId, groupId, portlet);
    }

    @Deprecated
    protected void addDefaultResource(long companyId, long groupId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException {
        this.addRootModelResource(companyId, groupId, portlet);
    }

    @Deprecated
    protected void addRootModelResource(long companyId, long groupId, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource((String)portlet.getRootPortletId());
        if (Validator.isNull((String)name)) {
            return;
        }
        this.addRootModelResource(companyId, groupId, name);
    }

    protected void addRootModelResource(long companyId, long groupId, String name) throws PortalException {
        String primaryKey;
        int count;
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group != null && group.isStagingGroup()) {
            groupId = group.getLiveGroupId();
        }
        if ((count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)name, (int)4, (String)(primaryKey = String.valueOf(groupId)))) > 0) {
            return;
        }
        ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)0L, (String)name, (String)primaryKey, (boolean)false, (boolean)true, (boolean)true);
    }

    protected String buildI18NPath(Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this._buildI18NPath(languageId, locale);
    }

    protected Set<Group> doGetAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) {
        Group siteGroup = this._getSiteGroup(groupId);
        if (siteGroup == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Group> groups = null;
        for (Group group : siteGroup.getAncestors()) {
            if (checkContentSharingWithChildrenEnabled && !SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) continue;
            if (groups == null) {
                groups = new LinkedHashSet<Group>();
            }
            groups.add(group);
        }
        if (!siteGroup.isCompany()) {
            String cacheKey;
            ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)Company.class.getName()));
            Group companyGroup = (Group)threadLocalCache.get(cacheKey = StringUtil.toHexString((long)siteGroup.getCompanyId()));
            if (companyGroup == null) {
                companyGroup = GroupLocalServiceUtil.fetchCompanyGroup((long)siteGroup.getCompanyId());
                threadLocalCache.put(cacheKey, (Object)companyGroup);
            }
            if (companyGroup != null) {
                if (groups == null) {
                    return Collections.singleton(companyGroup);
                }
                groups.add(companyGroup);
                return groups;
            }
        }
        if (groups == null) {
            return Collections.emptySet();
        }
        return groups;
    }

    protected Group doGetCurrentSiteGroup(long groupId) throws PortalException {
        Group siteGroup = this._getSiteGroup(groupId);
        if (!siteGroup.isLayoutPrototype()) {
            return siteGroup;
        }
        return null;
    }

    protected long doGetPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                groupId = scopeLayout.getGroupId();
            }
        }
        catch (Exception group) {
            // empty catch block
        }
        long plid = 0L;
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String)"portlet");
        for (Layout layout : layouts) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            if (!layoutTypePortlet.hasPortletId(portletId, true) || this.getScopeGroupId(layout, portletId) != scopeGroupId) continue;
            plid = layout.getPlid();
            break;
        }
        return plid;
    }

    protected List<Portlet> filterControlPanelPortlets(Set<Portlet> portlets, ThemeDisplay themeDisplay) {
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>(portlets);
        Iterator itr = filteredPortlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            try {
                if (portlet.isActive() && !portlet.isInstanceable() && PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (Portlet)portlet)) continue;
                itr.remove();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                itr.remove();
            }
        }
        return filteredPortlets;
    }

    protected Locale getAvailableLocale(long groupId, Locale locale) {
        if (Validator.isNull((String)locale.getCountry())) {
            locale = LanguageUtil.getLocale((String)locale.getLanguage());
        }
        if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)locale)) {
            return null;
        }
        return locale;
    }

    protected Layout getBrowsableLayout(Layout layout) {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (layoutTypeController.isBrowsable()) {
            return layout;
        }
        Layout browsableChildLayout = null;
        List childLayouts = layout.getAllChildren();
        for (Layout childLayout : childLayouts) {
            LayoutTypeController childLayoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(childLayout.getType());
            if (!childLayoutTypeController.isBrowsable()) continue;
            browsableChildLayout = childLayout;
            break;
        }
        if (browsableChildLayout != null) {
            return browsableChildLayout;
        }
        long defaultPlid = LayoutLocalServiceUtil.getDefaultPlid((long)layout.getGroupId(), (boolean)layout.getPrivateLayout());
        return LayoutLocalServiceUtil.fetchLayout((long)defaultPlid);
    }

    protected String getCanonicalDomain(String virtualHostname, String portalDomain) {
        if (Validator.isBlank((String)portalDomain) || StringUtil.equalsIgnoreCase((String)portalDomain, (String)_LOCALHOST) || !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
            return virtualHostname;
        }
        int pos = portalDomain.indexOf(58);
        if (pos == -1) {
            return portalDomain;
        }
        return portalDomain.substring(0, pos);
    }

    protected String getContextPath(String contextPath) {
        if ((contextPath = GetterUtil.getString((String)contextPath)).length() == 0 || contextPath.equals("/")) {
            contextPath = "";
        } else if (!contextPath.startsWith("/")) {
            contextPath = "/".concat(contextPath);
        }
        return contextPath;
    }

    protected Group getControlPanelDisplayGroup(Group controlPanelGroup, Group scopeGroup, long doAsGroupId, String portletId) {
        Group doAsGroup;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)controlPanelGroup.getCompanyId(), (String)portletId);
        String portletCategory = portlet.getControlPanelEntryCategory();
        if (portletCategory.equals("control_panel.apps") || portletCategory.equals("control_panel.configuration") || portletCategory.equals("control_panel.sites") || portletCategory.equals("control_panel.system") || portletCategory.equals("control_panel.users") || portletCategory.equals("user.my_account")) {
            return controlPanelGroup;
        }
        if (doAsGroupId > 0L && (doAsGroup = GroupLocalServiceUtil.fetchGroup((long)doAsGroupId)) != null) {
            return doAsGroup;
        }
        return scopeGroup;
    }

    protected Group getControlPanelDisplayGroup(long companyId, long scopeGroupId, long doAsGroupId, String portletId) {
        return this.getControlPanelDisplayGroup(GroupLocalServiceUtil.fetchGroup((long)companyId, (String)"Control Panel"), GroupLocalServiceUtil.fetchGroup((long)scopeGroupId), doAsGroupId, portletId);
    }

    protected long getDoAsUserId(HttpServletRequest request, String doAsUserIdString, boolean alwaysAllowDoAsUser) throws Exception {
        if (Validator.isNull((String)doAsUserIdString)) {
            return 0L;
        }
        long doAsUserId = 0L;
        try {
            Company company = this.getCompany(request);
            doAsUserId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted"));
            }
            return 0L;
        }
        if (_log.isDebugEnabled()) {
            if (alwaysAllowDoAsUser) {
                _log.debug((Object)"doAsUserId path or Struts action is always allowed");
            } else {
                _log.debug((Object)"doAsUserId path is Struts action not always allowed");
            }
        }
        if (alwaysAllowDoAsUser) {
            request.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        HttpSession session = request.getSession();
        Long realUserIdObj = (Long)session.getAttribute("USER_ID");
        if (realUserIdObj == null) {
            return 0L;
        }
        User doAsUser = UserLocalServiceUtil.getUserById((long)doAsUserId);
        long[] organizationIds = doAsUser.getOrganizationIds();
        User realUser = UserLocalServiceUtil.getUserById((long)realUserIdObj);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)realUser);
        if (doAsUser.isDefaultUser() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)doAsUserId, (long[])organizationIds, (String)"IMPERSONATE")) {
            request.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        _log.error((Object)StringBundler.concat((String[])new String[]{"User ", String.valueOf(realUserIdObj), " does not have the permission to impersonate ", String.valueOf(doAsUserId)}));
        return 0L;
    }

    protected String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL) throws PortalException {
        return this.getGroupFriendlyURL(layoutSet, themeDisplay, canonicalURL, false);
    }

    protected String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Group group = themeDisplay.getSiteGroup();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        return this._getGroupFriendlyURL(group, layoutSet, themeDisplay, canonicalURL, controlPanel);
    }

    protected String[] getGroupPermissions(String[] groupPermissions, String className, String inputPermissionsShowOptions) {
        if (groupPermissions != null || inputPermissionsShowOptions != null) {
            return groupPermissions;
        }
        List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)className);
        return groupDefaultActions.toArray(new String[groupDefaultActions.size()]);
    }

    protected String[] getGuestPermissions(String[] guestPermissions, String className, String inputPermissionsShowOptions) {
        if (guestPermissions != null || inputPermissionsShowOptions != null) {
            return guestPermissions;
        }
        List guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)className);
        return guestDefaultActions.toArray(new String[guestDefaultActions.size()]);
    }

    protected String getPortletParam(HttpServletRequest request, String name) {
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return "";
        }
        Object value = null;
        int valueCount = 0;
        String keyName = "_".concat(name);
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String portletId1;
            String parameterName = (String)entry.getKey();
            int pos = parameterName.indexOf(keyName);
            if (pos == -1) continue;
            if (++valueCount > 1) {
                return "";
            }
            Object[] parameterValues = (String[])entry.getValue();
            if (ArrayUtil.isEmpty((Object[])parameterValues) || Validator.isNull((String)parameterValues[0]) || !portletId.equals(portletId1 = parameterName.substring(1, pos))) continue;
            value = parameterValues[0];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getServletURL(Portlet portlet, String servletPath, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        StringBundler sb = new StringBundler(9);
        sb.append(themeDisplay.getPortalURL());
        if (Validator.isNotNull((String)this._pathContext)) {
            sb.append(this._pathContext);
        }
        if (themeDisplay.isI18n()) {
            sb.append(themeDisplay.getI18nPath());
        }
        sb.append(servletPath);
        Group group = layout.getGroup();
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
            } else {
                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
            }
        } else {
            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
        }
        sb.append(group.getFriendlyURL());
        sb.append(themeDisplay.getLayoutFriendlyURL(layout));
        sb.append(_JOURNAL_ARTICLE_CANONICAL_URL_SEPARATOR);
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null && !portlet.isInstanceable()) {
            sb.append(friendlyURLMapper.getMapping());
        } else {
            sb.append(portlet.getPortletId());
        }
        return sb.toString();
    }

    protected boolean isAlwaysAllowDoAsUser(HttpServletRequest request) throws Exception {
        String ticketKey = ParamUtil.getString((HttpServletRequest)request, (String)"ticketKey");
        if (Validator.isNull((String)ticketKey)) {
            return false;
        }
        Ticket ticket = TicketLocalServiceUtil.fetchTicket((String)ticketKey);
        if (ticket == null || ticket.getType() != 2) {
            return false;
        }
        String className = ticket.getClassName();
        if (!className.equals(User.class.getName())) {
            return false;
        }
        long doAsUserId = 0L;
        try {
            Company company = this.getCompany(request);
            String doAsUserIdString = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
            if (Validator.isNotNull((String)doAsUserIdString)) {
                doAsUserId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
            }
        }
        catch (Exception e) {
            return false;
        }
        if (ticket.getClassPK() != doAsUserId) {
            return false;
        }
        if (ticket.isExpired()) {
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            return false;
        }
        Date expirationDate = new Date(System.currentTimeMillis() + (long)PropsValues.SESSION_TIMEOUT * 60000L);
        ticket.setExpirationDate(expirationDate);
        TicketLocalServiceUtil.updateTicket((Ticket)ticket);
        return true;
    }

    protected boolean isAlwaysAllowDoAsUser(String actionName, String mvcRenderCommandName, String path, String strutsAction) {
        for (AlwaysAllowDoAsUser alwaysAllowDoAsUser : this._alwaysAllowDoAsUsers) {
            Collection actionNames = alwaysAllowDoAsUser.getActionNames();
            if (actionNames.contains(actionName)) {
                return true;
            }
            Collection mvcRenderCommandNames = alwaysAllowDoAsUser.getMVCRenderCommandNames();
            if (mvcRenderCommandNames.contains(mvcRenderCommandName)) {
                return true;
            }
            Collection paths = alwaysAllowDoAsUser.getPaths();
            if (paths.contains(path)) {
                return true;
            }
            Collection strutsActions = alwaysAllowDoAsUser.getStrutsActions();
            if (!strutsActions.contains(strutsAction)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnwrapRequest(String currentRequestClassName) {
        for (String packageName : PropsValues.REQUEST_UNWRAP_PACKAGES) {
            if (!currentRequestClassName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return true;
        }
        if (!Validator.isHostName((String)domain)) {
            return false;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase((String)domain, (String)virtualHost) && !StringUtil.wildcardMatches((String)domain, (String)virtualHost, (char)'?', (char)'*', (char)'%', (boolean)false)) continue;
            return true;
        }
        if (StringUtil.equalsIgnoreCase((String)domain, (String)PropsValues.WEB_SERVER_HOST)) {
            return true;
        }
        if (this.isValidVirtualHostname(domain)) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((String)domain, (String)this.getCDNHostHttp(companyId))) {
            return true;
        }
        return StringUtil.equalsIgnoreCase((String)domain, (String)this.getCDNHostHttps(companyId));
    }

    protected boolean isValidPortalDomain(String domain) {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.isValidPortalDomain(companyId, domain);
    }

    protected boolean isValidVirtualHostname(String virtualHostname) {
        try {
            virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)virtualHostname);
            if (virtualHost != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void notifyPortalInetSocketAddressEventListeners(InetSocketAddress inetSocketAddress, boolean local, boolean secure) {
        for (PortalInetSocketAddressEventListener portalInetSocketAddressEventListener : this._portalInetSocketAddressEventListeners) {
            if (local) {
                portalInetSocketAddressEventListener.portalLocalInetSocketAddressConfigured(inetSocketAddress, secure);
                continue;
            }
            portalInetSocketAddressEventListener.portalServerInetSocketAddressConfigured(inetSocketAddress, secure);
        }
    }

    @Deprecated
    protected void notifyPortalPortEventListeners(int portalPort) {
        for (PortalPortEventListener portalPortEventListener : this._portalPortEventListeners) {
            portalPortEventListener.portalPortConfigured(portalPort);
        }
    }

    protected String removeRedirectParameter(String url) {
        String queryString = HttpUtil.getQueryString((String)url);
        Map parameterMap = HttpUtil.getParameterMap((String)queryString);
        for (String parameter : parameterMap.keySet()) {
            if (!parameter.endsWith("redirect")) continue;
            url = HttpUtil.removeParameter((String)url, (String)parameter);
        }
        return url;
    }

    protected void resetThemeDisplayI18n(ThemeDisplay themeDisplay, String languageId, String path, Locale locale) {
        themeDisplay.setI18nLanguageId(languageId);
        themeDisplay.setI18nPath(path);
        themeDisplay.setLocale(locale);
    }

    protected void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        HttpSession session = request.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
    }

    protected void setThemeDisplayI18n(ThemeDisplay themeDisplay, Locale locale) {
        String i18nPath = null;
        if (I18nFilter.getLanguageIds().contains(locale.toString()) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && !locale.equals(LocaleUtil.getDefault()) || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nPath = this.buildI18NPath(locale);
        }
        themeDisplay.setI18nLanguageId(locale.toString());
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setLocale(locale);
    }

    private String _buildI18NPath(String languageId, Locale locale) {
        if (Validator.isNull((String)languageId)) {
            return null;
        }
        if (LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                languageId = locale.getLanguage();
            }
        } else {
            languageId = locale.getLanguage();
        }
        return "/".concat(languageId);
    }

    private Map<Locale, String> _getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout, Set<Locale> availableLocales) throws PortalException {
        int y;
        String portalDomain;
        String virtualHostname = this.getVirtualHostname(themeDisplay.getLayoutSet());
        if (Validator.isNull((String)virtualHostname)) {
            Company company = themeDisplay.getCompany();
            virtualHostname = company.getVirtualHostname();
        }
        if (!Validator.isBlank((String)(portalDomain = themeDisplay.getPortalDomain())) && !StringUtil.equalsIgnoreCase((String)portalDomain, (String)_LOCALHOST) && StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
            virtualHostname = portalDomain;
        }
        HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
        if (Validator.isNull((String)virtualHostname)) {
            for (Locale locale : availableLocales) {
                String i18nPath = this.buildI18NPath(locale);
                alternateURLs.put(locale, canonicalURL.replaceFirst(_PUBLIC_GROUP_SERVLET_MAPPING, i18nPath.concat(_PUBLIC_GROUP_SERVLET_MAPPING)));
            }
            return alternateURLs;
        }
        int pos = canonicalURL.indexOf(virtualHostname);
        if (pos > 0) {
            pos = canonicalURL.indexOf(47, pos + virtualHostname.length());
            if (Validator.isNotNull((String)this._pathContext)) {
                pos = canonicalURL.indexOf(47, pos + this._pathContext.length());
            }
        }
        if (pos <= 0 || pos >= canonicalURL.length()) {
            for (Locale locale : availableLocales) {
                alternateURLs.put(locale, canonicalURL.concat(this.buildI18NPath(locale)));
            }
            return alternateURLs;
        }
        boolean replaceFriendlyURL = true;
        String currentURL = canonicalURL.substring(pos);
        int[] friendlyURLIndex = this.getGroupFriendlyURLIndex(currentURL);
        if (friendlyURLIndex != null && (currentURL = currentURL.substring(y = friendlyURLIndex[1])).equals("/")) {
            replaceFriendlyURL = false;
        }
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        List layoutFriendlyURLs = null;
        String groupFriendlyURLPrefix = null;
        if (replaceFriendlyURL) {
            layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                layout = virtualLayout.getSourceLayout();
                Group group = layout.getGroup();
                groupFriendlyURLPrefix = "/~".concat(group.getFriendlyURL());
            }
        }
        String canonicalURLPrefix = canonicalURL.substring(0, pos);
        String canonicalURLSuffix = canonicalURL.substring(pos);
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            String defaultLocalePath = this._buildI18NPath(siteDefaultLocale.getLanguage(), siteDefaultLocale);
            int canonicalURLSuffixPos = defaultLocalePath.length() + pos;
            canonicalURLSuffix = canonicalURLSuffixPos >= canonicalURL.length() ? "" : canonicalURL.substring(canonicalURLSuffixPos + 1);
        }
        for (Locale locale : availableLocales) {
            String alternateURL = canonicalURL;
            String alternateURLSuffix = canonicalURLSuffix;
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            if (replaceFriendlyURL) {
                String friendlyURL = null;
                for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                    if (!languageId.equals(layoutFriendlyURL.getLanguageId())) continue;
                    friendlyURL = layoutFriendlyURL.getFriendlyURL();
                    if (groupFriendlyURLPrefix == null) break;
                    friendlyURL = groupFriendlyURLPrefix.concat(friendlyURL);
                    break;
                }
                if (friendlyURL != null) {
                    alternateURLSuffix = StringUtil.replaceFirst((String)alternateURLSuffix, (String)layout.getFriendlyURL(), friendlyURL);
                }
                alternateURL = canonicalURLPrefix.concat(alternateURLSuffix);
            }
            if (siteDefaultLocale.equals(locale) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE != 2) {
                alternateURLs.put(locale, alternateURL);
                continue;
            }
            alternateURLs.put(locale, canonicalURLPrefix.concat(this._buildI18NPath(languageId, locale)).concat(alternateURLSuffix));
        }
        return alternateURLs;
    }

    private String _getGroupFriendlyURL(Group group, LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Layout refererLayout;
        long refererPlid;
        boolean privateLayoutSet = layoutSet.getPrivateLayout();
        String portalURL = themeDisplay.getPortalURL();
        boolean useGroupVirtualHostName = false;
        if (canonicalURL || !StringUtil.equalsIgnoreCase((String)themeDisplay.getServerName(), (String)_LOCALHOST)) {
            useGroupVirtualHostName = true;
        }
        if ((refererPlid = themeDisplay.getRefererPlid()) > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout((long)refererPlid)) != null && (refererLayout.getGroupId() != group.getGroupId() || refererLayout.isPrivateLayout() != privateLayoutSet)) {
            useGroupVirtualHostName = false;
        }
        if (useGroupVirtualHostName) {
            String virtualHostname = this.getVirtualHostname(layoutSet);
            String portalDomain = themeDisplay.getPortalDomain();
            if (Validator.isNotNull((String)virtualHostname) && (canonicalURL || !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST))) {
                if (!controlPanel) {
                    if (canonicalURL) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (!StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST) && !this._isSameHostName(virtualHostname, portalDomain)) {
                            portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                        }
                        return portalURL.concat(this._pathContext).concat(path);
                    }
                    if (this._isSameHostName(virtualHostname, portalDomain) && (virtualHostname.equals(layoutSet.getVirtualHostname()) || PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME.equals(group.getGroupKey()))) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (themeDisplay.isI18n()) {
                            path = themeDisplay.getI18nPath();
                        }
                        return portalURL.concat(this._pathContext).concat(path);
                    }
                }
            } else if (canonicalURL || layoutSet.getGroupId() != themeDisplay.getSiteGroupId() && group.getClassPK() != themeDisplay.getUserId()) {
                if (group.isControlPanel() && (Validator.isNull((String)(virtualHostname = themeDisplay.getServerName())) || StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST))) {
                    LayoutSet curLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)themeDisplay.getSiteGroupId(), (boolean)privateLayoutSet);
                    virtualHostname = curLayoutSet.getVirtualHostname();
                }
                if (Validator.isNull((String)virtualHostname) || StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
                    Company company = themeDisplay.getCompany();
                    virtualHostname = company.getVirtualHostname();
                }
                if (canonicalURL || !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)_LOCALHOST)) {
                    virtualHostname = this.getCanonicalDomain(virtualHostname, portalDomain);
                    portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                }
            }
        }
        String friendlyURL = null;
        friendlyURL = privateLayoutSet ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        StringBundler sb = new StringBundler(6);
        sb.append(portalURL);
        sb.append(this._pathContext);
        if (themeDisplay.isI18n() && !canonicalURL) {
            sb.append(themeDisplay.getI18nPath());
        }
        if (themeDisplay.isWidget()) {
            sb.append(PropsValues.WIDGET_SERVLET_MAPPING);
        }
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    private String _getPortalURL(String serverName, int serverPort, boolean secure) {
        StringBundler sb = new StringBundler(4);
        boolean https = false;
        if (secure || StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)) {
            https = true;
        }
        if (https) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(serverName);
        if (!https) {
            if (PropsValues.WEB_SERVER_HTTP_PORT == -1) {
                if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTP_PORT != 80) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTP_PORT);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT == -1) {
            if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                sb.append(":");
                sb.append(serverPort);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT != 443) {
            sb.append(":");
            sb.append(PropsValues.WEB_SERVER_HTTPS_PORT);
        }
        return sb.toString();
    }

    private String _getPortletTitle(String rootPortletId, PortletConfig portletConfig, Locale locale) {
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.title".concat(".").concat(rootPortletId), null);
        if (Validator.isNull((String)portletTitle)) {
            portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.title");
        }
        return portletTitle;
    }

    private long _getScopeGroupId(ThemeDisplay themeDisplay, Layout layout, String portletId) {
        if (layout == null) {
            return 0L;
        }
        if (Validator.isNull((String)portletId)) {
            return layout.getGroupId();
        }
        try {
            PortletPreferences portletSetup = null;
            portletSetup = themeDisplay == null ? PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup((Layout)layout, (String)portletId) : themeDisplay.getStrictLayoutPortletSetup(layout, portletId);
            String scopeType = GetterUtil.getString((String)portletSetup.getValue("lfrScopeType", null));
            if (Validator.isNull((String)scopeType)) {
                return layout.getGroupId();
            }
            if (scopeType.equals("company")) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                return companyGroup.getGroupId();
            }
            String scopeLayoutUuid = GetterUtil.getString((String)portletSetup.getValue("lfrScopeLayoutUuid", null));
            Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
            Group scopeGroup = scopeLayout.getScopeGroup();
            return scopeGroup.getGroupId();
        }
        catch (Exception e) {
            return layout.getGroupId();
        }
    }

    private String _getSiteAdminURL(String portalURL, Group group, String ppid, Map<String, String[]> params) throws PortalException {
        StringBundler sb = new StringBundler(7);
        sb.append(portalURL);
        sb.append(this.getPathFriendlyURLPrivateGroup());
        if (group != null && !group.isControlPanel()) {
            sb.append(group.getFriendlyURL());
            sb.append("/~");
        }
        sb.append("/control_panel");
        sb.append(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        params = params != null ? new LinkedHashMap<String, String[]>(params) : new LinkedHashMap<String, String[]>();
        if (Validator.isNotNull((String)ppid)) {
            params.put("p_p_id", new String[]{ppid});
        }
        params.put("p_p_lifecycle", new String[]{"0"});
        params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        sb.append(HttpUtil.parameterMapToString(params, (boolean)true));
        return sb.toString();
    }

    private Group _getSiteGroup(long groupId) {
        if (groupId <= 0L) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            return null;
        }
        if (group.isLayout()) {
            return group.getParentGroup();
        }
        return group;
    }

    private boolean _isSameHostName(String virtualHostName, String portalDomain) {
        int pos = portalDomain.indexOf(58);
        if (pos > 0) {
            return virtualHostName.regionMatches(0, portalDomain, 0, pos);
        }
        return virtualHostName.equals(portalDomain);
    }

    static {
        _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        _log = LogFactoryUtil.getLog(PortalImpl.class);
        _cdnHostHttpMap = new ConcurrentHashMap<Long, String>();
        _cdnHostHttpsMap = new ConcurrentHashMap<Long, String>();
        _resetCDNHostsMethodHandler = new MethodHandler(new MethodKey(PortalUtil.class, "resetCDNHosts", new Class[0]), new Object[0]);
        _upTime = new Date();
        Locale locale = Locale.getDefault();
        _NULL_LOCALE = (Locale)locale.clone();
    }

    private class PortalInetSocketAddressEventListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInetSocketAddressEventListener, PortalInetSocketAddressEventListener> {
        private PortalInetSocketAddressEventListenerServiceTrackerCustomizer() {
        }

        public PortalInetSocketAddressEventListener addingService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalInetSocketAddressEventListener portalInetSocketAddressEventListener = (PortalInetSocketAddressEventListener)registry.getService(serviceReference);
            PortalImpl.this.addPortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
            return portalInetSocketAddressEventListener;
        }

        public void modifiedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        }

        public void removedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            PortalImpl.this.removePortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
        }
    }

    private class AlwaysAllowDoAsUserServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AlwaysAllowDoAsUser, AlwaysAllowDoAsUser> {
        private AlwaysAllowDoAsUserServiceTrackerCustomizer() {
        }

        public AlwaysAllowDoAsUser addingService(ServiceReference<AlwaysAllowDoAsUser> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AlwaysAllowDoAsUser alwaysAllowDoAsUser = (AlwaysAllowDoAsUser)registry.getService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add alway sallow do as user " + ClassUtil.getClassName((Object)alwaysAllowDoAsUser)));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.add(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances"));
            }
            return alwaysAllowDoAsUser;
        }

        public void modifiedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
        }

        public void removedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Delete alway sallow do as user " + ClassUtil.getClassName((Object)alwaysAllowDoAsUser)));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.remove(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances"));
            }
        }
    }
}

