/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.dao.db.DBManagerImpl;
import com.liferay.portal.dao.jdbc.DataSourceFactoryImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.configuration.ConfigurationFactory;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactory;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedConnectionProviderRegistry;
import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedConnectionProviderRegistryUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.upgrade.dao.orm.UpgradeOptimizedConnectionProviderRegistryImpl;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.sun.syndication.io.XmlReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class InitUtil {
    private static final boolean _PRINT_TIME = false;
    private static ApplicationContext _appApplicationContext;
    private static boolean _initialized;

    public static synchronized void init() {
        if (_initialized) {
            return;
        }
        try {
            Field field;
            if (!OSDetector.isWindows() && ((Boolean)(field = ReflectionUtil.getDeclaredField(ZipFile.class, (String)"usemmap")).get(null)).booleanValue()) {
                field.setBoolean(null, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String userLanguage = SystemProperties.get((String)"user.language");
        String userCountry = SystemProperties.get((String)"user.country");
        String userVariant = SystemProperties.get((String)"user.variant");
        LocaleUtil.setDefault((String)userLanguage, (String)userCountry, (String)userVariant);
        String userTimeZone = SystemProperties.get((String)"user.timezone");
        TimeZoneUtil.setDefault((String)userTimeZone);
        try {
            PortalClassLoaderUtil.setClassLoader((ClassLoader)ClassLoaderUtil.getContextClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        com.liferay.portal.kernel.util.PropsUtil.setProps((Props)new PropsImpl());
        if (GetterUtil.getBoolean((String)SystemProperties.get((String)"log4j.configure.on.startup"), (boolean)true)) {
            ClassLoader classLoader = InitUtil.class.getClassLoader();
            Log4JUtil.configureLog4J((ClassLoader)classLoader);
        }
        try {
            LogFactoryUtil.setLogFactory((LogFactory)new Log4jLogFactoryImpl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SanitizerLogWrapper.init();
        SecurityManagerUtil.init();
        if (SecurityManagerUtil.ENABLED) {
            com.liferay.portal.kernel.util.PropsUtil.setProps((Props)DoPrivilegedUtil.wrap(com.liferay.portal.kernel.util.PropsUtil.getProps()));
            LogFactoryUtil.setLogFactory((LogFactory)DoPrivilegedUtil.wrap(LogFactoryUtil.getLogFactory()));
        }
        ConfigurationFactoryUtil.setConfigurationFactory((ConfigurationFactory)DoPrivilegedUtil.wrap(new ConfigurationFactoryImpl()));
        DataSourceFactoryUtil.setDataSourceFactory((DataSourceFactory)DoPrivilegedUtil.wrap(new DataSourceFactoryImpl()));
        DBManagerUtil.setDBManager((DBManager)DoPrivilegedUtil.wrap(new DBManagerImpl()));
        UpgradeOptimizedConnectionProviderRegistryUtil.setUpgradeOptimizedConnectionProviderRegistry((UpgradeOptimizedConnectionProviderRegistry)new UpgradeOptimizedConnectionProviderRegistryImpl());
        XmlReader.setDefaultEncoding((String)"UTF-8");
        _initialized = true;
    }

    public static synchronized void initWithSpring(boolean initModuleFramework, boolean registerContext) {
        List configLocations = ListUtil.fromArray((Object[])PropsUtil.getArray("spring.configs"));
        InitUtil.initWithSpring(configLocations, initModuleFramework, registerContext);
    }

    public static synchronized void initWithSpring(List<String> configLocations, boolean initModuleFramework, boolean registerContext) {
        if (_initialized) {
            return;
        }
        InitUtil.init();
        try {
            if (initModuleFramework) {
                PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = System.getProperty("java.io.tmpdir");
                ModuleFrameworkUtilAdapter.initFramework();
            }
            ArrayApplicationContext infrastructureApplicationContext = new ArrayApplicationContext(PropsValues.SPRING_INFRASTRUCTURE_CONFIGS);
            if (initModuleFramework) {
                ModuleFrameworkUtilAdapter.registerContext((Object)infrastructureApplicationContext);
                ModuleFrameworkUtilAdapter.startFramework();
            }
            ClassPathXmlApplicationContext appApplicationContext = new ClassPathXmlApplicationContext(configLocations.toArray(new String[configLocations.size()]), (ApplicationContext)infrastructureApplicationContext);
            BeanLocatorImpl beanLocator = new BeanLocatorImpl(ClassLoaderUtil.getPortalClassLoader(), (ApplicationContext)appApplicationContext);
            PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocator);
            if (initModuleFramework) {
                ModuleFrameworkUtilAdapter.startRuntime();
            }
            _appApplicationContext = appApplicationContext;
            if (initModuleFramework && registerContext) {
                InitUtil.registerContext();
            }
            InitUtil.registerSpringInitialized();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        _initialized = true;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    public static void registerContext() {
        if (_appApplicationContext != null) {
            ModuleFrameworkUtilAdapter.registerContext(_appApplicationContext);
        }
    }

    public static void registerSpringInitialized() {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("module.service.lifecycle", "spring.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        final ServiceRegistration moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, properties);
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            protected void doPortalInit() {
            }
        }, (int)1);
    }

    public static synchronized void stopModuleFramework() {
        try {
            ModuleFrameworkUtilAdapter.stopFramework(0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void stopRuntime() {
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

