/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.struts.StrutsPortletAction;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.struts.ActionAdapter;
import com.liferay.portal.struts.PortletActionAdapter;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.struts.action.Action;

public class StrutsActionRegistryUtil {
    private static final Map<String, Action> _actions = new ConcurrentHashMap<String, Action>();
    private static final ServiceTracker<?, Action> _serviceTracker;
    private static final StringServiceRegistrationMap<StrutsAction> _strutsActionServiceRegistrations;
    private static final StringServiceRegistrationMap<StrutsPortletAction> _strutsPortletActionServiceRegistrations;

    public static Action getAction(String path) {
        Action action = _actions.get(path);
        if (action != null) {
            return action;
        }
        for (Map.Entry<String, Action> entry : _actions.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Map<String, Action> getActions() {
        return _actions;
    }

    public static void register(String path, StrutsAction strutsAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsAction.class, (Object)strutsAction, properties);
        _strutsActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    public static void register(String path, StrutsPortletAction strutsPortletAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsPortletAction.class, (Object)strutsPortletAction, properties);
        _strutsPortletActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    public static void unregister(String path) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)_strutsActionServiceRegistrations.remove((Object)path);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        if ((serviceRegistration = (ServiceRegistration)_strutsPortletActionServiceRegistrations.remove((Object)path)) != null) {
            serviceRegistration.unregister();
        }
    }

    static {
        _strutsActionServiceRegistrations = new StringServiceRegistrationMapImpl();
        _strutsPortletActionServiceRegistrations = new StringServiceRegistrationMapImpl();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter(StringBundler.concat((String[])new String[]{"(&(|(objectClass=", StrutsAction.class.getName(), ")(objectClass=", StrutsPortletAction.class.getName(), "))(path=*))"}));
        _serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new ActionServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class ActionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Action> {
        private ActionServiceTrackerCustomizer() {
        }

        public Action addingService(ServiceReference<Object> serviceReference) {
            String[] paths;
            Registry registry = RegistryUtil.getRegistry();
            Object service = registry.getService(serviceReference);
            Action action = null;
            if (service instanceof StrutsAction) {
                action = new ActionAdapter((StrutsAction)service);
            } else if (service instanceof StrutsPortletAction) {
                action = new PortletActionAdapter((StrutsPortletAction)service);
            }
            for (String path : paths = this._getPaths(serviceReference)) {
                _actions.put(path, action);
            }
            return action;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Action service) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Action service) {
            String[] paths;
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            for (String path : paths = this._getPaths(serviceReference)) {
                _actions.remove(path);
            }
        }

        private String[] _getPaths(ServiceReference<Object> serviceReference) {
            Object object = serviceReference.getProperty("path");
            if (object instanceof String[]) {
                return (String[])object;
            }
            return new String[]{(String)object};
        }
    }
}

