/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermission;

public class UserGroupRolePermissionImpl
implements UserGroupRolePermission {
    public void check(PermissionChecker permissionChecker, Group group, Role role) throws PortalException {
        if (!this.contains(permissionChecker, group, role)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, roleId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Group group, Role role) throws PortalException {
        String roleName;
        if (role.getType() == 1) {
            return false;
        }
        if (role.getType() == 3 && !group.isOrganization()) {
            return false;
        }
        if (!permissionChecker.isCompanyAdmin() && !permissionChecker.isGroupOwner(group.getGroupId()) && ((roleName = role.getName()).equals("Organization Administrator") || roleName.equals("Organization Owner") || roleName.equals("Site Administrator") || roleName.equals("Site Owner"))) {
            return false;
        }
        return permissionChecker.isGroupOwner(group.getGroupId()) || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_USER_ROLES") || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getOrganizationId(), (String)"ASSIGN_USER_ROLES") || RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (long)role.getRoleId(), (String)"ASSIGN_MEMBERS");
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Role role = RoleLocalServiceUtil.getRole((long)roleId);
        return this.contains(permissionChecker, group, role);
    }
}

