/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONWebServiceServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.servlet.JSONServlet;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONWebServiceServlet
extends JSONServlet {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceServlet.class);

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (!PropsValues.JSONWS_WEB_SERVICE_API_DISCOVERABLE || !path.equals("") && !path.equals("/") || request.getParameter("discover") != null) {
            Locale locale = PortalUtil.getLocale((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
            LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
            super.service(request, response);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Servlet context " + request.getContextPath()));
        }
        String portalContextPath = PortalContextLoaderListener.getPortalServletContextPath();
        String requestContextPath = request.getContextPath();
        if (requestContextPath.equals(portalContextPath)) {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher("/c/portal/api/jsonws");
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            ServletContext servletContext = this.getServletContext();
            String redirectPath = PortalUtil.getPathContext() + "/api/jsonws?contextName=" + URLCodec.encodeURL((String)servletContext.getServletContextName());
            response.sendRedirect(redirectPath);
        }
    }

    @Override
    protected JSONAction getJSONAction(ServletContext servletContext) {
        JSONWebServiceServiceAction jsonWebServiceServiceAction = new JSONWebServiceServiceAction();
        jsonWebServiceServiceAction.setServletContext(servletContext);
        return jsonWebServiceServiceAction;
    }
}

