/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.kernel.image.Ghostscript;
import com.liferay.portal.kernel.image.ImageMagickUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.LoggingOutputProcessor;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;

public class GhostscriptImpl
implements Ghostscript {
    private static final String _GHOSTSCRIPT_COMMAND_UNIX = "gs";
    private static final String[] _GHOSTSCRIPT_COMMAND_WINDOWS = new String[]{"gswin32c", "gswin64c"};
    private static final Log _log = LogFactoryUtil.getLog(GhostscriptImpl.class);
    private String _commandPath;
    private String _globalSearchPath;

    public Future<?> execute(List<String> commandArguments) throws Exception {
        if (!this.isEnabled()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Cannot execute the Ghostscript command. Please ");
            sb.append("install ImageMagick and Ghostscript and enable ");
            sb.append("ImageMagick in portal-ext.properties or in the Server ");
            sb.append("Administration section of the Control Panel at: ");
            sb.append("http://<server>/group/control_panel/manage/-/server/");
            sb.append("external-services");
            throw new IllegalStateException(sb.toString());
        }
        LinkedList<String> arguments = new LinkedList<String>();
        arguments.add(this._commandPath);
        arguments.add("-dBATCH");
        arguments.add("-dSAFER");
        arguments.add("-dNOPAUSE");
        arguments.add("-dNOPROMPT");
        arguments.add("-sFONTPATH=" + this._globalSearchPath);
        arguments.addAll(commandArguments);
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(arguments.size() * 2);
            for (String argument : arguments) {
                sb.append(argument);
                sb.append(" ");
            }
            _log.info((Object)("Executing command '" + sb.toString() + "'"));
        }
        return ProcessUtil.execute((OutputProcessor)LoggingOutputProcessor.INSTANCE, arguments);
    }

    public boolean isEnabled() {
        return ImageMagickUtil.isEnabled();
    }

    public void reset() {
        if (this.isEnabled()) {
            try {
                this._globalSearchPath = ImageMagickUtil.getGlobalSearchPath();
                this._commandPath = this.getCommandPath();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected String getCommandPath() throws Exception {
        String commandPath = null;
        commandPath = OSDetector.isWindows() ? this.getCommandPathWindows() : this.getCommandPathUnix();
        if (commandPath == null) {
            StringBundler sb = new StringBundler(4);
            sb.append("Unable to find the Ghostscript command. Please verify ");
            sb.append("the path specified in the Server Administration ");
            sb.append("control panel at: http://<server>/group/control_panel/");
            sb.append("manage/-/server/external-services");
            throw new FileNotFoundException(sb.toString());
        }
        return commandPath;
    }

    protected String getCommandPathUnix() throws Exception {
        String[] dirNames;
        for (String dirName : dirNames = this._globalSearchPath.split(File.pathSeparator)) {
            File file = new File(dirName, _GHOSTSCRIPT_COMMAND_UNIX);
            if (!file.exists()) continue;
            return file.getCanonicalPath();
        }
        return null;
    }

    protected String getCommandPathWindows() throws Exception {
        String[] dirNames;
        for (String dirName : dirNames = this._globalSearchPath.split(File.pathSeparator)) {
            for (String command : _GHOSTSCRIPT_COMMAND_WINDOWS) {
                File file = new File(dirName, command + ".exe");
                if (!file.exists() && !(file = new File(dirName, command + ".cmd")).exists() && !(file = new File(dirName, command + ".bat")).exists()) continue;
                return file.getCanonicalPath();
            }
        }
        return null;
    }
}

