/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.apache.bridges.struts.LiferayServletContextProvider;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.CustomUserAttributes;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.util.JS;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.Portlet;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import org.apache.portals.bridges.struts.StrutsPortlet;

public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static final Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static final Map<String, Boolean> _dataSourceBindStates = new HashMap<String, Boolean>();
    private static final Map<String, List<com.liferay.portal.kernel.model.Portlet>> _portlets = new HashMap<String, List<com.liferay.portal.kernel.model.Portlet>>();
    private final Map<String, ServiceRegistration<ResourceBundleLoader>> _resourceBundleLoaderServiceRegistrations = new HashMap<String, ServiceRegistration<ResourceBundleLoader>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering portlets for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering portlets for ", t);
        }
    }

    protected void checkResourceBundles(ClassLoader classLoader, com.liferay.portal.kernel.model.Portlet portlet) {
        if (Validator.isNull((String)portlet.getResourceBundle())) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        ResourceBundleLoader resourceBundleLoader = ResourceBundleUtil.getResourceBundleLoader((String)portlet.getResourceBundle(), (ClassLoader)classLoader);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("resource.bundle.base.name", portlet.getResourceBundle());
        properties.put("service.ranking", Integer.MIN_VALUE);
        properties.put("servlet.context.name", portlet.getContextName());
        this._resourceBundleLoaderServiceRegistrations.put(portlet.getPortletId(), (ServiceRegistration<ResourceBundleLoader>)registry.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, properties));
    }

    @Deprecated
    protected void destroyPortlet(com.liferay.portal.kernel.model.Portlet portlet, Set<String> portletIds) throws Exception {
        this._destroyPortlet(null, portlet, portletIds);
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))})[0] == null && xmls[1] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering portlets for " + servletContextName));
        }
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        List portlets = PortletLocalServiceUtil.initWAR((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        boolean portletAppInitialized = false;
        boolean strutsBridges = false;
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        for (com.liferay.portal.kernel.model.Portlet portlet : portlets) {
            Portlet portletInstance;
            PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
            if (!portletAppInitialized) {
                this.initPortletApp(servletContextName, servletContext, classLoader, portlet);
                portletAppInitialized = true;
            }
            if (!ClassUtil.isSubclass((portletInstance = portletBag.getPortletInstance()).getClass(), (String)StrutsPortlet.class.getName())) continue;
            strutsBridges = true;
        }
        if (!strutsBridges) {
            strutsBridges = GetterUtil.getBoolean((String)servletContext.getInitParameter("struts-bridges-context-provider"));
        }
        if (strutsBridges) {
            servletContext.setAttribute("STRUTS_BRIDGES_CONTEXT_PROVIDER", (Object)new LiferayServletContextProvider());
        }
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay((String)servletContextName, (String)xml);
        long[] companyIds = PortalInstances.getCompanyIds();
        for (long companyId : companyIds) {
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
                continue;
            }
            _log.error((Object)("Unable to register portlet for company " + companyId + " because it does not exist"));
        }
        this.processPortletProperties(servletContextName, classLoader);
        Object object = portlets.iterator();
        while (object.hasNext()) {
            com.liferay.portal.kernel.model.Portlet portlet = (com.liferay.portal.kernel.model.Portlet)object.next();
            ResourceActionsUtil.check((String)portlet.getPortletId());
            this.checkResourceBundles(classLoader, portlet);
            for (long companyId : companyIds) {
                com.liferay.portal.kernel.model.Portlet curPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portlet.getPortletId());
                PortletLocalServiceUtil.checkPortlet((com.liferay.portal.kernel.model.Portlet)curPortlet);
            }
        }
        for (com.liferay.portal.kernel.model.Portlet portlet : portlets) {
            boolean ready = GetterUtil.getBoolean((String)servletContext.getInitParameter("portlets-ready-by-default"), (boolean)true);
            portlet.setReady(ready);
        }
        JavadocManagerUtil.load((String)servletContextName, (ClassLoader)classLoader);
        DirectServletRegistryUtil.clearServlets();
        FileTimestampUtil.reset();
        _portlets.put(servletContextName, portlets);
        servletContext.setAttribute("PLUGIN_PORTLETS", (Object)portlets);
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)StringBundler.concat((String[])new String[]{String.valueOf(portlets.size()), " portlets for ", servletContextName, " are available for use"}));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<com.liferay.portal.kernel.model.Portlet> portlets;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((portlets = _portlets.remove(servletContextName)) == null) {
            return;
        }
        HashSet<String> portletIds = new HashSet<String>();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unregistering portlets for " + servletContextName));
        }
        for (com.liferay.portal.kernel.model.Portlet portlet : portlets) {
            this._destroyPortlet(servletContext, portlet, portletIds);
        }
        ServletContextPool.remove((String)servletContextName);
        if (!portletIds.isEmpty()) {
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIds()) {
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
            }
        }
        PortletContextBagPool.remove(servletContextName);
        JavadocManagerUtil.unload((String)servletContextName);
        DirectServletRegistryUtil.clearServlets();
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)StringBundler.concat((String[])new String[]{String.valueOf(portlets.size()), " portlets for ", servletContextName, " were unregistered"}));
            }
        }
    }

    protected void initPortletApp(String servletContextName, ServletContext servletContext, ClassLoader classLoader, com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        PortletContextBag portletContextBag = PortletContextBagPool.get(servletContextName);
        PortletApp portletApp = portlet.getPortletApp();
        servletContext.setAttribute("com.liferay.portal.kernel.model.PortletApp", (Object)portletApp);
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributes.entrySet()) {
            String attrCustomClass = (String)entry.getValue();
            Class<?> clazz = classLoader.loadClass(attrCustomClass);
            CustomUserAttributes customUserAttributesInstance = (CustomUserAttributes)clazz.newInstance();
            portletContextBag.getCustomUserAttributes().put(attrCustomClass, customUserAttributesInstance);
        }
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            javax.portlet.filter.PortletFilter portletFilterInstance = (javax.portlet.filter.PortletFilter)this.newInstance(classLoader, new Class[]{ActionFilter.class, EventFilter.class, javax.portlet.filter.PortletFilter.class, RenderFilter.class, ResourceFilter.class}, portletFilter.getFilterClass());
            portletContextBag.getPortletFilters().put(portletFilter.getFilterName(), portletFilterInstance);
        }
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((com.liferay.portal.kernel.model.Portlet)portlet, (ServletContext)servletContext);
        invokerPortlet.setPortletFilters();
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)this.newInstance(classLoader, PortletURLGenerationListener.class, portletURLListener.getListenerClass());
            portletContextBag.getPortletURLListeners().put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void processPortletProperties(String servletContextName, ClassLoader classLoader) throws Exception {
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        if (portletProperties.isEmpty()) {
            return;
        }
        ResourceActionsUtil.read((String)servletContextName, (ClassLoader)classLoader, (String[])StringUtil.split((String)portletProperties.getProperty("resource.actions.configs")));
    }

    protected void unbindDataSource(String servletContextName) {
        block8: {
            Boolean dataSourceBindState = _dataSourceBindStates.remove(servletContextName);
            if (dataSourceBindState == null) {
                return;
            }
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Dynamically unbinding the Liferay data source");
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                    context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                try {
                    context.lookup(_JNDI_JDBC);
                    context.destroySubcontext(_JNDI_JDBC);
                }
                catch (NamingException namingException) {}
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to dynamically unbind the Liferay data source: " + e.getMessage()));
            }
        }
    }

    private void _destroyPortlet(ServletContext servletContext, com.liferay.portal.kernel.model.Portlet portlet, Set<String> portletIds) throws Exception {
        String servletContextName;
        portlet.unsetReady();
        PortletApp portletApp = portlet.getPortletApp();
        Set portletFilters = portletApp.getPortletFilters();
        for (Object portletFilter : portletFilters) {
            PortletFilterFactory.destroy((PortletFilter)portletFilter);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        PortletInstanceFactoryUtil.destroy((com.liferay.portal.kernel.model.Portlet)portlet);
        portletIds.add(portlet.getPortletId());
        ServiceRegistration<ResourceBundleLoader> resourceBundleLoaderServiceRegistration = this._resourceBundleLoaderServiceRegistrations.remove(portlet.getPortletId());
        if (resourceBundleLoaderServiceRegistration != null) {
            resourceBundleLoaderServiceRegistration.unregister();
        }
        String portletName = portlet.getPortletName();
        if (servletContext != null && (servletContextName = servletContext.getServletContextName()) != null) {
            portletName = portletName.concat("_WAR_");
            portletName = portletName.concat(servletContextName);
        }
        portletName = JS.getSafeName((String)portletName);
        ResourceActionsUtil.removePortletResource((String)portletName);
    }
}

