/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.DynamicResourceIncludeUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.PortletResourcesUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;

public class ResourceUtil {
    public static ObjectValuePair<ServletContext, URL> getObjectValuePair(String requestPath, String requestURI, ServletContext defaultServletContext) throws IOException {
        ServletContext servletContext = defaultServletContext;
        URL resourceURL = servletContext.getResource(requestURI);
        if (resourceURL != null) {
            return new ObjectValuePair<ServletContext, URL>(servletContext, resourceURL);
        }
        servletContext = PortalWebResourcesUtil.getPathServletContext(requestPath);
        resourceURL = PortalWebResourcesUtil.getResource(servletContext, requestPath);
        if (resourceURL != null) {
            return new ObjectValuePair<ServletContext, URL>(servletContext, resourceURL);
        }
        servletContext = PortletResourcesUtil.getPathServletContext(requestPath);
        resourceURL = PortletResourcesUtil.getResource(servletContext, requestPath);
        if (resourceURL != null) {
            return new ObjectValuePair<ServletContext, URL>(servletContext, resourceURL);
        }
        servletContext = DynamicResourceIncludeUtil.getPathServletContext(requestPath);
        resourceURL = DynamicResourceIncludeUtil.getResource(servletContext, requestPath);
        if (resourceURL != null) {
            return new ObjectValuePair<ServletContext, URL>(servletContext, resourceURL);
        }
        return null;
    }

    public static ServletContext getPathServletContext(String requestPath, String requestURI, ServletContext defaultServletContext) throws IOException {
        ObjectValuePair<ServletContext, URL> objectValuePair = ResourceUtil.getObjectValuePair(requestPath, requestURI, defaultServletContext);
        if (objectValuePair == null) {
            return null;
        }
        return objectValuePair.getKey();
    }

    public static URL getResourceURL(String requestPath, String requestURI, ServletContext defaultServletContext) throws IOException {
        ObjectValuePair<ServletContext, URL> objectValuePair = ResourceUtil.getObjectValuePair(requestPath, requestURI, defaultServletContext);
        if (objectValuePair == null) {
            return null;
        }
        return objectValuePair.getValue();
    }
}

